void keydown_handler(HWND hwnd,
   UINT uMsg,
   WPARAM wParam,
   LPARAM lParam)
{
 int scan=(lParam>>16)&511;
 switch (scan)
  {
   case 0x0b:  //Taste '0'
   if (!(fenster2d_aktiv))
     opengl.switch_view();
   break;
   case 0x0a:  //Taste '9'
   if (!(fenster2d_aktiv))
     opengl.switch_object_style();
   break;
   case 0x1e:  //Taste 'A'
   autopilot_aktiv=(autopilot_aktiv+1)&1;
   break;
   case 0x09:  // Taste '8'
   show_grid=(show_grid+1)&1;
   break;
   case 0x08:  // Taste '7'
   show_stars=(show_stars+1)&1;
   break;
   case 0x07:  // Taste '6'
   show_velocity=(show_velocity+1)&1;
   break;
   case 0x10: //Taste 'Q'
   keyleft=1;
   break;
   case 0x11: //Taste 'W'
   keyright=1;
   break;
   case 0x39: //Tase ' '
   keyhyper=1;
   break;
   case 0x17: //Taste'I'
   keythrust=1;
   break;
   case 0x18: //Taste 'O'
   keyfire=1;
   break;
   case 0x23: //Taste 'H'
   keyhelp=1;
   break;
   default:
   break;
  };
};
void keyup_handler(HWND hwnd,
   UINT uMsg,
   WPARAM wParam,
   LPARAM lParam)
{
 int scan=(lParam>>16)&511;
 switch (scan)
  {
   case 0x10: //Taste 'Q'
   keyleft=0;
   break;
   case 0x11: //Taste 'W'
   keyright=0;
   break;
   case 0x39: //Tase ' '
   keyhyper=0;
   break;
   case 0x17: //Taste'I'
   keythrust=0;
   break;
   case 0x18: //Taste 'O'
   keyfire=0;
   break;
   case 0x23: //Taste 'H'
   keyhelp=0;
   break;
   default:
   break;
  };
};

void create_main_window(HINSTANCE hinst)
{
 main_class.style=CS_HREDRAW | CS_VREDRAW | CS_OWNDC;
 main_class.lpfnWndProc=(WNDPROC) main_window_cb;
 main_class.cbClsExtra=0;
 main_class.cbWndExtra=0;
 main_class.hInstance=hinst;
 main_class.hIcon=LoadIcon(NULL, IDI_WINLOGO);
 main_class.hCursor=LoadCursor(NULL, IDC_ARROW);
 main_class.hbrBackground=0;
 main_class.lpszMenuName=NULL;
 main_class.lpszClassName="Asteroids 2D-client";
 RegisterClass(&main_class);
 main_hwnd=CreateWindow(
   "Asteroids 2D-client",
   "Asteroids 2D-client",
   WS_OVERLAPPED | WS_CLIPCHILDREN | WS_CLIPSIBLINGS |
   WS_VISIBLE | WS_SYSMENU | WS_MINIMIZEBOX | WS_SIZEBOX,
   CW_USEDEFAULT,0,
   640,640,
   NULL,  //Parent
   NULL,
   hinst,NULL
   );
 size_window(512);
 ShowWindow(main_hwnd,SW_SHOW);
};


LRESULT CALLBACK main_window_cb(
   HWND hwnd,
   UINT uMsg,
   WPARAM wParam,
   LPARAM lParam)
{
 switch (uMsg)
  {
   case WM_KEYDOWN:
    keydown_handler(hwnd,uMsg,wParam,lParam);
    break;
   case WM_KEYUP:
    keyup_handler(hwnd,uMsg,wParam,lParam);
    break;
   case WM_DESTROY:
   DeleteObject(brush_black);
   DeleteObject(brush_white);
   DeleteObject(brush_gloom);
   DeleteObject(brush_red);
   DeleteObject(pen_gloom);
   DeleteObject(pen_white);
   DeleteObject(pen_black);
   SelectObject(background_dc,0);
   DeleteDC(background_dc);
   background_dc=0;
   DeleteObject(background);
   background=0;

   ReleaseDC(hwnd,main_dc);
   main_dc=0;
   main_hwnd=0;
   main_quit=1;
   break;
   case WM_CREATE:
    {
     main_dc=GetDC(hwnd);
     main_game=NULL;
     RECT rect;
     GetClientRect(hwnd,&rect);
     GetClientRect(hwnd,&main_size);
     background=CreateCompatibleBitmap(main_dc,rect.right,rect.bottom);
     background_dc=CreateCompatibleDC(main_dc);
     SelectObject(background_dc,background);
     brush_black=CreateSolidBrush(0);
     brush_white=CreateSolidBrush(0xa0a0a0);
     brush_gloom=CreateSolidBrush(0xffffff);
     brush_red=CreateSolidBrush(0x0000ff);
     pen_white=CreatePen(PS_SOLID,0,0x0a0a0a0);
     pen_black=CreatePen(PS_SOLID,0,0);
     pen_black=CreatePen(PS_SOLID,0,0x0ffffff);
    };
   break;
   case WM_PAINT:
    {
     RECT rect;
     if (GetUpdateRect(hwnd,&rect,true))
      {
       BitBlt(main_dc,
         rect.left,rect.top,
         rect.right-rect.left,rect.bottom-rect.top,
         background_dc,rect.left,rect.top,
         SRCCOPY);
       ValidateRect(hwnd,&rect);
      } else
      {
       draw_window();
       BitBlt(main_dc,
         0,0,main_size.right,main_size.bottom,
         background_dc,0,main_versatz,
         SRCCOPY);
      };
    };
   break;
   case WM_MOVE:
   case WM_SIZE:
    {
     RECT rect;
     GetClientRect(main_hwnd,&rect);
     size_window(rect.right);
     GetClientRect(main_hwnd,&rect);
     GetClientRect(main_hwnd,&main_size);

     SelectObject(background_dc,0);
     DeleteDC(background_dc);
     background_dc=0;
     DeleteObject(background);
     background=0;

     background=CreateCompatibleBitmap(main_dc,rect.right,rect.right);
     background_size.left=0;
     background_size.top=0;
     background_size.right=rect.right;
     background_size.bottom=rect.right;
     background_dc=CreateCompatibleDC(main_dc);
     SelectObject(background_dc,background);
    }
    return 0;
   case msg_window_draw:
    draw_window();
    BitBlt(main_dc,
         0,0,main_size.right,main_size.bottom,
         background_dc,0,main_versatz,
         SRCCOPY);
   break;
   default:
   break;
  };
 return DefWindowProc(hwnd,uMsg,wParam,lParam);
};

void size_window(int width)
{
 RECT rect1,rect2,rect3;
 int w2=width*3/4;
 main_versatz=(width-w2)/2;
 GetWindowRect(main_hwnd,&rect1);
 GetClientRect(main_hwnd,&rect2);
 rect3.left=rect1.left;
 rect3.top=rect1.top;
 rect3.right=rect1.right+width-rect2.right;
 rect3.bottom=rect1.bottom+w2-rect2.bottom;
 if (
     (rect3.right!=rect1.right) ||
     (rect3.bottom!=rect1.bottom)
    )
  MoveWindow(main_hwnd,
    rect3.left,rect3.top,
    rect3.right-rect3.left,rect3.bottom-rect3.top,
    true);
 GetClientRect(main_hwnd,&main_size);
 return;
};

void draw_window()
{
 HBRUSH oldbrush=SelectObject(background_dc,brush_black);
 HPEN oldpen=SelectObject(background_dc,pen_black);
 char *text="                                         ";
 RECT rect;
 FillRect(background_dc,&background_size,brush_black);
 float scale;
 scale=main_size.right;
 scale=scale/1024.0;
 if (main_game)
  {
   SelectObject(background_dc,pen_white);
   SelectObject(background_dc,brush_white);
   int asteroid_anz=main_game->nasteroids;
   if (asteroid_anz>99)
    asteroid_anz=0;
   for (int i=0;i<asteroid_anz;i++)
    {
     float asteroid_x,asteroid_y;
     float size;
     asteroid_x=main_game->asteroids[i].x;
     asteroid_y=1024-main_game->asteroids[i].y;
     float chance=main_game->asteroids[i].danger;
     SelectObject(background_dc,brush_gloom);
     if (chance>70)
      SelectObject(background_dc,brush_white);
     if (
         (main_game->asteroids[i].danger==main_game->min_danger)&&
         (main_game->asteroids[i].danger<=50)
        )
      SelectObject(background_dc,brush_red);
     if (chance>=10000)
      SelectObject(background_dc,brush_black);

     switch (main_game->asteroids[i].sf)
      {
       case 0:  // groer Asteroid
        size = 20;
        break;
       case 15: // mittlerer Asteroid
        size = 10;
        break;
       case 14: // kleiner Asteroid
        size = 4;
        break;
       default:
        size = 1;
      }
     size=(size*scale)+1;
     int x=asteroid_x*scale;
     int y=asteroid_y*scale;
     Ellipse(background_dc,
        x-size,y+size,
        x+size,y-size);
     MoveToEx(background_dc,x,y,NULL);
/*    LineTo(background_dc,
        x+(main_game->asteroids[i].vx*10),
        y-(main_game->asteroids[i].vy*10)); */
     rect.left=x-40;
     rect.right=rect.left+80;
     rect.top=y+3;
     rect.bottom=rect.top+15;
     sprintf(text,"%.0f",main_game->asteroids[i].time_to_hit);
     DrawText(background_dc,text,-1,&rect,DT_CENTER);
    }; // for each asteroid
   SelectObject(background_dc,pen_white);
   SelectObject(background_dc,brush_gloom);
   int schuss_anz=main_game->nshots;
   if (schuss_anz>9) schuss_anz=0;
   for (int i=0;i<schuss_anz;i++)
    {
     float schuss_x,schuss_y;
     schuss_x=main_game->shots[i].x;
     schuss_y=1024-main_game->shots[i].y;
     int x=schuss_x*scale;
     int y=schuss_y*scale;
     Ellipse(background_dc,
        x-2,y+2,x+2,y-2);
/*     MoveToEx(background_dc,x,y,NULL);
     LineTo(background_dc,
        x+(main_game->shots[i].vx*10),
        y-(main_game->shots[i].vy*10));
     rect.left=x-40;
     rect.right=rect.left+80;
     rect.top=y+3;
     rect.bottom=rect.top+15;
     sprintf(text,"%f,%f",main_game->shots[i].vx,main_game->shots[i].vy);
     DrawText(background_dc,text,-1,&rect,DT_CENTER);*/
    }; // for each shot
   if (main_game->ship_present)
    {
     float dx=main_game->ship_dx;
     float dy=-main_game->ship_dy;
     float x=main_game->ship_x;
     float y=1024-main_game->ship_y;
     float normalize=sqrt(1000000.0/(dx*dx+dy*dy));
     POINT nschiff[5];
     x=x*scale;y=y*scale;
     dx=dx*scale*normalize;dy=dy*scale*normalize;

     for (int i=0;i<5;i++)
      {
       nschiff[i].x=((schiff[i].x*dy+schiff[i].y*dx)/80000.0)+x;
       nschiff[i].y=-((schiff[i].x*dx-schiff[i].y*dy)/80000.0)+y;
      };
     MoveToEx(background_dc,nschiff[4].x,nschiff[4].y,NULL);
     PolylineTo(background_dc,&(nschiff[0]),5);
     MoveToEx(background_dc,x,y,NULL);
     LineTo(background_dc,
        x+(main_game->danger_x*scale),
        y-(main_game->danger_y*scale));
/*     rect.left=x-40;
     rect.right=rect.left+80;
     rect.top=y+3;
     rect.bottom=rect.top+15;
     sprintf(text,"%.1f",main_game->ship_angle);
     DrawText(background_dc,text,-1,&rect,DT_CENTER);*/
    };
   if (main_game->saucer_present)
    {
     float x=main_game->saucer_x;
     float y=1024-main_game->saucer_y;
     float size=1;
     switch (main_game->saucer_size)
      {
       case 15: // groes UFO
        size = .05;
        break;
       case 14: // kleines UFO
       default:
        size = .025;
        break;
      }
     POINT nufo[8];
     x=x*scale;y=y*scale;
     size=size*scale;
     for (int i=0;i<8;i++)
      {
       nufo[i].x=(ufo[i].x*size)+x;
       nufo[i].y=(ufo[i].y*size)+y;
      };
     MoveToEx(background_dc,nufo[7].x,nufo[7].y,NULL);
     PolylineTo(background_dc,&(nufo[0]),8);
/*     MoveToEx(background_dc,x,y,NULL);
     LineTo(background_dc,
        x+(main_game->saucer_vx*10),
        y-(main_game->saucer_vy*10));*/
    };
   SelectObject(background_dc,pen_white);
   rect.left=20*scale;
   rect.right=300*scale;
   rect.top=140*scale;
   rect.bottom=rect.top+20;
   sprintf(text,"Score: %i",main_game->score);
   SetBkMode(background_dc, TRANSPARENT);
   SetTextColor(background_dc,0x0a0a0a0);
   DrawText(background_dc,text,-1,&rect,DT_LEFT);
   rect.top+=20;
   rect.bottom=rect.top+20;
   sprintf(text,"Life: %i",main_game->life);
   DrawText(background_dc,text,-1,&rect,DT_LEFT);
   unsigned long sekunden=(timeGetTime()-main_game->startzeit)/1000;
   unsigned long minuten=sekunden/60;
   sekunden=sekunden%60;
   rect.top+=20;
   rect.bottom=rect.top+20;
   sprintf(text,"Zeit: %i:%i",minuten,sekunden);
   DrawText(background_dc,text,-1,&rect,DT_LEFT);
  };

 SelectObject(background_dc,oldbrush);
 SelectObject(background_dc,oldpen);
 return;
};




