#include <gl.h>

unsigned int star_texture[6]={0,0,0,0,0,0};

struct vektor
{
float x;
float y;
float z;
};
struct polygon
{
 int a,b,c;
};
struct objekt3d {
 int anzahl;
 polygon punkte[];
};



vektor asteroid1[]={
{0,1,0},{-0.4,0.8,0},{-0.4,0.2,0},{-0.8,0.4,0},
{-0.8,-0.6,0},{-0.2,-1,0},{0.2,-1,0},{0,-0.4,0},
{0.6,-0.2,0},{0.6,-0.6,0},{1,0,0},{0.97,0.26,0},
{0.87,0.5,0},{0.71,0.71,0},{0.5,0.87,0},{0.26,0.97,0},
{-0.6,-0.2,0.4},{-0.2,-0.6,0.4},{-0.2,0,0.7},{0.2,0,0.7},
{0,0.6,0.7},{0.6,0.2,0.6},
{-0.2,0.6,-0.4},{-0.6,0,-0.4},{-0.4,-0.6,-0.4},
{0,-0.4,-0.6},{0,0,-0.8},{0.6,-0.2,-0.4},{0.4,0.4,-0.5}
};
vektor asteroid2[]={
{0,1,0},{-0.38,0.92,0},{-0.71,0.71,0},{-0.92,0.38,0},
{-1,0,0},{-0.6,-0.6,0},{-0.2,-0.6,0},{-0.4,-0.8,0},
{0,-1,0},{0.7,-0.7,0},{0.6,0,0},{0.8,0,0},
{1,-0.2,0},{0.8,0.4,0},{0.2,0.4,0},{0.4,0.8,0}
};
vektor asteroid3[]={
{0,1,0},{-0.2,1,0},{-0.4,0.6,0},{-0.8,0.4,0},
{-1,0,0},{-0.6,0,0},{-0.8,-0.4,0},{-0.6,-0.6,0},
{0,-1,0},{0.2,-0.6,0},{0.4,-0.4,0},{0.7,-0.6,0},
{1,0,0},{0.6,0.4,0},{0.6,0.6,0},{0.2,0.6,0}
};
vektor asteroid4[]={
{0,1,0},{-0.4,0.6,0},{-0.6,0,0},{-1,0,0},
{-0.7,-0.7,0},{-0.42,-0.91,0},{0,-1,0},{0.4,-0.6,0},
{0,-0.4,0},{0.6,-0.2,0},{0.8,-0.6,0},{0.97,-0.26,0},
{0.99,0.09,0},{0.91,0.42,0},{0.71,0.71,0},{0.2,0.8,0}
};

vektor ufo2[]={
{-0.4,0.4,0},{-0.2,0.8,0},{0.2,0.8,0},{0.4,0.4,0},
{1,0,0},{0.4,-0.4,0},{-0.4,-0.4,0},{-1,0,0},
{1,0,0},{0.4,0.4,0},{-0.4,0.4,0},{-1,0,0},
{-0.8,0,0.2},{-0.4,-0.2,0.2},{0.4,-0.2,0.2},
{0.8,0,0.2},{0.4,0.2,0.2},{-0.4,0.2,0.2},
{-0.1,0.6,0.2},{0.1,0.6,0.2},

{-0.8,0,-0.2},{-0.4,-0.2,-0.2},{0.4,-0.2,-0.2},
{0.8,0,-0.2},{0.4,0.2,-0.2},{-0.4,0.2,-0.2},
{-0.1,0.6,-0.2},{0.1,0.6,-0.2}
};

vektor schiff2[]={
{0,1,0},{0.5,-1,0},{0.2,-0.7,0},{-0.2,-0.7,0},{-0.5,-1,0},
{0.2,-0.6,0.2},{-0.2,-0.6,0.2}
};
vektor thrust[]={
{0,-1.3,0},{-0.2,-0.9,0},{-0.1,-0.8,0},{0.1,-0.8,0},{0.2,-0.9,0},
{-0.1,-0.9,0.1},{0.1,-0.9,0.1}
};
objekt3d schiff3d={7,
{
 {0,1,5},{0,5,6},{0,6,4},
 {5,1,2},{5,2,3},{6,5,3},{6,3,4}
}
};
objekt3d thrust3d={7,
{
 {0,1,5},{0,5,6},{0,6,4},
 {1,3,5},{2,3,5},{5,3,6},
 {3,4,6}
}
};
objekt3d astro1_3d={53,
{
 {0,20,1},{1,20,2},{2,20,18},
 {2,18,16},{2,16,3},{3,16,4},
 {4,16,17},{4,17,5},{5,17,6},
 {6,17,7},{7,17,18},{7,18,19},
 {7,19,8},{8,19,21},{8,21,10},
 {8,10,9},{10,21,11},{11,21,12},
 {12,21,13},{13,21,20},{13,20,14},
 {14,20,15},{15,20,0},{16,17,18},
 {18,20,19},{19,20,21},
 {0,1,22},{1,2,22},{2,3,23},
 {3,4,23},{4,24,23},{4,5,24},
 {5,6,24},{6,7,25},{6,24,25},
 {7,8,25},{8,27,25},{8,9,27},
 {9,10,27},{10,11,27},{11,28,27},
 {11,12,28},{12,13,28},{13,14,28},
 {14,15,28},{15,0,22},{15,22,28},
 {2,26,22},{2,13,26},{13,24,26},
 {24,25,26},{26,27,28},{26,28,22}
}
};

objekt3d ufo3d={44,
{
 {0,1,18},{1,2,18},{18,2,19},
 {2,3,19},{19,3,16},{3,4,16},
 {16,4,15},{4,5,15},{14,15,5},
 {5,6,14},{14,6,13},{6,7,13},
 {13,7,12},{7,0,12},{12,0,17},
 {17,0,18},
 {17,18,19},{17,19,16},{17,16,15},
 {17,15,14},{17,14,13},{17,13,12},

 {0,26,1},{1,26,2},{2,26,27},
 {3,2,27},{3,27,24},{4,3,24},
 {23,4,24},{5,4,23},{22,5,23},
 {6,5,22},{6,22,21},{7,6,21},
 {7,21,20},{0,7,20},{0,20,25},
 {0,25,26},
 {26,25,27},{27,25,24},{24,25,23},
 {23,25,22},{22,25,21},{21,25,20}
}
};

float sun[]={512,512,512,0};

LRESULT CALLBACK window3d_cb(
   HWND hwnd,
   UINT uMsg,
   WPARAM wParam,
   LPARAM lParam);

class fenster3d{
 public:
 fenster3d();
 ~fenster3d();
 void activate();
 void new_frame(GameStatus& ng);
 void test();
 void draw();
 void switch_view();
 void switch_object_style();

 HWND hwnd;
 WNDCLASS window3d_class;
 HDC dc;

 private:
 void draw_asteroid(int type);
 void draw_ship();
 void draw_ship_thrust();
 void draw_saucer();
 void draw_shot();
 void draw_wireframe();
 void draw_stars(GameStatus& rg);
 void draw_stats(GameStatus& rg);
 void draw_help();
 void draw_velocity(float vx,float vy);
 void draw_object(vektor *punkte,objekt3d *objekt);
 void set_position(float x,float y,float s_x,float s_y);
 void set_shot_light(float x, float y,float s_x,float s_y, int nr);
 void set_thrust_light(GameStatus& rg);
 void set_projection(GameStatus& rg);
 GameStatus game;
 HANDLE frame_mutex;
 HGLRC gl_rc;
 int ansicht3d;
 int object_style;
};



