// player.cpp: Beispielspieler fr Asteroids
// Harald Bgeholz / c't

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>



#if defined(WINDOWS)
#include <winsock2.h>
#else
// 2 Includes fr socket()
#include <sys/types.h>
#include <sys/socket.h>
// 2 Includes fr inet_addr()
#include <netinet/in.h>
#include <arpa/inet.h>
// 2 Includes fr fcntl()
#include <unistd.h>
#include <fcntl.h>
// fr memset()
#define INVALID_SOCKET -1
#define WSAGetLastError() errno
#endif

void Player::Run(void)
{
	FramePacket frame;
	KeysPacket keys;

	char prevframe = 0;
	int t = 0;
        game.clear();
        game.startzeit=timeGetTime();
        for (int i=0;i<32;i++)
         game_alt[i].clear();
	while (!main_quit)
	{

MSG msg;
main_game=&game;
while (PeekMessage(&msg,0,0,0,PM_REMOVE))
 {
  TranslateMessage(&msg);
  DispatchMessage(&msg);
 };
if (fenster2d_aktiv)
  SendMessage(main_hwnd,msg_window_draw,0,0);

		++t;         // Zeit
		++keys.ping; // jedes gesendete Pckchen erhlt eine individuelle Nummer zur Latenzmessung
		SendPacket(keys);
		ReceivePacket(frame);

//		if (frame.frameno != ++prevframe || frame.ping != keys.ping)
                if (frame.frameno != ++prevframe)
		{
			printf("Latenz %d. %d Frames verloren.\n", keys.ping - frame.ping, frame.frameno - prevframe);
			prevframe = frame.frameno;
                }
for (int i=31;i>0;i--)
 memcpy(&(game_alt[i]),&(game_alt[i-1]),sizeof(GameStatus));

memcpy(&(game_alt[0]),&game,sizeof(GameStatus));
for (int i=0;i<game_alt[31].nasteroids;i++)
 game_alt[31].asteroids[i].pre_frame=255;
for (int i=0;i<game_alt[6].nshots;i++)
 game_alt[6].shots[i].pre_frame=255;
		InterpretScreen(frame, game);
calculate_speeds(&game,&(game_alt[0]));
                if ((game_alt[0].life==0) && (game.life))
                 { // neues Spiel
                  game.score=0;
                  game.startzeit=timeGetTime();
                  game.level=1;
                 };
                game.level=game_alt[0].level; 
                if (
                    (game_alt[0].nasteroids==1) &&
                    (game.nasteroids==0) &&
                    (game_alt[0].asteroids[0].sf==14)
                   )
                 game.level++;

		keys.clear();   // alle Tasten loslassen
                game.ship_left=false;
                game.ship_right=false;
                game.ship_thrust=false;
                game.ship_break=false;
                fire=false;
		float min_dist = 0x7fffffff;
		float min_dx = 0;
		float min_dy = 0;
                float attack_hits_frame=10000;
                int attack_number=200;
                int strat_thrust=0;
                game.min_weight=0.0;
                game.min_danger=10000;
                game.min_dist=100000;
		if (game.ship_present)
		{
                 // Als erstes alle Schsse durchgehen und nachsehen ob ein
                 // Asteroid getroffen wird
                 work_shotlist(game);
                 calc_attack_stats(game);
                 int target=calc_asteroid_weights(game);
                 target=game.main_target;
                 min_dist=game.min_dist;
                 float min_timer=10000;
                 for (int i=0;i<game.nasteroids;i++)
                  {
                   if (
/*                       (would_hit(game.asteroids[i].x,game.asteroids[i].y,
                           game.asteroids[i].vx, game.asteroids[i].vy,
                           2,game) < (game.asteroids[i].size-(game.asteroids[i].as.run_frames/15.0)-
                           game.asteroids[i].hitcount*2)) &&*/
                       (would_hit(game.asteroids[i].x,game.asteroids[i].y,
                           game.asteroids[i].vx, game.asteroids[i].vy,
                           2,game) < (game.asteroids[i].size-0.5)) &&
                       (game.asteroids[i].hitcount<game.asteroids[i].overkill)&&
                       (game.asteroids[i].as.run_frames<68) &&
                       (game.asteroids[i].weight<=game.min_weight_to_shoot) &&
                       (
                        (game.player_shots<3) ||
                        (
                         (game.player_shots==3) &&
                         (
                          (game.asteroids[i].danger==game.min_danger) ||
                          (i==target) ||
                          (game.asteroids[i].as.run_frames<
                           game.asteroids[target].as.turn_frames+
                           game.asteroids[target].as.waits_before_shoot) ||
                          (game.wait_for_next_shot<
                           game.asteroids[target].as.turn_frames+
                           game.asteroids[target].as.waits_before_shoot)
                         )
                        )
                       ) &&
                       (game.asteroids[i].tracked>6)
                      )
                    {
                     fire=true;
                     if (
                         (!game_alt[0].ship_fire) &&
                         (game.asteroids[i].as.hit_frame<attack_hits_frame) &&
                         (game.asteroids[i].hitcount<game.asteroids[i].overkill)
                        )
                      {
                       attack_hits_frame=game.asteroids[i].as.hit_frame;
                       attack_number=i;
                      };
                    };
                  };
                 if ((game.nasteroids) && (autopilot_aktiv))
                  {
                   game.ship_right=game.asteroids[target].turn_right_to_hit;
                   game.ship_left=game.asteroids[target].turn_left_to_hit;
                  };
		 if (game.saucer_present)
		  {
                   float weight=game.saucer_as.hit_frame;
                   float dx,dy;
                   float dist=1000;
                   if (
                       (
                        (game.saucer_hitcount!=0) ||
                        (game.saucer_as.run_frames>=65)
                       ) &&
                       (game.nasteroids)
                      ) weight=weight*10000;
                   if (game.nasteroids==1)
                    weight=weight*100;
                   dx=game.ship_x-game.saucer_x;
                   dy=game.ship_y-game.saucer_y;
                   while (dx>512) dx-=1024;
                   while (dx<-512) dx+=1024;
                   while (dy>384) dy-=768;
                   while (dy<-384) dy+=768;
                   dist=sqrt(dx*dx+dy*dy);

                   if (dist < min_dist) min_dist = dist;
                   if (
                       (
                        (weight < game.min_weight)||
                        (game.min_weight==0.0) ||
                        (game.nasteroids==0)
                       ) &&
                       (game.saucer_hitcount==0)
                      )
		    {
                     min_dx=dx;
                     min_dy=dy;
                     game.ship_right=false;
                     if (game.saucer_as.right_turns_to_hit)
                       game.ship_right=true;
                     game.ship_left=false;
                     if (game.saucer_as.left_turns_to_hit)
                       game.ship_left=true;
		    }
                   if (
                       (would_hit(game.saucer_x,game.saucer_y,
                             game.saucer_vx, game.saucer_vy,
                             2,game) < 9) &&
                       (game.saucer_hitcount==0) &&
                       (game.saucer_as.run_frames<65)
                      )
                    {
                     fire=true;
                     if (
                         (!game_alt[0].ship_fire) &&
                         (game.saucer_as.hit_frame<attack_hits_frame)
                        )
                      {
                       attack_hits_frame=game.saucer_as.hit_frame;
                       attack_number=30;
                      }
                    };
		  }
                 if (attack_number<game.nasteroids)
                  {
                   game.asteroids[attack_number].ignore+=20;
                   game.asteroids[attack_number].hitcount++;
                   GameStatus testgame;
                   memcpy(&testgame,&game,sizeof(GameStatus));
                   calc_asteroid_weights(testgame);
                   target=testgame.main_target;
                   game.main_target=testgame.main_target;
                   game.main_target_start_hitframe=
                      testgame.main_target_start_hitframe;
                   if ((game.nasteroids) && (autopilot_aktiv))
                    {
                     game.ship_right=game.asteroids[target].turn_right_to_hit;
                     game.ship_left=game.asteroids[target].turn_left_to_hit;
                    };
                  };
                 if (attack_number==30)
                  {
                   game.saucer_ignore=10;
                   game.saucer_hitcount+=1;
                   if ((game.nasteroids) && (autopilot_aktiv))
                    {
                     game.ship_right=game.asteroids[target].turn_right_to_hit;
                     game.ship_left=game.asteroids[target].turn_left_to_hit;
                    };
                  };

                 for (int i=0; i<(game.nshots-game.phantom_shot); ++i)
		  {   // Schsse wollen auch beachtet werden
                   float dist,d2,dx,dy;
                   float weight=calc_weight(13,
                           game.shots[i].x,game.shots[i].y,
                           game.shots[i].vx,game.shots[i].vy,
                           dist,dx,dy);
                   float danger_x,danger_y;
                   float danger=calc_danger(13,
                           game.shots[i].x,game.shots[i].y,
                           game.shots[i].vx,game.shots[i].vy,
                           danger_x,danger_y,d2);
                   if (danger<10000)
                    {
                     danger=danger/20;
                     weight=calc_weight(13,
                           game.shots[i].x+2*game.shots[i].vx,game.shots[i].y+2*game.shots[i].vy,
                           game.shots[i].vx,game.shots[i].vy,
                           dist,dx,dy);

                    } else
                    {dist+=5;};

                   if (danger<game.min_danger)
                    {
                     game.min_danger=danger;
                     game.danger_x=danger_x;
                     game.danger_y=danger_y;
                    };
                   if (dist<min_dist) min_dist = dist;
                  }
                  
                  float park_x=800;
                  float park_y=512;
                  float park_dist=sqrt(pow(park_x-game.ship_x,2)+pow(park_y-game.ship_y,2));
                  float temp_dist=sqrt(pow(224-game.ship_x,2)+pow(park_y-game.ship_y,2));
                  if (temp_dist<park_dist)
                   {
                    park_x=224;
                    park_dist=temp_dist;
                   };
                  temp_dist=sqrt(pow(512-game.ship_x,2)+pow(672-game.ship_y,2));
                  if (temp_dist<park_dist)
                   {
                    park_x=512;
                    park_y=672;
                    park_dist=temp_dist;
                   };
                  temp_dist=sqrt(pow(512-game.ship_x,2)+pow(352-game.ship_y,2));
                  if (temp_dist<park_dist)
                   {
                    park_x=512;
                    park_y=352;
                    park_dist=temp_dist;
                   };

                        if (
                            (game.nasteroids==0) &&
                            (!game.saucer_present)
                           )
                         { // Schirm ist frei, ab in die Mitte!
                           // na gut,... ein Stck weit an den Rand;-)
                          min_dx=park_x-game.ship_x-(60*game.ship_vx);
                          min_dy=park_y-game.ship_y-(60*game.ship_vy);
                          if (park_dist<30)
                           {
                            min_dy=-game.ship_vy;
                            min_dx=-game.ship_vx;
                           };
                         };
                        // Schiff ausrichten
			// mathematisch wird hier das Kreuzprodukt aus den Vektoren
			// ship_dx/y/0 und min_dx/y/0 berechnet
                        if (
                            (calc_hitchance(game.ship_edx,game.ship_edy,min_dx,min_dy)<0.999) &&
                            (!game.ship_right) &&
                            (!game.ship_left) &&
                            (autopilot_aktiv)
                           )
                        if (game.ship_edx * min_dy - game.ship_edy * min_dx > 0)
                         {
                          game.ship_left=true;
                         } else
                         {
                          game.ship_right=true;
                         };
                        if (
                            (autopilot_aktiv) &&
                            (game.ship_right)
                           )
                            keys.right(true);
                        if (
                            (autopilot_aktiv) &&
                            (game.ship_left)
                           )
                            keys.left(true);
			if (min_dist < 17)  // Flucht, wenn Kollision unausweichlich
			  if (autopilot_aktiv)	keys.hyperspace(true);
			if (
                            (    // an Asteroiden nher ran!
                             /*(
                              (
                               (min_dist > 400)
                              ) &&
                              ((pow(game.ship_vx,2)+pow(game.ship_vy,2))<10)
                             )
                             ||
                             (
                              (min_dist > 180) &&
                              ((pow(game.ship_vx,2)+pow(game.ship_vy,2))<6)
                             )
                             ||
                             (
                              (game.nasteroids<12) &&
                              ((pow(game.ship_vx,2)+pow(game.ship_vy,2))<9) &&
                              (min_dist>180)
                             )
                             ||*/
/*                             (
                              (game.nasteroids<18) &&
                              ((pow(game.ship_vx,2)+pow(game.ship_vy,2))<10) &&
                              (min_dist>190)
                             ) ||*/
                             (
                              (game.nasteroids<12) &&
//                              (game.nasteroids==0) &&
                              ((pow(game.ship_vx,2)+pow(game.ship_vy,2))<12) &&
//                              (game.asteroids[target].as.hit_frame>50)
                              (min_dist>350)
                             ) ||
                             (
                              (game.nasteroids<4) &&
                              (game.nasteroids>0) &&
                              ((pow(game.ship_vx,2)+pow(game.ship_vy,2))<16) &&
                              (game.asteroids[target].dist>250)
                             ) ||
                             (
                              (game.nasteroids==1) &&
                              ((pow(game.ship_vx-game.asteroids[0].vx,2)+
                                pow(game.ship_vy-game.asteroids[0].vy,2))<25) &&
                              (min_dist>150)
                             ) ||
                             (
                              (game.nasteroids==0) &&
                              (game.saucer_present) &&
                              (min_dist>250)
                             )
                            ) ||
                            (    // soll das Schiff verzgern?
                             (calc_hitchance(game.ship_dx,game.ship_dy,
                                    game.ship_vx,game.ship_vy)<-0.4) &&
                             (calc_hitchance(game.ship_dx,game.ship_dy,game.danger_x,game.danger_y)<0.3)
                            ) ||
                            (   // ausweichen, wenn ntig/mglich
                             (game.min_danger<=100) &&
                             (game.min_danger>40) &&
                             (calc_hitchance(game.ship_dx,game.ship_dy,game.danger_x,game.danger_y)<0.7)
                            ) ||
                            (
                             (game.min_danger<=40) &&
                             (game.min_danger>20) &&
                             (calc_hitchance(game.ship_dx,game.ship_dy,game.danger_x,game.danger_y)<0.3)
                            ) ||
                            (
                             (game.min_danger<20) &&
                             (calc_hitchance(game.ship_dx,game.ship_dy,game.danger_x,game.danger_y)<=0)
                            )
                           )  // beschleunigen, wenn ntig
			 if (
                             (autopilot_aktiv) &&
                             ((unsigned char)frame.vectorram[1]==0xe0)
                            )
                          {
                              game.ship_thrust=true;
                              keys.thrust(true);
                          };

			if (
                            (game_alt[0].ship_fire==false) &&
                            (game.nasteroids || game.saucer_present) &&
                            (fire)
                           )
                            // Feuerknopf drcken, so schnell es geht
			if (autopilot_aktiv)
                         {
                           	keys.fire(true);
                                game.ship_fire=true;
                         }
		}
                if (!autopilot_aktiv)
                 {
                  game.ship_left=false;
                  game.ship_right=false;
                  game.ship_thrust=false;
                 };
                if (keyleft)
                 {
                  keys.left(true);
                  game.ship_left=true;
                 };
                if (keyright)
                 {
                  keys.right(true);
                  game.ship_right=true;
                 };
                if (keythrust)
                 {
                  game.ship_thrust=true;
                  keys.thrust(true);
                 };
                if (keyfire) keys.fire(true);
                if (keyhyper) keys.hyperspace(true);
                if (
                    (!game.ship_thrust) &&
                    ((unsigned char)frame.vectorram[1]==0xe0)
                   )
                 game.ship_break=true;
         if (!(fenster2d_aktiv))
 {
  opengl.new_frame(game);
  opengl.draw();
 };
	}
}

void Player::InterpretScreen(FramePacket &packet, GameStatus& game)
{
	unsigned short *vector_ram = (unsigned short *)packet.vectorram;
	int dx, dy, sf, vx, vy, vz, vs;
	int v1x = 0;
	int v1y = 0;
        int scorestart=0;
        char zeichen=0;
        char *scoretext="     ";
        memset(scoretext,0,6);
	int shipdetect = 0;
	game.clear();
	if ((unsigned char)packet.vectorram[1] != 0xe0 && (unsigned char)packet.vectorram[1] != 0xe2)
		return; // sollte nicht vorkommen; erster Befehl ist immer ein JMPL

	int pc = 1;
	for (;;)
	{
		int op = vector_ram[pc] >> 12;
		switch (op)
		{
		case 0xa: // LABS
			vy = vector_ram[pc] & 0x3ff;
			vx = vector_ram[pc+1] & 0x3ff;
			vs = vector_ram[pc+1] >> 12;
                        if ((vy==876) && (vx==100) && (vs==1))
                         scorestart=1;
			break;
		case 0xb: // HALT
                 {
                  unsigned long score=atol(scoretext);
                  score+=(game.score/100000)*100000;
                  if (score<game.score)
                   score+=100000;
                  game.score=score; 
                 };
			return;
		case 0xc: // JSRL
			switch (vector_ram[pc] & 0xfff)
			{
			case 0x8f3:
				game.asteroids[game.nasteroids++].set(vx, vy, 1, vs);
				break;
			case 0x8ff:
				game.asteroids[game.nasteroids++].set(vx, vy, 2, vs);
				break;
			case 0x90d:
				game.asteroids[game.nasteroids++].set(vx, vy, 3, vs);
				break;
			case 0x91a:
				game.asteroids[game.nasteroids++].set(vx, vy, 4, vs);
				break;
			case 0x929:
				game.saucer_present = true;
				game.saucer_x = vx;
				game.saucer_y = vy;
				game.saucer_size = vs;
				break;
                        case 0xb2c: zeichen=' ';break;
                        case 0xb2e: zeichen='1';break;
                        case 0xb32: zeichen='2';break;
                        case 0xb3a: zeichen='3';break;
                        case 0xb41: zeichen='4';break;
                        case 0xb48: zeichen='5';break;
                        case 0xb4f: zeichen='6';break;
                        case 0xb56: zeichen='7';break;
                        case 0xb5b: zeichen='8';break;
                        case 0xb63: zeichen='9';break;
                        case 0xadd: zeichen='0';break;
                        case 0xa6d:
                         if (scorestart==6) game.life++;
                        break;
			}
                        if ((scorestart) && (scorestart<6))
                         {
                          scoretext[scorestart-1]=zeichen;
                          scorestart++;
                         };
			break;
		case 0xd: // RTSL
			return;
		case 0xe: // JMPL
			/*
			pc = vector_ram[pc] & 0xfff;
			break;
			*/
			return;
		case 0xf: // SVEC
			/*
			dy = vector_ram[pc] & 0x300;
			if ((vector_ram[pc] & 0x400) != 0)
				dy = -dy;
			dx = (vector_ram[pc] & 3) << 8;
			if ((vector_ram[pc] & 4) != 0)
				dx = -dx;
			sf = (((vector_ram[pc] & 8) >> 2) | ((vector_ram[pc] & 0x800) >> 11)) + 2;
			vz = (vector_ram[pc] & 0xf0) >> 4;
			*/
			break;
		default:
			dy = vector_ram[pc] & 0x3ff;
			if ((vector_ram[pc] & 0x400) != 0)
				dy = -dy;
			dx = vector_ram[pc+1] & 0x3ff;
			if ((vector_ram[pc+1] & 0x400) != 0)
				dx = -dx;
			sf = op;
			vz = vector_ram[pc+1] >> 12;
			if (dx == 0 && dy == 0 && vz == 15)
				game.shots[game.nshots++].set(vx, vy);
			if (op == 6 && vz == 12 && dx != 0 && dy != 0)
			{
				switch (shipdetect)
				{
				case 0:
					v1x = dx;
					v1y = dy;
					++shipdetect;
					break;
				case 1:
					game.ship_present = true;
					game.ship_x = vx;
					game.ship_y = vy;
					game.ship_dx = v1x - dx;
					game.ship_dy = v1y - dy;
					++shipdetect;
					break;
				}
			}
			else if (shipdetect == 1)
				shipdetect = 0;

			break;
		}
		if (op <= 0xa)
			++pc;
		if (op != 0xe) // JMPL
			++pc;


	}

}

int Player::get_ship_angle(int dx, int dy)
{
 bool dxnegativ=false;
 bool dynegativ=false;
 if (dx<0)
  {
   dx=-dx;
   dxnegativ=true;
  };
 if (dy<0)
  {
   dy=-dy;
   dynegativ=true;
  };
 int nr=0;
 switch (dx)
  {
   case 1536: nr=0;break;
   case 1528: nr=1;break;
   case 1504: nr=2;break;
   case 1472: nr=3;break;
   case 1416: nr=4;break;
   case 1360: nr=5;break;
   case 1280: nr=6;break;
   case 1192: nr=7;break;
   case 1088: nr=8;break;
   case 976:  nr=9;break;
   case 856:  nr=10;break;
   case 720:  nr=11;break;
   case 584:  nr=12;break;
   case 440:  nr=13;break;
   case 296:  nr=14;break;
   case 152:  nr=15;break;
   default:
   nr=16;
  };
 if (dxnegativ) nr=32-nr;
 if (dynegativ) nr=64-nr;
 return nr;
};

float Player::calc_hitchance(float dx1, float dy1, float dx2, float dy2)
{
 float erg=0;
 float d1=sqrt(dx1*dx1+dy1*dy1);
 float d2=sqrt(dx2*dx2+dy2*dy2);
 if ((d1==0) || (d2==0)) return 0;
 erg=(dx1*dx2+dy1*dy2)/d1/d2;
 return erg;
};
float Player::calc_collisionchance(float dx1, float dy1, float dx2, float dy2)
{
 float erg=0;
 float d2=sqrt(dx2*dx2+dy2*dy2);
 if (d2==0) return 60;
 erg=(dx1*dx2+dy1*dy2)/d2;
 return erg;
};


float Player::calc_attack_angle(float zx,float zy,float zvx,float zvy,float &ax, float &ay,float &time)
{
 float hitchance=0;
 float dx = zx - game.ship_x;
 while (dx < -512) dx += 1024;
 while (dx > 511) dx -= 1024;
 float dy = zy - game.ship_y;
 while (dy < -384) dy += 768;
 while (dy > 383) dy -= 768;

 float dvx=zvx-game.ship_vx;
 float dvy=zvy-game.ship_vy;

 float mx1=dx+dvx;
 float my1=dy+dvy;
 float s0=8.0;
 float s1vx1=dvx;
 float s1vy1=dvy;
 float dd=s1vx1*s1vx1+s1vy1*s1vy1-s0*s0;
 if (dd==0)
  {
   time=10000;
   return 0;
  };
 float p=(mx1*s1vx1+my1*s1vy1)/dd;
 float q=(mx1*mx1+my1*my1)/dd;
 float wurzel=p*p-q;
 if (wurzel<0)
  {
   ax=-1;
   ay=0;
   return 0;
  };
 float t1=-p-sqrt(p*p-q);
 float t2=-p+sqrt(p*p-q);
 float t=t1;
 if (t<0) t=t2;
 if ((t2>0) && (t2<t)) t=t2;

 ax=mx1+t*s1vx1;
 ay=my1+t*s1vy1;

 hitchance=calc_hitchance(game.ship_edx,game.ship_edy,
                                        ax,ay);
 time=t;
 return hitchance;
};

float Player::calc_weight(int sf,float zx, float zy, float zvx, float zvy, float &distance, float &dx, float &dy)
{
 dx = zx - game.ship_x;
 while (dx < -512) dx += 1024; // dx normalisieren auf -512 ... 511
 while (dx > 511) dx -= 1024;
 dy = zy - game.ship_y;
 while (dy < -384) dy += 768;  // dy normalisieren auf -384 ... 383
 while (dy > 383) dy -= 768;
 float dist = dx*dx+dy*dy;  // Quadrat des Abstands zu diesem Asteroiden
 float dvx=zvx-game.ship_vx;     // Relative Annherung
 float dvy=zvy-game.ship_vy;
 float dx2=dx+dvx*2;
 float dy2=dy+dvy*2;
 float weight=dx2*dx2+dy2*dy2;
 distance=sqrt(dist);
 switch (sf)
  {	// Abstand um den ungefhren Radius des Asteroiden korrigieren
   case 0:  // groer Asteroid
    distance -= 39;
    break;
   case 15: // mittlerer Asteroid
    distance -= 19;
    break;
   case 14: // kleiner Asteroid
    distance -= 9;
    break;
   case 13: // Schuss
    distance -= 1;
    break;
  }
 if (distance<=0) distance=0.01;
// weight=pow(weight,2);
 return weight;
};


float Player::calc_danger(int sf,float zx, float zy, float zvx, float zvy, float &dx, float &dy,float &dist)
{
 dx = zx - game.ship_x;
 while (dx < -512) dx += 1024; // dx normalisieren auf -512 ... 511
 while (dx > 511) dx -= 1024;
 dy = zy - game.ship_y;
 while (dy < -384) dy += 768;  // dy normalisieren auf -384 ... 383
 while (dy > 383) dy -= 768;
 dist = sqrt(dx*dx+dy*dy);  // Abstand zu diesem Objekt
 float dvx=zvx-game.ship_vx;     // Relative Geschwindigkeit des Objekts zum Schiff
 float dvy=zvy-game.ship_vy;
 float speed=sqrt(dvx*dvx+dvy*dvy);
 if (speed==0) speed=0.1;
 if (calc_collisionchance(dx,dy,dvx,dvy)>=0) speed=-speed;     // Wenn sich das Objekt fortbewegt, kann es ignoriert werden
 float collision_time=10000;
 float evade=fabs(calc_collisionchance(dx,dy,-dvy,dvx))-12;  // Befindet sich das Objekt auf Kollisionskurs?
 switch (sf)
  {	// Abstand um den ungefhren Radius des Asteroiden korrigieren
   case 0:  // groer Asteroid
    dist -= 40;
    evade-=48;
    break;
   case 15: // mittlerer Asteroid
    dist -= 20;
    evade-=24;
    break;
   case 14: // kleiner Asteroid
    dist -= 10;
    evade-=12;
    break;
   case 13: // Schuss
    dist-=6;
    evade-=8;
    break;
  }
 if (dist<=0) dist=0.01;
 if (speed>0) collision_time=dist/speed;
 if (evade<=0) evade=0.01;
 if (dist>400) return 10000;   // Wenn das Objekt noch ewig weit weg ist,
 if (evade>5) return 10000;   // oder vorbeirauscht => nicht so wichtig
 return collision_time;
};


void Asteroid::set(int x, int y, int type, int sf)
{
	this->x = x;
	this->y = y;
	this->type = type;
	this->sf = sf;
        this->pre_frame=255;
        this->next_frame=255;
        this->vx=0;
        this->vy=0;
        this->dx=1.0;
        this->dy=0;
        this->dist=10000;
        this->hitchance=0.0;
        this->bypass=10000;
        this->turn_left_to_hit=false;
        this->turn_right_to_hit=false;
        this->weight=0.0;
        this->danger=0;
        this->danger_x=0;
        this->danger_y=0;
        this->hitcount=0;
        this->time_to_hit=100;
        this->tracked=0;
        this->ignore=0;
        switch (sf)
         {
          case 0:  // groer Asteroid
          this->max_delta=.996;    // groe Brocken mit Streufeuer begren
          this->size=32;
          this->overkill=2;      // und natrlich auch Sperrfeuer
          break;
         case 15: // mittlerer Asteroid
          this->max_delta=.999;
          this->size=16;
          this->overkill=2;
          break;
         case 14: // kleiner Asteroid
          this->max_delta=.9998;
          this->size=8;
          this->overkill=1;
          break;
         default:
          this->size=50;
         };
        this->as.left_turns_to_hit=0;
        this->as.right_turns_to_hit=0;
        this->as.waits_before_shoot=10;
        this->as.hit_frame=10000;
        this->as.turn_frames=0;
        this->as.run_frames=160;
        this->next_one=0;
        this->important=1;
}

void Shot::set(int x, int y)
{
	this->x = x;
	this->y = y;
        this->pre_frame=255;
        this->next_frame=255;
        this->vx=0;
        this->vy=0;
        this->tracked=0;
        this->age=0;
        this->rest_life=69;
}

void GameStatus::clear(void)
{
	ship_present = false;
	saucer_present = false;
	nasteroids = 0;
        asteroids_to_go=0;
	nshots = 0;
        min_danger=10000;
        min_dist=100000;
        danger_x=0;
        danger_y=0;
        life=0;
        ship_vx=0;
        ship_vy=0;
        ship_x=512;
        ship_y=512;
        ship_dx=0;
        ship_dy=16;
        ship_edx=0;
        ship_edy=1;
        ship_angle=M_PI_2;
        ship_dangle=0;
        ship_rot=0;
        ship_thrust=false;
        ship_left=false;
        ship_right=false;
        ship_fire=false;
        saucer_x=0;
        saucer_y=512;
        saucer_vx=1;
        saucer_vy=0;
        saucer_size=15;
        saucer_hitcount=0;
        saucer_as.left_turns_to_hit=0;
        saucer_as.right_turns_to_hit=0;
        saucer_as.waits_before_shoot=10;
        saucer_as.hit_frame=10000;
        saucer_as.turn_frames=0;
        saucer_as.run_frames=160;
        saucer_ignore=0;
        ship_sprite=0;
        winkel_byte=0;
        ewinkel_byte=0;
        winkel_bereich.min=0;
        winkel_bereich.max=255;
        for (int i=0;i<6;i++)
         this->shots[i].set(0,0);
        phantom_shot=0;
        player_shots=0;
        wait_for_next_shot=0;
        level=1;
        ship_target=14;
        sum_weight=0;
        min_weight=10000;
        main_target=0;
        main_target_count=0;
        main_target_start_hitframe=10000;
        sec_target=0;
        sec_target_start_hitframe=10000;
        min_weight_to_shoot=10000;
}

KeysPacket::KeysPacket(void)
{
	signature[0] = 'c';
	signature[1] = 't';
	signature[2] = 'm';
	signature[3] = 'a';
	signature[4] = 'm';
	signature[5] = 'e';
	keys = '@';
	ping = 0;
}

void KeysPacket::clear(void)
{
	keys = '@';
}

void KeysPacket::hyperspace(bool b)
{
	if (b)
		keys |= KEY_HYPERSPACE;
	else
		keys &= ~KEY_HYPERSPACE;
}

void KeysPacket::fire(bool b)
{
	if (b)
		keys |= KEY_FIRE;
	else
		keys &= ~KEY_FIRE;
}

void KeysPacket::thrust(bool b)
{
	if (b)
		keys |= KEY_THRUST;
	else
		keys &= ~KEY_THRUST;
}

void KeysPacket::left(bool b)
{
	if (b)
	{
		keys |= KEY_LEFT;
		right(false);
	}
	else
		keys &= ~KEY_LEFT;
}

void KeysPacket::right(bool b)
{
	if (b)
	{
		keys |= KEY_RIGHT;
		left(false);
	}
	else
		keys &= ~KEY_RIGHT;
}

void Player::ReceivePacket(FramePacket &packet)
{
	sockaddr_in sender;
	int sender_size = sizeof sender;
	fd_set readfds, writefds, exceptfds;

	do
	{
		FD_ZERO(&readfds);
		FD_ZERO(&writefds);
		FD_ZERO(&exceptfds);
		FD_SET(sd, &readfds);
		FD_SET(sd, &exceptfds);
		select(sd+1, &readfds, &writefds, &exceptfds, NULL);
		int bytes_received = recv(sd, (char *)&packet, sizeof packet, 0);
		while (bytes_received != sizeof packet)
		{
                  if (bytes_received>4)
                   {
                    if (
                        (packet.vectorram[0]=='b') &&
                        (packet.vectorram[1]=='u') &&
                        (packet.vectorram[2]=='s') &&
                        (packet.vectorram[3]=='y')
                       )
                     {
                      fprintf(stdout,"%s",&(packet.vectorram[0]));
                      exit(2);
                     };
                    if (
                        (packet.vectorram[0]=='g') &&
                        (packet.vectorram[1]=='a') &&
                        (packet.vectorram[2]=='m') &&
                        (packet.vectorram[3]=='e')
                       )
                     {
                      fprintf(stdout,"%s",&(packet.vectorram[0]));
                      Sleep(4000);
                      exit(3);
                     };
                   } else
                   {
			int err = WSAGetLastError();
			fprintf(stderr, "Fehler %d bei recvfrom().\n", err);
			exit(1);
                   };
		}
		FD_ZERO(&readfds);
		FD_ZERO(&writefds);
		FD_ZERO(&exceptfds);
		FD_SET(sd, &readfds);
		timeval zero;
		zero.tv_sec = zero.tv_usec = 0;
		select(sd+1, &readfds, &writefds, &exceptfds, &zero);
	} while(FD_ISSET(sd, &readfds));
}

void Player::SendPacket(KeysPacket &packet)
{
	sockaddr_in server;
	memset(&server, 0, sizeof server);
	server.sin_family = AF_INET;
	server.sin_port = htons(1979);
	server.sin_addr.s_addr = server_ip;
	if (sizeof packet != sendto(sd, (char *)&packet, sizeof packet, 0, (sockaddr*)&server, sizeof server))
	{
#if defined(WINDOWS)
		int err = WSAGetLastError();
		if (err != WSAEWOULDBLOCK)
		{
			fprintf(stderr, "Fehler %d bei sendto().\n", err);
			exit(1);
		}
#else
		if (errno != EAGAIN)
		{
			perror("Fehler bei sendto()");
			exit(1);
		}
#endif
	}
}

void Player::calculate_speeds(GameStatus *game, GameStatus *pre_game)
{
 game->ship_vx=0;game->ship_vy=0;
 float dd=sqrt(game->ship_dx*game->ship_dx+game->ship_dy*game->ship_dy);
 game->ship_sprite=get_ship_angle(game->ship_dx,game->ship_dy);
 bereich b1,b2;
 b1.min=pre_game[0].winkel_bereich.min;
 b1.max=pre_game[0].winkel_bereich.max;
 if (pre_game[1].ship_right)
  {
   b1.min=(b1.min-3)&255;
   b1.max=(b1.max-3)&255;
  };
 if (pre_game[1].ship_left)
  {
   b1.min=(b1.min+3)&255;
   b1.max=(b1.max+3)&255;
  };
 b2.min=minmax[game->ship_sprite].min;
 b2.max=minmax[game->ship_sprite].max;
// b2 gibt den Bereich fr den Winkel an, der fr das derzeitige Frame gegeben ist
// b1 gibt den Bereich fr den Winkel an, der zu erwarten wre...
// Schnittmenge bilden und in b2 speichern, wenn es keine Schnittmenge gibt,
// bleibt b2 erhalten
 if ((b1.min<=b1.max) && (b2.min<=b2.max))
  {
   if ((b1.min<=b2.max) && (b2.min<=b1.max))
    {
     if (b1.min>b2.min) b2.min=b1.min;
     if (b1.max<b2.max) b2.max=b1.max;
    };
  } else
  {
   if (((signed char)b1.min<=(signed char)b2.max) && ((signed char)b2.min<=(signed char)b1.max))
    {
     if ((signed char)b1.min>(signed char)b2.min) b2.min=b1.min;
     if ((signed char)b1.max<(signed char)b2.max) b2.max=b1.max;
    };
  };

 game->winkel_bereich.min=b2.min;
 game->winkel_bereich.max=b2.max;
 if (b2.min<=b2.max)
  game->winkel_byte=(b2.min+b2.max)/2;
 if (b2.min>b2.max)
  game->winkel_byte=((signed char)b2.min+(signed char)b2.max)/2;


 game->ship_dx=game->ship_dx/dd;
 game->ship_dy=game->ship_dy/dd;
 game->ship_angle=acos(game->ship_dx);
 if (game->ship_dy<0) game->ship_angle=-game->ship_angle;
 game->ship_angle=(winkel[game->winkel_byte]/360.0*256);
// game->ship_angle=(game->winkel_byte);
 game->ship_angle=(game->ship_angle*M_PI/128.0)+M_PI_2;
 while (game->ship_angle>M_PI)
  game->ship_angle-=2*M_PI;
 game->ship_dangle=pre_game->ship_angle-game->ship_angle;
 while (game->ship_dangle>M_PI) game->ship_dangle-=2*M_PI;
 while (game->ship_dangle<-M_PI) game->ship_dangle+=2*M_PI;

 game->ship_rot=(pre_game->ship_rot*0.75)+game->ship_dangle;

 int d=0;
 if (pre_game->ship_left) d=3;
 if (pre_game->ship_right) d=-3;
 game->ewinkel_byte=(game->winkel_byte+d)&255;
 game->ship_edx=schuss_vx[game->ewinkel_byte]/schuss_v[game->ewinkel_byte];
 game->ship_edy=schuss_vy[game->ewinkel_byte]/schuss_v[game->ewinkel_byte];


 if (
     (game->ship_present)
    )
  {
   float vx=0;
   float vy=0;
   int i=0;
   float d=1;
   while ((i<7) && (pre_game[i].ship_present))
    {
     vx=game->ship_x-pre_game[i].ship_x;
     vy=game->ship_y-pre_game[i].ship_y;
     d=i+1;
     i++;
    };
   vx=vx/d;
   vy=vy/d;
   if (pre_game[1].ship_thrust) pre_game[0].ship_thrust=0;
   for (int i=5;i>1;i--)
    {
     if (pre_game[i].ship_thrust)
      {
       float d=8-i;
       if (vx<7.5)
        vx+=pre_game[i].ship_edx*2/16.0*d/8.0;
       if (vy<7.5)
        vy+=pre_game[i].ship_edy*2/16.0*d/8.0;
      };
     if (pre_game[i].ship_break)
      {
       float d=8-i;
       if (vx<0)
        vx+=2/64.0*d/8.0;
       if (vx>0)
        vx-=2/64.0*d/8.0;
       if (vy<0)
        vy+=2/64.0*d/8.0;
       if (vy>0)
        vy-=2/64.0*d/8.0;
      };
    };
   game->ship_vx=vx;
   game->ship_vy=vy;
  };
 game->saucer_vx=0;game->saucer_vy=0;
 if (
     (game->saucer_present) &&
     (pre_game->saucer_present)
    )
  {
   game->saucer_vx=game->saucer_x-pre_game->saucer_x;
   game->saucer_vy=game->saucer_y-pre_game->saucer_y;
   game->saucer_ignore=pre_game->saucer_ignore;
   if (game->saucer_ignore)
    game->saucer_ignore--;
  };
 for (int i=0;i<pre_game->nasteroids;i++)
  pre_game->asteroids[i].next_frame=255;

 for (int i=0;i<game->nasteroids;i++)
  {
   int seemstobe=255;
   float dist=36;
   game->asteroids[i].pre_frame=255;
   game->asteroids[i].next_frame=255;
   switch (game->asteroids[i].sf)
    {
     case 0:
     game->asteroids_to_go+=4;
     case 15:
     game->asteroids_to_go+=2;
     default:
     game->asteroids_to_go++;
    };
   float x=game->asteroids[i].x;
   float y=game->asteroids[i].y;
   game->asteroids[i].vx=0;
   game->asteroids[i].vy=0;
   for (int a=0;a<pre_game->nasteroids;a++)
    {
     if (
         (pre_game->asteroids[a].next_frame==255) &&
         (pre_game->asteroids[a].type==game->asteroids[i].type) &&
         (pre_game->asteroids[a].sf==game->asteroids[i].sf)
        )
      {
       float dx=pre_game->asteroids[a].x-x;
       float dy=pre_game->asteroids[a].y-y;
       while (dx>512) dx-=1024;
       while (dx<-512) dx+=1024;
       while (dy>384) dy-=768;
       while (dy<-384) dy+=768;
       float dd=dx*dx+dy*dy;
       if (
           (calc_hitchance(pre_game->asteroids[a].vx,pre_game->asteroids[a].vy,
                    dx,dy)<=0) &&
           (dd<dist)
          )
        {
         seemstobe=a;
         dist=dd;
        };
      };
    };
   if (seemstobe<100)
    {
     pre_game->asteroids[seemstobe].next_frame=i;
     game->asteroids[i].pre_frame=seemstobe;
    };
  };
 for (int i=0;i<game->nasteroids;i++)
  {
   int seemstobe=game->asteroids[i].pre_frame;
   int a=0;

   while ((seemstobe!=255) && (a<31))
    {
     float vx=game->asteroids[i].x-pre_game[a].asteroids[seemstobe].x;
     float vy=game->asteroids[i].y-pre_game[a].asteroids[seemstobe].y;
     while (vx>512) vx-=1024;
     while (vx<-512) vx+=1024;
     while (vy>384) vy-=768;
     while (vy<-384) vy+=768;
     game->asteroids[i].vx=vx;
     game->asteroids[i].vy=vy;
     seemstobe=pre_game[a].asteroids[seemstobe].pre_frame;
     a+=1;
    };
   float d=a+1;
   game->asteroids[i].vx=game->asteroids[i].vx/d;
   game->asteroids[i].vy=game->asteroids[i].vy/d;
   game->asteroids[i].tracked=a;
   game->asteroids[i].ignore=0;
   if (game->asteroids[i].pre_frame<30)
     game->asteroids[i].ignore=pre_game[0].asteroids[game->asteroids[i].pre_frame].ignore;
   if (game->asteroids[i].ignore)
     game->asteroids[i].ignore--;
  };
// jetzt auch die Geschwindigkeiten der Schsse berechnen
 for (int i=0;i<pre_game->nshots;i++)
  pre_game->shots[i].next_frame=255;
 for (int i=0;i<game->nshots;i++)
  {
   if ((i==1) && (pre_game->nshots==2))
     i=1;
   int seemstobe=255;
   float dist=250;
   float x=game->shots[i].x;
   float y=game->shots[i].y;
   game->shots[i].vx=0;
   game->shots[i].vy=0;
   game->shots[i].age=0;
   for (int a=0;a<pre_game->nshots;a++)
    {
     if (pre_game->shots[a].next_frame==255)
      {
       float dx=pre_game->shots[a].x-x;
       float dy=pre_game->shots[a].y-y;
       while (dx>512) dx-=1024;
       while (dx<-512) dx+=1024;
       while (dy>384) dy-=768;
       while (dy<-384) dy+=768;
       float dd=dx*dx+dy*dy;
       if (
           (calc_hitchance(pre_game->shots[a].vx,pre_game->shots[a].vy,
                    dx,dy)<=0) &&
           (dd<dist)
          )
        {
         seemstobe=a;
         dist=dd;
        };
      };
    };
   if (seemstobe<100)
    {
     pre_game->shots[seemstobe].next_frame=i;
     game->shots[i].pre_frame=seemstobe;
    };
  };

 for (int i=0;i<game->nshots;i++)
  {
//   fprintf(stdout,"%f,%f : ",game->shots[i].vx,game->shots[i].vy);
   int seemstobe=game->shots[i].pre_frame;
   int a=0;
   while ((seemstobe!=255) && (a<7))
    {
     float vx=game->shots[i].x-pre_game[a].shots[seemstobe].x;
     float vy=game->shots[i].y-pre_game[a].shots[seemstobe].y;
     while (vx>512) vx-=1024;
     while (vx<-512) vx+=1024;
     while (vy>384) vy-=768;
     while (vy<-384) vy+=768;
     game->shots[i].vx=vx;
     game->shots[i].vy=vy;
     seemstobe=pre_game[a].shots[seemstobe].pre_frame;
     a+=1;
    };
   game->shots[i].tracked=a;
   game->shots[i].player_shot=0;
   if (game->shots[i].pre_frame<30)
    {
     game->shots[i].age=pre_game[0].shots[game->shots[i].pre_frame].age+1;
     game->shots[i].player_shot=pre_game[0].shots[game->shots[i].pre_frame].player_shot;
    };
   if (a)
    {
     float d=a;
     game->shots[i].vx=game->shots[i].vx/d;
     game->shots[i].vy=game->shots[i].vy/d;
    };
   if ((game->shots[i].vx==0) && (game->shots[i].vy==0))
    { // Schuss wohl unbekannt, nachsehen, ob es ein Schuss vom Schiff ist,
      // dann mit Werten schonmal vorladen
     int winkel=pre_game[1].ewinkel_byte;
     float sx=pre_game[1].ship_x+2*pre_game[1].ship_vx;
     float sy=pre_game[1].ship_y+2*pre_game[1].ship_vy;
     sx+=schuss_start_x[winkel];
     sy+=schuss_start_y[winkel];
     float dx=game->shots[i].x-sx;
     float dy=game->shots[i].y-sy;
     while (dx>512) dx-=1024;
     while (dx<-512) dx+=1024;
     while (dy>384) dy-=768;
     while (dy<-384) dy+=768;
     float dist=sqrt(dx*dx+dy*dy);
     if (dist<10)
      {
/*       fprintf(stdout,"%f: %.f,%.3f,%.3f ",
          dist,
          game->shots[i].x, sx, pre_game[1].ship_vx);
       fprintf(stdout,"\n");*/
       game->shots[i].vx=schuss_vx[winkel]+pre_game[1].ship_vx;
       game->shots[i].vy=schuss_vy[winkel]+pre_game[1].ship_vy;
       game->shots[i].player_shot=1;
      };
    };
  };
 if (
     (pre_game->ship_fire) &&
     (!pre_game[1].ship_fire) &&
     (pre_game->nshots<4) &&
     (game->nshots<4)
    ) // es wird im nchsten Frame schon einen neuen Schuss geben,
     // daher kann dieser auch jetzt schon eingepflegt werden...
  {
   int nr=game->nshots;
   int winkel=pre_game[0].ewinkel_byte;
   float sx=game->ship_x+game->ship_vx;
   float sy=game->ship_y+game->ship_vy;
   sx+=schuss_start_x[winkel];
   sy+=schuss_start_y[winkel];
   game->shots[nr].vx=schuss_vx[winkel]+game->ship_vx;
   game->shots[nr].vy=schuss_vy[winkel]+game->ship_vy;
   game->shots[nr].x=sx-game->shots[nr].vx;
   game->shots[nr].y=sy-game->shots[nr].vy;
   game->shots[nr].age=0;
   game->nshots++;
   game->phantom_shot=1;
   game->shots[nr].player_shot=1;
  };
 if (pre_game->nasteroids)
  {
   int t=pre_game->main_target;
   if (pre_game->asteroids[t].next_frame<28)
    {
     game->main_target=pre_game->asteroids[t].next_frame;
     game->main_target_count++;
     game->main_target_start_hitframe=pre_game->main_target_start_hitframe;
     t=pre_game->sec_target;
     if (pre_game->asteroids[t].next_frame<28)
      {
       game->sec_target=pre_game->asteroids[t].next_frame;
       game->sec_target_start_hitframe=pre_game->sec_target_start_hitframe;
      } else
      {
       game->sec_target=pre_game->main_target;
       game->sec_target_start_hitframe=pre_game->main_target_start_hitframe;
      };
    } else
    {
     t=pre_game->sec_target;
     if (pre_game->asteroids[t].next_frame<28)
      {
       game->main_target=pre_game->asteroids[t].next_frame;
       game->main_target_count=0;
       game->main_target_start_hitframe=pre_game->sec_target_start_hitframe;
       game->sec_target=pre_game->asteroids[t].next_frame;
       game->sec_target_start_hitframe=pre_game->sec_target_start_hitframe;
      } else
      {
       game->main_target=0;
       game->main_target_count=0;
       game->main_target_start_hitframe=10000;
       game->sec_target=0;
       game->sec_target_start_hitframe=10000;
      };
    };
  };
};



int Player::test_if_ship_shows_to(float x, float y, GameStatus &rg)
{
 float dx=x-rg.ship_x;
 float dy=y-rg.ship_y;
 while (dx>512) dx-=1024;
 while (dx<-512) dx+=1024;
 while (dy>384) dy-=768;
 while (dy<-384) dy+=768;
 float sc=calc_hitchance(rg.ship_edx,rg.ship_edy,dx,dy);
 if (sc>0.9) return 1;
 return 0;
};

float Player::asteroids_in_range(float x, float y, GameStatus &rg)
{
 float erg=0;
 for (int i=0;i<rg.nasteroids;i++)
  {
   if (
       ((pow(rg.asteroids[i].x-x,2)+pow(rg.asteroids[i].y-y,2))<35000) &&
       (rg.asteroids[i].hitcount<rg.asteroids[i].overkill)
      )
    {
     float p=1;
     if (rg.asteroids[i].sf==15) p=3;
     if (rg.asteroids[i].sf==0) p=7;
    };
  };
 if (erg==0) return 1;
 return pow(erg,3);
};

float Player::would_hit(float x, float y, float vx, float vy, float frames,GameStatus &rg)
{
 float trifft=10000;
 int winkel=rg.ewinkel_byte;
 float dx=x-rg.ship_x-schuss_start_x[winkel];
 float dy=y-rg.ship_y-schuss_start_y[winkel];
 float dvx=vx-rg.ship_vx;
 float dvy=vy-rg.ship_vy;
 dx+=frames*dvx;
 dy+=frames*dvy;
 dvx-=schuss_vx[winkel];
 dvy-=schuss_vy[winkel];
 float normal_x=-dvy;
 float normal_y=dvx;
 while (dx>512) dx-=1024;
 while (dx<-512) dx+=1024;
 while (dy>384) dy-=768;
 while (dy<-384) dy+=768;
 if ((dvx!=0)||(dvy!=0))
  {
   trifft=fabs(calc_collisionchance(dx,dy,normal_x,normal_y));
   if (calc_hitchance(dx,dy,dvx,dvy)>0)
    {// falsche Richtung, AP sollte aber trotzdem wissen, welche Richtung
     trifft=1000-trifft;
    };
  };

 return trifft;
};

int Player::calc_asteroid_weights(GameStatus &rg)
{
 int target=0;
 float sec_min_weight=1000000;
 if (!(rg.ship_present)) return 0;

 // jetzt alle Asteroiden durchgehen, Zielwinkel berechnen
 // gewichten, evtl. auch Ausweich-Manver vorbereiten
// if (rg.asteroids_to_go>35)
//  for (int i=0; i<rg.nasteroids; ++i)
//   rg.asteroids[i].overkill=1;
 rg.sum_weight=0;
 for (int i=0;i<rg.nasteroids;i++)
  {
   int offset=0;
   float weight=10000;
/*   calc_attack(rg.asteroids[i].x,rg.asteroids[i].y,
               rg.asteroids[i].vx, rg.asteroids[i].vy,
               rg.asteroids[i].size,
               rg.ship_x,rg.ship_y,
               rg.ship_vx,rg.ship_vy,
               rg.ewinkel_byte,0,
               rg.asteroids[i].as
              );
   while ((offset<400) && (rg.asteroids[i].as.hit_frame>150))
    {
     calc_attack(rg.asteroids[i].x,rg.asteroids[i].y,
                 rg.asteroids[i].vx,rg.asteroids[i].vy,
                 rg.asteroids[i].size,
                 rg.ship_x,rg.ship_y,
                 rg.ship_vx,rg.ship_vy,
                 rg.ewinkel_byte,offset,
                 rg.asteroids[i].as
                );
     offset+=40;
    };*/
   // Ok ZielVorgaben sind berechnet worden, jetzt kommt die Gewichtung
   weight=10000;
   attack_stats as1,as2;
   as1.left_turns_to_hit=0;
   as1.right_turns_to_hit=0;
   as1.waits_before_shoot=10000;
   as1.hit_frame=10000;
   as1.turn_frames=0;
   as1.run_frames=10000;
   float offset1=rg.asteroids[i].as.turn_frames+
                 rg.asteroids[i].as.waits_before_shoot+2;
/*   if (rg.asteroids[i].hitcount<rg.asteroids[i].overkill)
    {
     if (
         (rg.asteroids[i].size!=14) &&
         (rg.asteroids[i].hitcount<rg.asteroids[i].overkill-1)
        )
      {
       as1.hit_frame=rg.asteroids[i].as.hit_frame;
       rg.asteroids[i].next_one=i;
      } else
      {
       for (int eins=0;eins<rg.nasteroids;eins++)
        {
         float min_weight=as1.hit_frame;
         if (
             (eins!=i) &&
             (rg.asteroids[eins].hitcount<rg.asteroids[eins].overkill)
            )
          {
           calc_attack(rg.asteroids[eins].x,rg.asteroids[eins].y,
                   rg.asteroids[eins].vx,rg.asteroids[eins].vy,
                   rg.asteroids[eins].size,
                   rg.ship_x,rg.ship_y,
                   rg.ship_vx,rg.ship_vy,
                   rg.ewinkel_byte,offset1,
                   as1
                );
           if (as1.hit_frame<min_weight)
            {
             min_weight=as1.hit_frame;
             rg.asteroids[i].next_one=eins;
            };
          };
        };
      };
    }; */
   if (rg.nasteroids==1) as1.hit_frame=0;
   if (rg.nasteroids==1) as1.turn_frames=0;
   if (as1.hit_frame==10000) as1.turn_frames=0;
   if (as1.hit_frame==10000) as1.hit_frame=0;
   switch (rg.player_shots)
    {
/*     case 0:
     case 1:
     weight=(rg.asteroids[i].as.turn_frames+
        rg.asteroids[i].as.waits_before_shoot)
        *rg.asteroids[i].important;
     weight=weight*50;
     break;
     case 0:
     weight=rg.asteroids[i].as.turn_frames+as1.hit_frame+
       rg.asteroids[i].as.waits_before_shoot;
     break;*/
     default:
     weight=(rg.asteroids[i].as.hit_frame)*rg.asteroids[i].important;
//     weight=weight*2;
     weight=weight*weight/15;
    };
/*   if (rg.nasteroids<30)
    {
     weight=(rg.asteroids[i].as.hit_frame)*rg.asteroids[i].important;
//     weight+=as1.hit_frame*rg.asteroids[rg.asteroids[i].next_one].important;
//     weight=rg.asteroids[i].as.hit_frame;
//     weight+=as1.hit_frame;
//     weight=weight*weight/10;
//     weight+=as1.hit_frame*rg.asteroids[rg.asteroids[i].next_one].important;
//     weight=weight*0.01;
//     weight=weight*(rg.asteroids[i].as.turn_frames+as1.turn_frames+10);
//     weight=weight*rg.asteroids[i].important;
//     weight=weight*rg.asteroids[rg.asteroids[i].next_one].important;
    };*/
//   weight=weight/(1+asteroids_in_range(rg.asteroids[i].x,rg.asteroids[i].y,rg));
   
 // weight=weight*rg.asteroids[i].important;
//  weight=weight*weight/1000;
//   weight=weight/(10+asteroids_in_range(rg.asteroids[i].x,rg.asteroids[i].y,rg));

   rg.sum_weight+=weight;
   if (rg.asteroids[i].hitcount<rg.asteroids[i].overkill)
    {
     if (
         (weight < rg.min_weight)||
         (rg.min_weight==0.0)
        )
      {
       if (rg.min_weight<sec_min_weight)
        {
         sec_min_weight=rg.min_weight;
         rg.sec_target=target;
        };
       rg.min_weight=weight;
       target=i;
      } else
      {
       if (weight<sec_min_weight)
        {
         sec_min_weight=weight;
         rg.sec_target=i;
        };
      };
    }
  };
 rg.main_target=target;
 rg.main_target_start_hitframe=rg.asteroids[target].as.hit_frame;
 game.main_target_count=0;
// da ja bei'm rumschwenken zum Ziel auch andere Ziele
// mitgenommen werden, muss hier auch nochmal aussondiert werden
// welche denn mitgenommen werden sollen: es stehen nur maximal 3 weitere
// Schsse zur Verfgung...
 float ws[8];
 for (int i=0;i<8;i++)
  ws[i]=10000;
 int rechts=rg.asteroids[target].as.right_turns_to_hit;
 int links=rg.asteroids[target].as.left_turns_to_hit;
 float turns=rg.asteroids[target].as.turn_frames;
 int sec=target;
 for (int anr=0;anr<rg.nasteroids;anr++)
  {
   if (
       (anr!=target) &&
       (rg.asteroids[anr].as.right_turns_to_hit==rechts) &&
       (rg.asteroids[anr].as.left_turns_to_hit==links) &&
       (rg.asteroids[anr].as.hit_frame<ws[7]) &&
       (rg.asteroids[anr].as.waits_before_shoot==0) &&
       (rg.asteroids[anr].as.turn_frames<turns) &&
       (rg.asteroids[anr].hitcount<rg.asteroids[anr].overkill)
      )
    { //ok, der Asteroid anr liegt also "auf dem Weg"
      // jetzt muss er auch nah genug sein...
     float w=rg.asteroids[anr].weight;
     for (int i=0;i<8;i++)
      {
       if (w<ws[i])
        {
         float q=w;
         w=ws[i];
         ws[i]=q;
         if (i==0) sec=anr;
        };
      };
    };
  };
// ok, in den ws[i] sind jetzt die 6 nchsten Asteroiden in schuss-
// rotationsrichtung aufgelistet, je nach dem, wieviele Schsse noch
// frei sind, muss dass bercksichtigt werden
 int a=7;
 if (rg.player_shots<4)
  a=5-rg.player_shots;
// a=5;
 rg.min_weight_to_shoot=ws[a];
/* target=sec;
 rg.main_target=target;
 rg.main_target_start_hitframe=rg.asteroids[target].as.hit_frame;*/
// rg.sec_target=rg.asteroids[target].next_one;
 rg.sec_target_start_hitframe=rg.asteroids[rg.sec_target].as.hit_frame+2;
 return target;
};



void Player::calc_attack(float x,float y, float vx, float vy, float size,
                         float sx,float sy, float svx, float svy, int winkel_byte,
                         int offset, attack_stats &as)
{
 as.left_turns_to_hit=0;
 as.right_turns_to_hit=0;
 as.waits_before_shoot=100000;
 as.hit_frame=10000;
 float edx=schuss_vx[winkel_byte];
 float edy=schuss_vy[winkel_byte];
 float min_passby=512;
 float min_time=10000;
 float ax=edx;
 float ay=edy;
 float versatz=offset;
 for (int i=0;i<40;i++)
   qualify_attack(x,y,vx,vy,size,sx,sy,svx,svy,winkel_byte+3*i,winkel_byte,versatz+i,as);
 for (int i=1;i<40;i++)
   qualify_attack(x,y,vx,vy,size,sx,sy,svx,svy,winkel_byte-3*i,winkel_byte,versatz+i,as);
 return;

/*

 float v2=0;
 for (int durchgang=0;durchgang<5;durchgang++)
  {
   float dx = x - sx;
   float dy = y - sy;
   float dvx=vx-svx;
   float dvy=vy-svy;
   float mx1=dx+dvx*versatz;
   float my1=dy+dvy*versatz;
   while (mx1 < -512) mx1 += 1024;
   while (mx1 > 511) mx1 -= 1024;
   while (my1 < -384) my1 += 768;
   while (my1 > 383) my1 -= 768;

   float s0=8.0;
   float s1vx1=dvx;
   float s1vy1=dvy;
   float dd=s1vx1*s1vx1+s1vy1*s1vy1-s0*s0;
   if (dd==0)
     return;
   float p=(mx1*s1vx1+my1*s1vy1)/dd;
   float q=(mx1*mx1+my1*my1)/dd;
   float wurzel=p*p-q;
   if (wurzel<0)
     return;
   float t1=-p-sqrt(wurzel);
   float t2=-p+sqrt(wurzel);
   float t=t1;
   if (t<0) t=t2;
   if ((t2>0) && (t2<t)) t=t2;

   ax=mx1+t*s1vx1;
   ay=my1+t*s1vy1;

   float cosrotate=calc_hitchance(edx,edy,ax,ay);
   if (cosrotate>1)
    cosrotate=1.0;
   if (cosrotate<-1)
    cosrotate=-1.0;

   float rotate=acos(cosrotate);
   float neuwinkel=rotate*128/M_PI;
   v2=neuwinkel/3; // v2 gibt an, um wieviel Schritte rotiert werden muss
   versatz=offset+2+v2;
  };
 // Ok, jetzt wissen wir, um wieviel Schritte gedreht werden muss, aber welche Richtung?
 int delta=3;
 if ((edx * ay - edy * ax) < 0) delta=-3;
 delta=delta*floor(v2);
 if (delta>0)
  {
   qualify_attack(x,y,vx,vy,size,sx,sy,svx,svy,winkel_byte+delta,winkel_byte,v2+offset,as);
   qualify_attack(x,y,vx,vy,size,sx,sy,svx,svy,winkel_byte+delta+3,winkel_byte,v2+offset+1,as);
  } else
  {
   qualify_attack(x,y,vx,vy,size,sx,sy,svx,svy,winkel_byte+delta,winkel_byte,v2+offset,as);
   qualify_attack(x,y,vx,vy,size,sx,sy,svx,svy,winkel_byte+delta-3,winkel_byte,v2+offset+1,as);
  };

 return;*/
};

void Player::qualify_attack(float x,float y, float vx, float vy, float size,
    float sx,float sy, float svx, float svy, int winkel_byte, int alt_winkel,
    int versatz, attack_stats &as)
{
 winkel_byte=winkel_byte&255;
 alt_winkel=alt_winkel&255;
 float dx=x-sx-schuss_start_x[winkel_byte];
 float dy=y-sy-schuss_start_y[winkel_byte];
 float dvx=vx-svx;
 float dvy=vy-svy;
 float relvx=dvx;
 float relvy=dvy;
 dx+=(versatz+2)*dvx;
 dy+=(versatz+2)*dvy;
 dvx-=schuss_vx[winkel_byte];
 dvy-=schuss_vy[winkel_byte];
 float normal_x=-dvy;
 float normal_y=dvx;
 while (dx>512) dx-=1024;
 while (dx<-512) dx+=1024;
 while (dy>384) dy-=768;
 while (dy<-384) dy+=768;
 if (
     (
      (dvx!=0) ||
      (dvy!=0)
     ) &&
     (calc_hitchance(dx,dy,dvx,dvy)<0)
    ) // trifft vielleicht
  {
   float dd=sqrt(dvx*dvx+dvy*dvy);
   float passby=calc_collisionchance(dx,dy,normal_x,normal_y);
   if (fabs(passby)>size-1.0)
    { // trifft nicht, aber vielleicht ja in den Frames danach
    float moving=calc_collisionchance(relvx,relvy,normal_x,normal_y);
    if (
        (moving!=0) &&
        (passby/moving<0)
       )
     {
      int offset=floor(-passby/moving);
      if (offset==0) offset=1;
      if (offset>0)
       {
        versatz+=offset;
        dx+=offset*relvx;
        dy+=offset*relvy;
        passby=calc_collisionchance(dx,dy,normal_x,normal_y);
        int weiter=1;
        while ((fabs(passby)<size-2) && (offset>1) && (weiter) && (offset<200))
         {
          weiter=0;
          float dx2=dx-relvx;
          float dy2=dy-relvy;
          float passby2=calc_collisionchance(dx2,dy2,normal_x,normal_y);
          if (fabs(passby2)<=size-1.0)
           {
            versatz--;
            offset--;
            dx=dx2;dy=dy2;
            passby=passby2;
            weiter=1;
           };
         };
       };
     };
    };
   if (fabs(passby)<=size-1.0)
    { //treffer
     dx-=normal_x*passby/dd;
     dy-=normal_y*passby/dd;
     float time=versatz+2;
     float runtime=0;
     if (fabs(dvx)>fabs(dvy))
      {
       runtime=floor(-dx/dvx);
      } else
      {
       runtime=floor(-dy/dvy);
      };
     if (runtime>68) runtime+=160;
     time+=runtime;

     if (time<as.hit_frame)
      { // so trifft's sich sogar schneller
       int left=0;
       int diff=(winkel_byte-alt_winkel)&255;
       if (diff>127)
        {
         as.left_turns_to_hit=0;
         as.turn_frames=((alt_winkel-winkel_byte)&255)/3;
         as.right_turns_to_hit=0;
         if (as.turn_frames>0.0)
           as.right_turns_to_hit=1;
        } else
        {
         as.right_turns_to_hit=0;
         as.turn_frames=((winkel_byte-alt_winkel)&255)/3;
         as.left_turns_to_hit=0;
         if (as.turn_frames>0.0)
          as.left_turns_to_hit=1;
        };
       as.run_frames=runtime;
       as.hit_frame=time;
       as.waits_before_shoot=as.hit_frame-as.run_frames-as.turn_frames-2;
      };
    }
  };
 return;
};

void Player::calc_attack_stats(GameStatus &rg)
{
 for (int i=0;i<rg.nasteroids;i++)
  {
   int offset=0;
   calc_attack(rg.asteroids[i].x,rg.asteroids[i].y,
               rg.asteroids[i].vx, rg.asteroids[i].vy,
               rg.asteroids[i].size,
               rg.ship_x,rg.ship_y,
               rg.ship_vx,rg.ship_vy,
               rg.ewinkel_byte,0,
//               rg.ewinkel_byte,0,0,
               rg.asteroids[i].as
              );
   while ((offset<400) && (rg.asteroids[i].as.hit_frame>350))
    {
     calc_attack(rg.asteroids[i].x,rg.asteroids[i].y,
                 rg.asteroids[i].vx,rg.asteroids[i].vy,
                 rg.asteroids[i].size,
                 rg.ship_x,rg.ship_y,
                 rg.ship_vx,rg.ship_vy,
                 rg.ewinkel_byte,offset,
//                 rg.ewinkel_byte,0,0,
                 rg.asteroids[i].as
                );
     offset+=20;
    };
   rg.asteroids[i].turn_left_to_hit=false;
   if (rg.asteroids[i].as.left_turns_to_hit)
     rg.asteroids[i].turn_left_to_hit=true;
   rg.asteroids[i].turn_right_to_hit=false;
   if (rg.asteroids[i].as.right_turns_to_hit)
     rg.asteroids[i].turn_right_to_hit=true;

   float danger_x,danger_y,dist;
   float danger=calc_danger(rg.asteroids[i].sf,
    rg.asteroids[i].x,rg.asteroids[i].y,
    rg.asteroids[i].vx,rg.asteroids[i].vy,
    danger_x,danger_y,dist);
   rg.asteroids[i].danger=danger;
   rg.asteroids[i].danger_x=danger_x;
   rg.asteroids[i].danger_y=danger_y;
/*   if (danger<150) weight=weight/12.0;
   if (danger<100) weight=weight/12.0;
   if (danger<50) weight=weight/12.0;*/
   if (danger<rg.min_danger)
    {
     rg.min_danger=danger;
     rg.danger_x=danger_x;
     rg.danger_y=danger_y;
    };
   rg.asteroids[i].important=1;
/*   if (rg.asteroids[i].danger<150)
    rg.asteroids[i].important=40;
   if (rg.asteroids[i].danger<60)
    rg.asteroids[i].important=2;
   if (rg.asteroids[i].danger<40)
    rg.asteroids[i].important=0.01;
   if (rg.asteroids[i].danger<30)
    rg.asteroids[i].important=0.001;
   if (rg.asteroids[i].danger<20)
    rg.asteroids[i].important=0.0001;
   if (rg.asteroids[i].danger<10)
    rg.asteroids[i].important=0.00001;*/
   if (danger<150) rg.asteroids[i].important=0.1;
   if (danger<100) rg.asteroids[i].important=1.0/144.0;
   if (danger<50) rg.asteroids[i].important=1.0/10728.0;

   if (rg.asteroids[i].danger<rg.asteroids[i].as.hit_frame)
    rg.asteroids[i].important=40;
/*   if (
       (rg.asteroids[i].sf==0) &&
       (rg.nasteroids<20)
      )
    rg.asteroids[i].important=rg.asteroids[i].important*0.8;
   if (
       (rg.asteroids[i].sf==15) &&
       (rg.nasteroids<20)
      )
    rg.asteroids[i].important=rg.asteroids[i].important*0.9;*/
   if (
       (rg.asteroids[i].sf==0) &&
       (rg.nasteroids>22)
      )
    rg.asteroids[i].important=rg.asteroids[i].important*8;
   if (
       (rg.asteroids[i].sf==15) &&
       (rg.nasteroids>22)
      )
    rg.asteroids[i].important=rg.asteroids[i].important*8;

   if (dist<rg.min_dist) rg.min_dist = dist;
   rg.asteroids[i].dist=dist;
   if ((dist>300) && (rg.asteroids[i].tracked<8))
    rg.asteroids[i].important=rg.asteroids[i].important*10000000;
   if ((dist>300) && (rg.nasteroids>3))
    rg.asteroids[i].overkill=1;

   if (dist<rg.min_dist) rg.min_dist = dist;
  };
 // Asteroiden-Angriffswinkel/-Werte sind berechnet, jetzt noch das UFO
 if (rg.saucer_present)
  calc_attack(rg.saucer_x,rg.saucer_y,
               rg.saucer_vx, rg.saucer_vy,
               8,
               rg.ship_x,rg.ship_y,
               rg.ship_vx,rg.ship_vy,
               rg.ewinkel_byte,0,
               rg.saucer_as
              );

};

float Player::test_if_shot_hits(int snr, int anr, GameStatus &rg)
{
 float dx,dy,dvx,dvy;
 float size=8;
 if (anr<rg.nasteroids)
  {
   dx=rg.asteroids[anr].x-rg.shots[snr].x;
   dy=rg.asteroids[anr].y-rg.shots[snr].y;
   dvx=rg.asteroids[anr].vx-rg.shots[snr].vx;
   dvy=rg.asteroids[anr].vy-rg.shots[snr].vy;
   size=rg.asteroids[anr].size;
  } else
  {
   dx=rg.saucer_x-rg.shots[snr].x;
   dy=rg.saucer_y-rg.shots[snr].y;
   dvx=rg.saucer_vx-rg.shots[snr].vx;
   dvy=rg.saucer_vy-rg.shots[snr].vy;
   size=10;
  };
 float normal_x=-dvy;
 float normal_y=dvx;
 while (dx>512) dx-=1024;
 while (dx<-512) dx+=1024;
 while (dy>384) dy-=768;
 while (dy<-384) dy+=768;
 float time=10000;
 if (
     (dvx!=0) ||
     (dvy!=0)
    )
  {
   float hitchance=fabs(calc_collisionchance(dx,dy,normal_x,normal_y));
   if (
       (hitchance<size) &&
       (calc_hitchance(dx,dy,dvx,dvy)<0)
      )
    {// trifft !
     float tt=(dx*dx+dy*dy)/(dvx*dvx+dvy*dvy);
     time=sqrt(tt);
    };
  };
 return time;
};

void Player::work_shotlist(GameStatus &rg)
{
 int shot_hits[8];
 float shot_hits_frame[8];
 for (int i=0;i<rg.nasteroids;i++)
  rg.asteroids[i].hitcount=0;
 rg.saucer_hitcount=0;
 for (int i=0;i<8;i++)
  {
   shot_hits[i]=255;
   shot_hits_frame[i]=10000;
  };
 int geaendert=0;
 do
 {
  geaendert=0;
  for (int snr=0;snr<rg.nshots;snr++)
   {
    for (int anr=0;anr<rg.nasteroids;anr++)
     {
      float frame=test_if_shot_hits(snr,anr,rg);
      if (
          (frame<shot_hits_frame[snr]) &&
          (frame<69-rg.shots[snr].age)
         )
       {
        int hits_before=0;
        for (int tsnr=0;tsnr<rg.nshots;tsnr++)
         {
          if (
              (shot_hits[tsnr]<rg.nasteroids) &&
              (shot_hits[tsnr]==anr) &&
              (tsnr!=snr) &&
              (shot_hits_frame[tsnr]<frame)
             )
           hits_before++;
         };
        if (hits_before<rg.asteroids[anr].overkill)
         {
          shot_hits[snr]=anr;
          shot_hits_frame[snr]=frame;
          geaendert=1;
         };
        if (
            (hits_before>=rg.asteroids[anr].overkill) &&
            (shot_hits[snr]==anr)
           )
         {
          shot_hits[snr]=255;
          shot_hits_frame[snr]=10000;
          geaendert=1;
         };
       }; // if shot might hit asteroid
     }; // for each asteroid
    float sframe=test_if_shot_hits(snr,200,rg);
    if (
        (sframe<shot_hits_frame[snr]) &&
        (sframe<69-rg.shots[snr].age)
       )
     {
      shot_hits[snr]=200;
      shot_hits_frame[snr]=sframe;
      geaendert=1;
     };
   }; // for each shot

 } while(geaendert==1);
 int player_shots=0;
 int wait_for_next_shot=69;
 for (int i=0;i<rg.nshots;i++)
  {
   if (shot_hits[i]<rg.nasteroids)
    rg.asteroids[shot_hits[i]].hitcount++;
   if (shot_hits[i]==200)
    rg.saucer_hitcount++;
   if (rg.shots[i].player_shot)
    player_shots++;
   rg.shots[i].rest_life=69-rg.shots[i].age;
   if (shot_hits_frame[i]<rg.shots[i].rest_life)
    rg.shots[i].rest_life=shot_hits_frame[i];
   if (
       (rg.shots[i].player_shot) &&
       (rg.shots[i].rest_life<wait_for_next_shot)
      )
    wait_for_next_shot=rg.shots[i].rest_life;
  };
 if (rg.player_shots<3) wait_for_next_shot=0;
 rg.wait_for_next_shot=wait_for_next_shot;
 for (int i=0;i<rg.nasteroids;i++)
  {
   if (
       (rg.asteroids[i].hitcount==0) &&
       (rg.asteroids[i].ignore)
      )
    rg.asteroids[i].hitcount=1;
   if (
       (rg.asteroids[i].hitcount<2) &&
       (rg.asteroids[i].ignore>20)
      )
    rg.asteroids[i].hitcount=2;
  };
 if (
     (rg.saucer_present) &&
     (rg.saucer_hitcount==0) &&
     (rg.saucer_ignore)
    )
  rg.saucer_hitcount=1;
 rg.player_shots=player_shots;
};
