// player.h: Beispielspieler fr Asteroids
// Harald Bgeholz / c't
#if defined(WINDOWS)
#define ADDRESS DWORD
#else
#define SOCKET int
#define ADDRESS in_addr_t
// 3 Includes fr sockaddr_in
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#endif

int last_shot_on=0;

float winkel[]={
0.00,0.90,2.80,3.60,5.50,7.20,8.20,10.10,11.00,12.70,13.90,15.50,
16.50,18.40,19.30,21.20,22.50,23.40,25.20,26.60,28.10,29.50,30.60,32.80,
33.50,34.70,36.70,37.80,39.20,40.60,41.70,43.80,45.00,46.20,48.30,49.40,
50.80,52.20,53.30,55.30,56.50,57.20,59.40,60.50,61.90,63.40,64.70,66.60,
67.50,68.80,70.70,71.60,73.50,74.50,76.10,77.30,79.00,79.90,81.80,82.80,
84.50,86.40,87.20,89.10,90.00,91.90,92.80,94.50,95.50,97.20,98.90,100.10,
101.80,102.70,104.70,105.50,107.30,108.40,110.20,111.20,113.40,114.10,115.30,117.30,
118.10,120.20,121.40,122.80,124.20,125.60,126.70,127.80,130.00,131.10,132.50,133.80,
135.00,136.10,138.30,139.40,140.80,142.20,143.30,145.30,146.50,147.90,149.80,151.00,
151.90,153.90,155.00,156.60,157.90,158.80,160.70,161.80,163.60,164.50,166.30,167.30,
169.20,170.10,171.80,172.80,174.30,176.60,177.30,179.10,180.00,181.90,182.90,184.40,
185.50,187.20,188.90,189.90,191.50,192.70,194.50,195.60,197.30,198.20,200.30,201.20,
203.00,204.10,205.00,206.90,208.10,209.70,211.00,212.10,214.20,215.40,216.60,217.80,
220.00,221.00,222.50,223.80,225.00,226.20,227.50,228.90,230.00,232.20,233.30,234.60,
235.90,237.80,239.00,240.30,241.90,243.10,245.10,245.90,247.00,248.80,249.80,251.80,
252.70,254.50,255.50,257.30,258.40,260.10,261.10,262.80,264.50,265.60,267.30,268.10,
270.00,270.90,272.70,273.60,275.50,277.20,278.20,279.90,280.80,282.70,283.70,285.50,
286.50,288.20,289.30,291.20,292.10,293.40,295.00,296.10,298.10,299.00,300.20,302.20,
303.50,304.70,306.70,307.80,309.20,310.60,311.70,313.80,315.00,316.20,317.50,318.90,
320.00,322.20,323.30,324.50,325.80,327.20,328.60,329.80,331.90,332.70,334.70,335.90,
336.60,338.80,339.80,341.60,342.70,344.50,345.30,347.20,348.20,349.90,351.10,352.80,
354.50,355.50,357.20,358.10
};

float schuss_vx[256]={
0.000,-0.270,-0.393,-0.611,-0.782,-1.000,-1.218,-1.389,-1.607,-1.730,-2.000,-2.147,-2.393,-2.488,-2.782,-2.877,
-3.123,-3.218,-3.389,-3.607,-3.730,-4.000,-4.147,-4.270,-4.488,-4.611,-4.782,-4.877,-5.123,-5.218,-5.389,-5.512,
-5.607,-5.730,-5.853,-6.000,-6.147,-6.270,-6.393,-6.488,-6.611,-6.782,-6.877,-7.000,-7.000,-7.123,-7.218,-7.218,
-7.389,-7.389,-7.512,-7.607,-7.607,-7.607,-7.730,-7.730,-7.853,-7.853,-7.853,-7.853,-7.853,-8.000,-8.000,-8.000,
-8.000,-8.000,-8.000,-8.000,-7.853,-7.853,-7.853,-7.853,-7.853,-7.730,-7.730,-7.607,-7.607,-7.607,-7.512,-7.389,
-7.389,-7.218,-7.218,-7.123,-7.000,-7.000,-6.877,-6.782,-6.611,-6.488,-6.393,-6.270,-6.147,-6.000,-5.853,-5.730,
-5.607,-5.512,-5.389,-5.218,-5.123,-4.877,-4.782,-4.611,-4.488,-4.270,-4.147,-4.000,-3.730,-3.607,-3.389,-3.218,
-3.123,-2.877,-2.782,-2.488,-2.393,-2.147,-2.000,-1.730,-1.607,-1.389,-1.218,-1.000,-0.782,-0.611,-0.393,-0.270,
0.000,0.147,0.393,0.488,0.782,1.000,1.123,1.389,1.512,1.730,1.853,2.147,2.270,2.488,2.611,2.877,
3.000,3.123,3.389,3.512,3.730,3.853,4.000,4.270,4.393,4.488,4.782,4.877,5.000,5.123,5.218,5.512,
5.607,5.730,5.853,6.000,6.147,6.270,6.393,6.488,6.611,6.611,6.782,6.877,7.000,7.000,7.123,7.218,
7.218,7.389,7.512,7.512,7.607,7.607,7.607,7.730,7.730,7.730,7.853,7.853,7.853,7.853,7.853,7.853,
7.853,7.853,7.853,7.853,7.853,7.853,7.853,7.730,7.730,7.730,7.607,7.607,7.607,7.512,7.512,7.389,
7.218,7.218,7.123,7.000,7.000,6.877,6.782,6.611,6.611,6.488,6.393,6.270,6.147,6.000,5.853,5.730,
5.607,5.512,5.218,5.119,5.000,4.877,4.782,4.488,4.393,4.270,4.000,3.853,3.730,3.512,3.389,3.123,
3.000,2.877,2.611,2.488,2.270,2.147,1.857,1.730,1.512,1.389,1.123,1.000,0.782,0.488,0.393,0.147
};
float schuss_vy[256]={
7.853,7.853,7.853,7.853,7.853,7.853,7.853,7.730,7.730,7.730,7.607,7.607,7.607,7.512,7.512,7.389,
7.218,7.218,7.123,7.000,7.000,6.877,6.782,6.611,6.611,6.488,6.393,6.270,6.147,6.000,5.853,5.730,
5.607,5.512,5.218,5.123,5.000,4.877,4.782,4.488,4.393,4.270,4.000,3.853,3.730,3.512,3.389,3.123,
3.000,2.877,2.611,2.488,2.270,2.147,1.853,1.730,1.512,1.389,1.123,1.000,0.782,0.488,0.393,0.147,
0.000,-0.270,-0.393,-0.611,-0.782,-1.000,-1.218,-1.389,-1.607,-1.730,-2.000,-2.147,-2.393,-2.488,-2.782,-2.877,
-3.123,-3.218,-3.389,-3.607,-3.730,-4.000,-4.147,-4.270,-4.488,-4.611,-4.782,-4.877,-5.123,-5.218,-5.389,-5.512,
-5.607,-5.730,-5.853,-6.000,-6.147,-6.270,-6.393,-6.488,-6.611,-6.782,-6.877,-7.000,-7.000,-7.123,-7.218,-7.218,
-7.389,-7.389,-7.512,-7.607,-7.607,-7.607,-7.730,-7.730,-7.853,-7.853,-7.853,-7.853,-7.853,-8.000,-8.000,-8.000,
-8.000,-8.000,-8.000,-8.000,-7.853,-7.853,-7.853,-7.853,-7.853,-7.730,-7.730,-7.607,-7.607,-7.607,-7.512,-7.389,
-7.389,-7.218,-7.218,-7.123,-7.000,-7.000,-6.877,-6.782,-6.611,-6.488,-6.393,-6.270,-6.147,-6.000,-5.853,-5.730,
-5.607,-5.512,-5.389,-5.218,-5.123,-4.877,-4.782,-4.611,-4.488,-4.270,-4.147,-4.000,-3.730,-3.607,-3.389,-3.218,
-3.123,-2.877,-2.782,-2.488,-2.393,-2.147,-2.000,-1.730,-1.607,-1.389,-1.218,-1.000,-0.782,-0.611,-0.393,-0.270,
0.000,0.147,0.393,0.488,0.782,1.000,1.123,1.389,1.512,1.730,1.853,2.147,2.270,2.488,2.611,2.877,
3.000,3.123,3.389,3.512,3.730,3.853,4.000,4.270,4.393,4.488,4.782,4.877,5.000,5.123,5.218,5.512,
5.607,5.730,5.853,6.000,6.147,6.270,6.393,6.488,6.611,6.611,6.782,6.877,7.000,7.000,7.123,7.218,
7.218,7.389,7.512,7.512,7.607,7.607,7.619,7.730,7.730,7.730,7.853,7.853,7.853,7.853,7.853,7.853
};
float schuss_start_x[256]={
0,-1,-1,-2,-2,-3,-4,-4,-5,-5,-5,-6,-6,-7,-7,-8,
-8,-9,-9,-10,-10,-10,-11,-11,-12,-12,-12,-13,-13,-14,-14,-14,
-15,-15,-15,-15,-16,-16,-16,-17,-17,-17,-18,-18,-18,-18,-19,-19,
-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,
-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,
-19,-19,-19,-18,-18,-18,-18,-17,-17,-17,-16,-16,-16,-15,-15,-15,
-15,-14,-14,-14,-13,-13,-12,-12,-12,-11,-11,-10,-10,-10,-9,-9,
-8,-8,-7,-7,-6,-6,-5,-5,-5,-4,-4,-3,-2,-2,-1,-1,
0,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,
7,7,8,8,9,9,10,10,10,11,11,12,12,12,13,13,
14,14,14,15,15,15,15,16,16,16,16,17,17,17,17,18,
18,18,18,18,19,19,19,19,19,19,19,19,19,19,19,19,
19,19,19,19,19,19,19,19,19,19,19,19,19,18,18,18,
18,18,17,17,17,17,16,16,16,16,15,15,15,15,14,14,
14,13,13,12,12,12,11,11,10,10,10,9,9,8,8,7,
7,7,6,6,5,5,4,4,3,3,2,2,1,1,0,0
};
float schuss_start_y[256]={
19,19,19,19,19,19,19,19,19,19,19,19,19,18,18,18,
18,18,17,17,17,17,16,16,16,16,15,15,15,15,14,14,
14,13,13,12,12,12,11,11,10,10,10,9,9,8,8,7,
7,7,6,6,5,5,4,4,3,3,2,2,1,1,0,0,
0,-1,-1,-2,-2,-3,-4,-4,-5,-5,-5,-6,-6,-7,-7,-8,
-8,-9,-9,-10,-10,-10,-11,-11,-12,-12,-12,-13,-13,-14,-14,-14,
-15,-15,-15,-15,-16,-16,-16,-17,-17,-17,-18,-18,-18,-18,-19,-19,
-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,
-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,
-19,-19,-19,-18,-18,-18,-18,-17,-17,-17,-16,-16,-16,-15,-15,-15,
-15,-14,-14,-14,-13,-13,-12,-12,-12,-11,-11,-10,-10,-10,-9,-9,
-8,-8,-7,-7,-6,-6,-5,-5,-5,-4,-4,-3,-2,-2,-1,-1,
0,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,
7,7,8,8,9,9,10,10,10,11,11,12,12,12,13,13,
14,14,14,15,15,15,15,16,16,16,16,17,17,17,17,18,
18,18,18,18,19,19,19,19,19,19,19,19,19,19,19,19
};
float schuss_v[256]={
7.853,7.858,7.863,7.877,7.892,7.917,7.947,7.854,7.895,7.921,7.866,7.904,7.975,7.913,8.010,7.929,
7.865,7.903,7.888,7.875,7.932,7.956,7.949,7.870,7.991,7.960,7.983,7.943,8.002,7.952,7.956,7.951,
7.930,7.951,7.842,7.890,7.924,7.943,7.983,7.889,7.938,8.014,7.956,7.990,7.932,7.942,7.974,7.865,
7.975,7.929,7.953,8.004,7.939,7.904,7.949,7.921,7.997,7.975,7.933,7.917,7.892,8.015,8.010,8.001,
8.000,8.005,8.010,8.023,7.892,7.917,7.947,7.975,8.016,7.921,7.985,7.904,7.975,8.004,8.010,7.929,
8.022,7.903,7.974,7.984,7.932,8.062,8.031,8.014,7.991,7.960,7.983,7.943,8.002,7.952,7.956,7.951,
7.930,7.951,7.956,7.952,8.002,7.943,7.983,7.960,7.991,8.014,8.031,8.062,7.932,7.984,7.974,7.903,
8.022,7.929,8.010,8.004,7.975,7.904,7.985,7.921,8.016,7.975,7.947,7.917,7.892,8.023,8.010,8.005,
8.000,8.001,8.010,8.015,7.892,7.917,7.933,7.975,7.997,7.921,7.949,7.904,7.939,8.004,7.953,7.929,
7.975,7.865,7.974,7.942,7.932,7.990,7.956,8.014,7.938,7.889,7.983,7.943,7.924,7.890,7.842,7.951,
7.930,7.951,7.956,7.952,8.002,7.943,7.983,7.960,7.991,7.870,7.949,7.956,7.932,7.875,7.888,7.903,
7.865,7.929,8.010,7.913,7.975,7.904,7.866,7.921,7.895,7.854,7.947,7.917,7.892,7.877,7.863,7.858,
7.853,7.855,7.863,7.868,7.892,7.917,7.933,7.854,7.877,7.921,7.830,7.904,7.939,7.913,7.953,7.929,
7.817,7.865,7.888,7.832,7.932,7.883,7.874,7.870,7.938,7.889,7.983,7.943,7.924,7.890,7.842,7.951,
7.930,7.951,7.842,7.887,7.924,7.943,7.983,7.889,7.938,7.870,7.874,7.883,7.932,7.832,7.888,7.865,
7.817,7.929,7.953,7.913,7.939,7.904,7.842,7.921,7.877,7.854,7.933,7.917,7.892,7.868,7.863,7.855
};

struct attack_stats
{
 int left_turns_to_hit;
 int right_turns_to_hit;
 int waits_before_shoot;
 float hit_frame;
 float turn_frames;
 float run_frames;
};
struct bereich
{
 int min;
 int max;
};
bereich minmax[64]=
{
{189,195},{196,199},{200,203},{204,207},{208,211},{212,215},{216,219},{220,223},
{224,227},{228,231},{232,235},{236,239},{240,243},{244,247},{248,251},{252,255},
{0,0},{1,4},{5,8},{9,12},{13,16},{17,20},{21,24},{25,28},
{29,32},{33,36},{37,40},{41,44},{45,48},{49,52},{53,56},{57,60},
{61,67},{68,71},{72,75},{76,79},{80,83},{84,87},{88,91},{92,95},
{96,99},{100,103},{104,107},{108,111},{112,115},{116,119},{120,123},{124,127},
{128,128},{129,132},{133,136},{137,140},{141,144},{145,148},{149,152},{153,156},
{157,160},{161,164},{165,168},{169,172},{173,176},{177,180},{181,184},{185,188}
};

static const int MAX_ASTEROIDS = 30;
static const int MAX_SHOTS = 10;

class Asteroid
{
public:
	float x;    // Koordinaten des Mittelpunkts
	float y;
        float vx;   // Geschwindigkeit
        float vy;
        float dx;
        float dy;
        float dist;
        float hitchance;
        float bypass;
        bool turn_left_to_hit;
        bool turn_right_to_hit;
        float weight;
        float important;
        float danger;
        float danger_x;
        float danger_y;
        float time_to_hit;
        float max_delta;
        int next_one;
        int tracked;
        int pre_frame;
        int next_frame;
        int overkill;
        int ignore;
        int hitcount;
        attack_stats as;
	int type; // 1 ... 4, uere Form
	int sf;   // scale factor: 0 = gro, 15 = mittel, 14 = klein
        float size;

	void set(int x, int y, int type, int sf);
};

struct asteroid_set {
 int n;
 int mapping[30];
 float mapped_dist[30];
 Asteroid asteroids[30];
};

class Shot
{
public:
	float x;
	float y;
        float vx;
        float vy;
        int pre_frame;
        int next_frame;
        int tracked;
        int age;
        int player_shot;
        int rest_life;
	void set(int x, int y);
};

class GameStatus
{
public:
	bool ship_present;  // Schiff sichtbar
	float ship_x;         // Mittelpunkt des Schiffs
	float ship_y;
	float ship_dx;        // Blickrichtung des Schiffes
	float ship_dy;
        float ship_edx;        // Blickrichtung des Schiffes
	float ship_edy;
        int ship_sprite;
        unsigned char winkel_byte;
        unsigned char ewinkel_byte;
        bereich winkel_bereich;
        float ship_angle;
        float ship_expected_angle;
        float ship_dangle;
        float ship_rot;
        bool ship_thrust;
        bool ship_break;
        bool ship_left;
        bool ship_right;
        bool ship_fire;
        float ship_vx;        // Bewegung des Schiffes
        float ship_vy;
        int ship_target;
	bool saucer_present;// UFO sichtbar
        int saucer_hitcount;
	float saucer_x;       // Mittelpunkt des UFOs
	float saucer_y;
        float saucer_vx;      // Bewegung des Ufos
        float saucer_vy;
        int saucer_ignore;
        attack_stats saucer_as;

        float min_danger;
        float min_dist;
        float danger_x;
        float danger_y;
        float min_weight;
        float sum_weight;
	int saucer_size;    // Gre: 15 = gro, 14 = klein
        int asteroids_to_go;
	int nasteroids; // Anzahl Asteroiden
	Asteroid asteroids[MAX_ASTEROIDS];
	int nshots;     // Anzahl Schsse
        int phantom_shot;
        int player_shots;
        int wait_for_next_shot;
        int level;
	Shot shots[MAX_SHOTS];
	void clear(void);
        unsigned long score;
        int life;
        unsigned long startzeit;
        int main_target;
        int main_target_count;
        float main_target_start_hitframe;
        float min_weight_to_shoot;
        int sec_target;
        float sec_target_start_hitframe;
};

#pragma pack(1)
struct FramePacket
{
	char vectorram[1024];
	char frameno;  // wird bei jedem Frame inkrementiert
	char ping;     // Der Server schickt das letzte empfangene ping-Byte zurck
};

class KeysPacket
{
private:
	static const char KEY_HYPERSPACE = 1;
	static const char KEY_FIRE = 2;
	static const char KEY_THRUST = 4;
	static const char KEY_RIGHT = 8;
	static const char KEY_LEFT = 0x10;

	char signature[6];
	char keys;
public:
	char ping;     // wird vom Server bei nchster Gelegenheit zurckgeschickt. Fr Latenzmessung.

	KeysPacket(void);
	void clear(void);         // alle Tasten loslassen
	void hyperspace(bool b);  // Hyperspace drcken (true) oder loslassen (false)
	void fire(bool b);        // Feuerknopf drcken (true) oder loslassen (false)
	void thrust(bool b);      // Beschleunigen ...
	void right(bool b);       // rechts drehen ...
	void left(bool b);        // links drehen
};
#pragma pack()


class Player
{
public:
	Player(SOCKET sd, ADDRESS server_ip) : sd(sd), server_ip(server_ip) {};
	void Run(void);
	void InterpretScreen(FramePacket &packet, GameStatus& game);
	void ReceivePacket(FramePacket &packet);
	void SendPacket(KeysPacket &packet);
        float calc_hitchance(float dx1, float dy1, float dx2, float dy2);
        float calc_collisionchance(float dx1, float dy1, float dx2, float dy2);
        float calc_attack_angle(float zx,float zy,float zvx,float zvy,float &ax, float &ay,float &time);
        float calc_weight(int sf, float zx, float zy, float zvx, float zvy, float &distance,float &dx, float &dy);
        float calc_saucer_weight(int sf, float zx, float zy, float zvx, float zvy, float &distance,float &dx, float &dy);
        float calc_danger(int sf, float zx, float zy, float zvx, float zvy, float &dx, float &dy,float &dist);
        void work_shotlist(GameStatus &rg);
        void calc_attack(float x,float y, float vx, float vy, float size, float sx,float sy, float svx, float svy, int winkel_byte, int offset,attack_stats &as);
        void calc_attack_stats(GameStatus &rg);
        void qualify_attack(float x,float y, float vx, float vy, float size, float sx,float sy, float svx, float svy, int winkel_byte, int versatz, int alt_winkel, attack_stats &as);
        float asteroids_in_range(float x, float y, GameStatus &rg);
        int calc_asteroid_weights(GameStatus &rg);
        int get_ship_angle(int dx, int dy);
        void calculate_speeds(GameStatus *game, GameStatus *pre_game);
        float test_if_shot_hits(int snr, int anr, GameStatus &rg);
        float would_hit(float x, float y, float vx, float vy, float frames,GameStatus &rg);
        int test_if_ship_shows_to(float x, float y, GameStatus &rg);
        GameStatus game;
        GameStatus game_alt[32];
        bool fire;
private:
	SOCKET sd;
	ADDRESS server_ip;
};



