LRESULT CALLBACK window3d_cb(
   HWND hwnd,
   UINT uMsg,
   WPARAM wParam,
   LPARAM lParam)
{
 switch (uMsg)
  {
   case WM_KEYDOWN:
    keydown_handler(hwnd,uMsg,wParam,lParam);
    break;
   case WM_KEYUP:
    keyup_handler(hwnd,uMsg,wParam,lParam);
    break;
   case WM_CREATE:
    {
     PIXELFORMATDESCRIPTOR pfd;
     HDC dc=GetDC(hwnd);
     pfd.nSize=sizeof(PIXELFORMATDESCRIPTOR);
     pfd.nVersion=1;
     int numpfds=DescribePixelFormat(dc,1,sizeof(PIXELFORMATDESCRIPTOR),&pfd);
     int i=1;
     int formatfound=0;
     while ((i<=numpfds) && (formatfound==0))
      {
       pfd.nSize=sizeof(PIXELFORMATDESCRIPTOR);
       pfd.nVersion=1;
       DescribePixelFormat(dc,i,sizeof(PIXELFORMATDESCRIPTOR),&pfd);
       if (
           (pfd.dwFlags & PFD_SUPPORT_OPENGL) &&
           (pfd.dwFlags & PFD_DOUBLEBUFFER) &&
           ((pfd.dwFlags & PFD_GENERIC_FORMAT)==0) &&
           (pfd.iPixelType == PFD_TYPE_RGBA) &&
           (pfd.dwFlags & PFD_DRAW_TO_WINDOW) &&
           (pfd.iLayerType == PFD_MAIN_PLANE)
          )
        formatfound=i;
       i++;
      };
     SetPixelFormat(dc, formatfound, &pfd);
     ReleaseDC(hwnd,dc);
    };
   break;
   case WM_DESTROY:
   main_quit=1;
   break;
   case WM_MOVE:
   case WM_SIZE:
    {
     RECT rect;
     GetClientRect(hwnd,&rect);

     glViewport(0,0,rect.right,rect.bottom);
     glMatrixMode( GL_MODELVIEW );
     glLoadIdentity();
     glMatrixMode( GL_PROJECTION );
     glLoadIdentity();
     glOrtho(0.0,1024,128.0,896.0,-1.0,1.0);
     glDrawBuffer(GL_BACK);
    }
    return 0;
   default:
   break;
  };
 return DefWindowProc(hwnd,uMsg,wParam,lParam);
};

fenster3d::fenster3d()
{
 hwnd=0;
 window3d_class.style=CS_HREDRAW | CS_VREDRAW | CS_OWNDC;
 window3d_class.lpfnWndProc=(WNDPROC) window3d_cb;
 window3d_class.cbClsExtra=0;
 window3d_class.cbWndExtra=0;
 window3d_class.hInstance=0;
 window3d_class.hIcon=LoadIcon(NULL, IDI_WINLOGO);
 window3d_class.hCursor=LoadCursor(NULL, IDC_ARROW);
 window3d_class.hbrBackground=0;
 window3d_class.lpszMenuName=NULL;
 window3d_class.lpszClassName="Asteroids 3D-client";
 RegisterClass(&window3d_class);
 frame_mutex=CreateMutex(0,0,0);
 ansicht3d=0;
 object_style=0;
};

fenster3d::~fenster3d()
{
 CloseHandle(frame_mutex);
 wglMakeCurrent(NULL,NULL);
 if (gl_rc)
  wglDeleteContext(gl_rc);
 gl_rc=0;
 ReleaseDC(hwnd,dc);
 dc=0;
 DestroyWindow(hwnd);
 hwnd=0;
};

void fenster3d::activate()
{
 if (hwnd==0)
  { // Fenster wurde noch nicht erstellt, neu erschaffen
   hwnd=CreateWindow(
    "Asteroids 3D-client",
    "Asteroids 3D-client",
    WS_OVERLAPPED | WS_CLIPCHILDREN | WS_CLIPSIBLINGS |
    WS_VISIBLE | WS_SYSMENU | WS_MINIMIZEBOX | WS_SIZEBOX,
    CW_USEDEFAULT,0,
    640,640,
    NULL,  //Parent
    NULL,
    0,NULL
    );
   dc=GetDC(hwnd);
   gl_rc=wglCreateContext(dc);
   wglMakeCurrent(dc, gl_rc);
   glDisable(GL_CULL_FACE);
   glDisable(GL_DEPTH_TEST);
   glDisable(GL_LIGHTING);
   glDisable(GL_COLOR_MATERIAL);
   glDisable(GL_BLEND);
   glDisable(GL_POLYGON_SMOOTH);
   glDisable(GL_POLYGON_STIPPLE);
   glDisable(GL_ALPHA_TEST);
   glEnable(GL_NORMALIZE);
   glListBase (32);
   HFONT font=CreateFont(24,12,
                       0,0,500,
                       0,0,0,DEFAULT_CHARSET,
                       OUT_TT_PRECIS,CLIP_DEFAULT_PRECIS,
                       PROOF_QUALITY,FIXED_PITCH,NULL);
   if (font)
    {
     SelectObject(dc,font);
     SetTextColor(dc,0x0afafaf);
     SetBkMode(dc,TRANSPARENT);
     wglUseFontBitmaps(dc,0,255,32);
     DeleteObject(font);
    }
   glGenTextures(6,&(star_texture[0]));
   int size=1024;
   glGetIntegerv(GL_MAX_TEXTURE_SIZE,&size);
   if (size>512) size=512;
   unsigned int *texture_buffer=new unsigned int[size*size];
   for(int i=0;i<6;i++)
    {
     glEnable(GL_TEXTURE_2D);
     glBindTexture(GL_TEXTURE_2D,star_texture[i]);
     for (int y=0;y<size;y++)
      for (int x=0;x<size;x++)
       texture_buffer[size*y+x]=0;
     for(int nr=0;nr<500;nr++)
      {
       int x=rand()*(size-1)/RAND_MAX;
       int y=rand()*(size-1)/RAND_MAX;
       int c1=255;
       int c2=255;
       int c3=255;
       if (RAND_MAX/rand()>2) c2=128;
       if (RAND_MAX/rand()>2) c1=128;
       texture_buffer[size*y+x]=(c1<<8)+(c2<<16)+c3;
      }
     glTexImage2D(GL_TEXTURE_2D,0,GL_RGBA8,
       size,size,0,
       GL_RGBA,GL_UNSIGNED_BYTE,texture_buffer);
     glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
     glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
     glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_CLAMP);
     glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_CLAMP);
     glDisable(GL_TEXTURE_2D);
    };
   delete texture_buffer;
   texture_buffer=NULL;
   SwapBuffers(dc);
  };
 ShowWindow(hwnd,SW_SHOW);
};

void fenster3d::test()
{
 SwapBuffers(dc);
};

void fenster3d::new_frame(GameStatus& ng)
{
 WaitForSingleObject(frame_mutex,INFINITE);
 memcpy(&game,&ng,sizeof(GameStatus));
 ReleaseMutex(frame_mutex);
};

void fenster3d::draw()
{
 GameStatus rg;
 char *text="                            ";
 WaitForSingleObject(frame_mutex,INFINITE);
 memcpy(&rg,&game,sizeof(GameStatus));
 ReleaseMutex(frame_mutex);

 glClearColor(0,0,0,1);
 glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);


 set_projection(rg);
 if (show_stars)
  draw_stars(rg);
 if (show_grid)
  draw_wireframe();
 glDisable(GL_LIGHT1);
 glDisable(GL_LIGHT2);
 glDisable(GL_LIGHT3);
 glDisable(GL_LIGHT4);
 glDisable(GL_LIGHT5);
 glDisable(GL_LIGHT6);
 glDisable(GL_LIGHT7);
 for (int i=0;i<rg.nshots;i++)
  set_shot_light(rg.shots[i].x,rg.shots[i].y,rg.ship_x,rg.ship_y,i);
 if (rg.ship_thrust)
  set_thrust_light(rg);
 for (int i=0;i<rg.nasteroids;i++)
  {
   set_position(rg.asteroids[i].x,rg.asteroids[i].y,rg.ship_x,rg.ship_y);
   float size;
   switch (rg.asteroids[i].sf)
    {
     case 0:  // groer Asteroid
      size = 32;
      break;
     case 15: // mittlerer Asteroid
      size = 16;
      break;
     case 14: // kleiner Asteroid
      size = 8;
      break;
     default:
      size = 1;
    }
   glScalef(size,size,size);
   draw_asteroid(rg.asteroids[i].type);
//   if (rg.asteroids[i].hitcount>=rg.asteroids[i].overkill)
/*    {
     sprintf(text,"%.0f,%i",rg.asteroids[i].as.hit_frame,rg.asteroids[i].hitcount);
     glRasterPos2f(-1,-3);
     glCallLists(strlen(text),GL_UNSIGNED_BYTE,text);
    };*/
  }; // for each asteroid
 if (rg.ship_present)
  {
   set_position(rg.ship_x,rg.ship_y,rg.ship_x,rg.ship_y);
   glScalef(12.5,12.5,12.5);
   glRotatef((rg.ship_angle*180/M_PI)-90.0,0,0,1.0);
   if (object_style) glRotatef((rg.ship_rot*180/M_PI_2),0,1,0);
   glRotatef(M_PI,0,1,0);
   draw_ship();
   if (rg.ship_thrust)
    draw_ship_thrust();
  };
 if (rg.saucer_present)
  {
   set_position(rg.saucer_x,rg.saucer_y,rg.ship_x,rg.ship_y);
   switch (rg.saucer_size)
    {
     case 15: // groes UFO
      glScalef(18,18,18);
      break;
     case 14: // kleines UFO
     default:
      glScalef(9,9,9);
      break;
    }
   draw_saucer();
  };
 if (show_velocity)
  {
   glColor3f(0.2,1.0,0.2);
   for (int i=0;i<rg.nasteroids;i++)
    {
     set_position(rg.asteroids[i].x,rg.asteroids[i].y,rg.ship_x,rg.ship_y);
     draw_velocity(rg.asteroids[i].vx,rg.asteroids[i].vy);
    };
   if (rg.saucer_present)
    {
     set_position(rg.saucer_x,rg.saucer_y,rg.ship_x,rg.ship_y);
     draw_velocity(rg.saucer_vx,rg.saucer_vy);
    };
   if (rg.ship_present)
    {
     set_position(rg.ship_x,rg.ship_y,rg.ship_x,rg.ship_y);
     draw_velocity(rg.ship_vx,rg.ship_vy);
//     glColor3f(1.0,1.0,0.2);
//     draw_velocity(rg.ship_edx*20,rg.ship_edy*20);
     if ((rg.danger_x!=0) || (rg.danger_y!=0))
      {
       glColor3f(1.0,0.2,0.2);
       glBegin(GL_LINES);
       glVertex3f(0,0,0);
       glVertex3f(rg.danger_x,rg.danger_y,0);
       glEnd();
      };
    };
  };
 for (int i=0;i<rg.nshots;i++)
  {
   set_position(rg.shots[i].x,rg.shots[i].y,rg.ship_x,rg.ship_y);
   glColor3f(1.0,1.0,0.2);
//   if (show_velocity)
//     draw_velocity(rg.shots[i].vx,rg.shots[i].vy);
   draw_shot();
  }; // for each shot
 draw_stats(rg);
 if (keyhelp) draw_help();  
 SwapBuffers(dc);
};

void fenster3d::draw_asteroid(int type)
{
 glColor3f(0.8,0.8,0.8);
 if (object_style==1)
  {
   glEnable(GL_LIGHTING);
   glEnable(GL_COLOR_MATERIAL);
   float d[]={0.1,0.1,0.1,1.0};
   glMaterialfv(GL_FRONT,GL_DIFFUSE,&(d[0]));
   switch (type)
  {
   case 1:
    draw_object(&(asteroid1[0]),&astro1_3d);
    break;
   default:
    draw_object(&(asteroid1[0]),&astro1_3d);
    break;
  };
   glDisable(GL_COLOR_MATERIAL);
   glDisable(GL_LIGHTING);
   return;
  };

 glBegin(GL_LINE_LOOP);
 switch (type)
  {
   case 1:
    for (int i=0;i<16;i++)
     glVertex3f(asteroid1[i].x,asteroid1[i].y,0);
    break;
   case 2:
    for (int i=0;i<16;i++)
     glVertex3f(asteroid2[i].x,asteroid2[i].y,0);
    break;
   case 3:
    for (int i=0;i<16;i++)
     glVertex3f(asteroid3[i].x,asteroid3[i].y,0);
    break;
   case 4:
    for (int i=0;i<16;i++)
     glVertex3f(asteroid4[i].x,asteroid4[i].y,0);
    break;
   default:
    for (float i=0;i<16;i++)
     glVertex2f(sin(2*M_PI/16.0*i),cos(2*M_PI/16.0*i));
  };
 glEnd();
};

void fenster3d::draw_ship()
{

 if (object_style==1)
  {
   glEnable(GL_LIGHTING);
   glEnable(GL_COLOR_MATERIAL);
   glColor3f(1.0,1.0,1.0);
   float d[]={0.1,0.1,0.1,1};
   glMaterialfv(GL_FRONT,GL_DIFFUSE,&(d[0]));
   draw_object(&(schiff2[0]),&schiff3d);
   glDisable(GL_COLOR_MATERIAL);
   glDisable(GL_LIGHTING);
   return;
  };

 glColor3f(1.0,1.0,1.0);
 glBegin(GL_LINE_LOOP);
 for (int i=0;i<5;i++)
    {
     glVertex3f(schiff2[i].x,schiff2[i].y,0);
    };
 glEnd();
};
void fenster3d::draw_ship_thrust()
{

 if (object_style==1)
  {
   glEnable(GL_LIGHTING);
   glEnable(GL_COLOR_MATERIAL);
   glColor3f(1.0,1.0,0.5);
   float d[]={0.8,0.8,0.8,1};
   glMaterialfv(GL_FRONT,GL_AMBIENT,&(d[0]));
   draw_object(&(thrust[0]),&thrust3d);
   float d2[]={0.2,0.2,0.2,1};
   glMaterialfv(GL_FRONT,GL_AMBIENT,&(d[0]));
   glDisable(GL_COLOR_MATERIAL);
   glDisable(GL_LIGHTING);
   return;
  };

 glColor3f(1.0,1.0,0.7);
 glBegin(GL_LINE_LOOP);
 for (int i=0;i<5;i++)
    {
     glVertex3f(thrust[i].x,thrust[i].y,0);
    };
 glEnd();
};

void fenster3d::draw_saucer()
{
 if (object_style==1)
  {
   glEnable(GL_LIGHTING);
   glEnable(GL_COLOR_MATERIAL);
   glColor3f(1.0,1.0,1.0);
   float d[]={0.1,0.1,0.1,0.1};
   glMaterialfv(GL_FRONT,GL_DIFFUSE,&(d[0]));
   draw_object(&(ufo2[0]),&ufo3d);
   glDisable(GL_COLOR_MATERIAL);
   glDisable(GL_LIGHTING);
   return;
  };
 glColor3f(1.0,1.0,1.0);
 glBegin(GL_LINE_STRIP);
 for (int i=0;i<12;i++)
  {
   glVertex3f(ufo2[i].x,ufo2[i].y,0);
  };
 glEnd();
};

void fenster3d::draw_shot()
{
 glEnable(GL_BLEND);
 glDisable(GL_DEPTH_TEST);
 glColor3f(1.0,1.0,0.5);
 glBlendFunc(GL_ONE,GL_ONE);
 glBegin(GL_TRIANGLE_FAN);
 glColor3f(1.0,1.0,0.5);
 glVertex2f(0,0);
 glColor3f(0.0,0.0,0.0);
 for (float i=0;i<17;i++)
  glVertex3f(5*sin(2*M_PI/16.0*i),5*cos(2*M_PI/16.0*i),0);
 glEnd();
 glBegin(GL_TRIANGLE_FAN);
 glColor3f(1.0,1.0,0.5);
 glVertex2f(0,0);
 glColor3f(0.1,0.1,0.1);
 for (float i=0;i<17;i++)
  glVertex2f(2*sin(2*M_PI/16.0*i),2*cos(2*M_PI/16.0*i));
 glEnd();
 glBlendFunc(GL_ONE,GL_ZERO);
 glDisable(GL_BLEND);
 glEnable(GL_DEPTH_TEST);
};

void fenster3d::draw_wireframe()
{
 glLoadIdentity();
 glColor3f(0.0,0.0,0.5);
 glDisable(GL_DEPTH_TEST);
 for (float a=-512;a<1600;a+=64)
  {
   glBegin(GL_LINES);
   glVertex3f(a,-512,0);
   glVertex3f(a,1600,0);
   glVertex3f(-512,a,0);
   glVertex3f(1600,a,0);
   glEnd();
  };
 glBegin(GL_LINE_LOOP);
 glColor3f(0.3,0.3,0.8);
 glVertex3f(0,128,0);
 glVertex3f(1024,128,0);
 glVertex3f(1024,896,0);
 glVertex3f(0,896,0);
 glEnd();
 glEnable(GL_DEPTH_TEST);
};

void fenster3d::set_position(float x,float y,float s_x, float s_y)
{
 if (ansicht3d)
  {
   if ((x-s_x)>512) x-=1024;
   if ((x-s_x)<-512) x+=1024;
   if ((y-s_y)>384) y-=768;
   if ((y-s_y)<-384) y+=768;
  };
 glLoadIdentity();
 glTranslatef(x,y,0);
};

void fenster3d::set_projection(GameStatus& rg)
{
 glMatrixMode( GL_PROJECTION );
 glLoadIdentity();
 if (ansicht3d)
  {
   glFrustum(-512,512,-384,384,1,700);
   glScalef(512.0,512.0,1.0);

   glRotatef(-45,1,0,0);
   glRotatef(90-rg.ship_angle*180/M_PI,0,0,1);
   glTranslatef(-rg.ship_x,-rg.ship_y,0);

   glTranslatef(128.0*cos(rg.ship_angle),128.0*sin(rg.ship_angle),-128.0);
   glEnable(GL_DEPTH_TEST);
  } else
  {
//   glOrtho(0.0,1024,128.0,896.0,-1.0,1.0);
   glFrustum(-512,512,-384,384,1,1024);
   glScalef(512.0,512.0,1.0);
   glTranslatef(-512,-512,-512);
  };

 glMatrixMode( GL_MODELVIEW );
 glLoadIdentity();
 float f[]={0.7,0.7,0.7,1.0};
 glLightfv(GL_LIGHT0,GL_DIFFUSE,&(f[0]));
 glLightfv(GL_LIGHT0,GL_POSITION,&(sun[0]));
 glEnable(GL_LIGHT0);
};

void fenster3d::switch_view()
{
 ansicht3d=(ansicht3d+1)&1;
};

void fenster3d::switch_object_style()
{
 object_style=(object_style+1)&1;
};

void fenster3d::draw_object(vektor *punkte,objekt3d *objekt)
{
 for (int i=0;i<objekt->anzahl;i++)
  {
   glBegin(GL_TRIANGLE_FAN);
   float x1=punkte[objekt->punkte[i].a].x;
   float x2=punkte[objekt->punkte[i].b].x;
   float x3=punkte[objekt->punkte[i].c].x;
   float y1=punkte[objekt->punkte[i].a].y;
   float y2=punkte[objekt->punkte[i].b].y;
   float y3=punkte[objekt->punkte[i].c].y;
   float z1=punkte[objekt->punkte[i].a].z;
   float z2=punkte[objekt->punkte[i].b].z;
   float z3=punkte[objekt->punkte[i].c].z;
   float dx1=-(x2-x1);
   float dy1=-(y2-y1);
   float dz1=-(z2-z1);
   float dx2=(x3-x1);
   float dy2=(y3-y1);
   float dz2=(z3-z1);

   glNormal3f(dy1*dz2-dz1*dy2,dz1*dx2-dx1*dz2,dx1*dy2-dy1*dx2);
   glVertex3f(x1,y1,z1);
   glVertex3f(x2,y2,z2);
   glVertex3f(x3,y3,z3);
   glEnd();
  };
};

void fenster3d::set_shot_light(float x, float y,float s_x,float s_y, int nr)
{
 if (ansicht3d)
  {
   if ((x-s_x)>512) x-=1024;
   if ((x-s_x)<-512) x+=1024;
   if ((y-s_y)>384) y-=768;
   if ((y-s_y)<-384) y+=768;
  };
 glLoadIdentity();
 glTranslatef(x,y,0);
 int licht=GL_LIGHT1;
 switch (nr)
  {
   case 1:
   licht=GL_LIGHT1;
   break;
   case 2:
   licht=GL_LIGHT2;
   break;
   case 3:
   licht=GL_LIGHT3;
   break;
   case 4:
   licht=GL_LIGHT4;
   break;
   case 5:
   licht=GL_LIGHT5;
   break;
   case 6:
   licht=GL_LIGHT6;
   break;
  }
 glEnable(licht);
 float diffuse[]={1.0,1.0,0.4,1.0};
 glLightfv(licht,GL_DIFFUSE,&(diffuse[0]));
 float position[]={0,0,0,1};
 glLightfv(licht,GL_POSITION,&(position[0]));
 glLightf(licht,GL_CONSTANT_ATTENUATION,0);
 glLightf(licht,GL_LINEAR_ATTENUATION,0.03);

};

void fenster3d::draw_stats(GameStatus& rg)
{
 RECT rect;
 GetClientRect(hwnd,&rect);
 glMatrixMode( GL_PROJECTION );
 glLoadIdentity();
 glOrtho(0.0,rect.right,rect.bottom,0,-1.0,1.0);
 glMatrixMode( GL_MODELVIEW );
 glLoadIdentity();
 glDisable(GL_DEPTH_TEST);
 glDisable(GL_LIGHTING);
 glDisable(GL_COLOR_MATERIAL);
 glDisable(GL_BLEND);
 glColor3f(0.8,0.8,0.8);
 char *text="                                    ";
 sprintf(text,"Punkte: %i",rg.score);
 glRasterPos2f(0,25);
 glCallLists(strlen(text),GL_UNSIGNED_BYTE,text);
 sprintf(text,"Schiffe: %i",rg.life);
 glRasterPos2f(0,50);
 glCallLists(strlen(text),GL_UNSIGNED_BYTE,text);
 unsigned long sekunden=(timeGetTime()-rg.startzeit)/1000;
 unsigned long minuten=sekunden/60;
 sekunden=sekunden%60;
 sprintf(text,"Zeit: %i:%02i",minuten,sekunden);
 glRasterPos2f(0,75);
 glCallLists(strlen(text),GL_UNSIGNED_BYTE,text);
 sprintf(text,"Level: %i",rg.level);
 glRasterPos2f(0,100);
 glCallLists(strlen(text),GL_UNSIGNED_BYTE,text);
};

void fenster3d::draw_help()
{
 RECT rect;
 GetClientRect(hwnd,&rect);
 rect.left+=64;
 rect.right-=64;
 rect.bottom-=64;
 rect.top+=64;
 glEnable(GL_BLEND);
 glBlendFunc(GL_ZERO,GL_SRC_COLOR);
 glColor3f(0.6,0.6,0.6);
 glBegin(GL_TRIANGLE_FAN);
 glVertex2f(rect.left,rect.top);
 glVertex2f(rect.right,rect.top);
 glVertex2f(rect.right,rect.bottom);
 glVertex2f(rect.left,rect.bottom);
 glEnd();
 glDisable(GL_BLEND);
 glColor3f(0.6,0.6,0.6);
 glBegin(GL_LINE_LOOP);
 glVertex2f(rect.left,rect.top);
 glVertex2f(rect.right,rect.top);
 glVertex2f(rect.right,rect.bottom);
 glVertex2f(rect.left,rect.bottom);
 glEnd();
 glColor3f(1,1,1);
 rect.left+=16;
 rect.top+=30;
 char *text="Folgende Tasten knnen benutzt werden:";
 glRasterPos2f(rect.left,rect.top);
 glCallLists(strlen(text),GL_UNSIGNED_BYTE,text);
 rect.top+=50;
 text="Q         : nach Links drehen";
 glRasterPos2f(rect.left,rect.top);
 glCallLists(strlen(text),GL_UNSIGNED_BYTE,text);
 rect.top+=25;
 text="W         : nach Rechts drehen";
 glRasterPos2f(rect.left,rect.top);
 glCallLists(strlen(text),GL_UNSIGNED_BYTE,text);
 rect.top+=25;
 text="I         : beschleunigen";
 glRasterPos2f(rect.left,rect.top);
 glCallLists(strlen(text),GL_UNSIGNED_BYTE,text);
 rect.top+=25;
 text="P         : feuern";
 glRasterPos2f(rect.left,rect.top);
 glCallLists(strlen(text),GL_UNSIGNED_BYTE,text);
 rect.top+=25;
 text="Leertaste : Hypersprung";
 glRasterPos2f(rect.left,rect.top);
 glCallLists(strlen(text),GL_UNSIGNED_BYTE,text);
 rect.top+=50;
 text="A : Autopilot an/aus";
 glRasterPos2f(rect.left,rect.top);
 glCallLists(strlen(text),GL_UNSIGNED_BYTE,text);
 rect.top+=25;
 text="0 : Karte/3rd-person";
 glRasterPos2f(rect.left,rect.top);
 glCallLists(strlen(text),GL_UNSIGNED_BYTE,text);
 rect.top+=25;
 text="9 : einfache/komplexe Objekte";
 glRasterPos2f(rect.left,rect.top);
 glCallLists(strlen(text),GL_UNSIGNED_BYTE,text);
 rect.top+=25;
 text="8 : Gitterlinien an/aus";
 glRasterPos2f(rect.left,rect.top);
 glCallLists(strlen(text),GL_UNSIGNED_BYTE,text);
 rect.top+=25;
 text="7 : Sterne an/aus";
 glRasterPos2f(rect.left,rect.top);
 glCallLists(strlen(text),GL_UNSIGNED_BYTE,text);
 rect.top+=25;
 text="6 : Richtungsvektoren an/aus";
 glRasterPos2f(rect.left,rect.top);
 glCallLists(strlen(text),GL_UNSIGNED_BYTE,text);

};

void fenster3d::draw_velocity(float vx,float vy)
{
 float farbe[4];
 float zwischen[4];
 glGetFloatv(GL_CURRENT_COLOR,&(farbe[0]));
 glGetFloatv(GL_CURRENT_COLOR,&(zwischen[0]));
 zwischen[3]=1.0;
 glEnable(GL_BLEND);
 glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
 glBegin(GL_LINES);
 glColor4fv(&(zwischen[0]));
 glVertex3f(0,0,0);
 zwischen[3]=0.0;
 glColor4fv(&(zwischen[0]));
 glVertex3f(vx*30.0,vy*30.0,0);
 glEnd();
 glColor4fv(&(farbe[0]));
 glDisable(GL_BLEND);
};

void fenster3d::set_thrust_light(GameStatus& rg)
{
 set_position(rg.ship_x,rg.ship_y,rg.ship_x,rg.ship_y);
 glScalef(12.5,12.5,12.5);
 glRotatef((rg.ship_angle*180/M_PI)-90.0,0,0,1.0);
 if (object_style) glRotatef((rg.ship_rot*180/M_PI_2),0,1,0);
 glRotatef(M_PI,0,1,0);
 glEnable(GL_LIGHT7);
 float diffuse[]={1.0,1.0,0.4,1.0};
 glLightfv(GL_LIGHT7,GL_DIFFUSE,&(diffuse[0]));
 float position[]={0,-1.5,0,1};
 glLightfv(GL_LIGHT7,GL_POSITION,&(position[0]));
 glLightf(GL_LIGHT7,GL_CONSTANT_ATTENUATION,0);
 glLightf(GL_LIGHT7,GL_LINEAR_ATTENUATION,0.03);
};

void fenster3d::draw_stars(GameStatus& rg)
{
 glLoadIdentity();
 glColor3f(1.0,1.0,1.0);
 glDisable(GL_DEPTH_TEST);
 glEnable(GL_TEXTURE_2D);
 glTexEnvi(GL_TEXTURE_ENV,GL_TEXTURE_ENV_MODE,GL_MODULATE);
 glBindTexture(GL_TEXTURE_2D,star_texture[0]);
 if (ansicht3d)
  {
   glBegin(GL_TRIANGLE_FAN);
   glTexCoord2f(0,0);
   glVertex3f(rg.ship_x-256,rg.ship_y-256,-128);
   glTexCoord2f(1.0,0);
   glVertex3f(rg.ship_x+256,rg.ship_y-256,-128);
   glTexCoord2f(1.0,1.0);
   glVertex3f(rg.ship_x+256,rg.ship_y+256,-128);
   glTexCoord2f(0,1.0);
   glVertex3f(rg.ship_x-256,rg.ship_y+256,-128);
   glEnd();
   glBindTexture(GL_TEXTURE_2D,star_texture[1]);
   glBegin(GL_TRIANGLE_FAN);
   glTexCoord2f(0,0);
   glVertex3f(rg.ship_x-256,rg.ship_y-256,-128);
   glTexCoord2f(1.0,0);
   glVertex3f(rg.ship_x+256,rg.ship_y-256,-128);
   glTexCoord2f(1.0,1.0);
   glVertex3f(rg.ship_x+256,rg.ship_y-256,128);
   glTexCoord2f(0,1.0);
   glVertex3f(rg.ship_x-256,rg.ship_y-256,128);
   glEnd();
   glBindTexture(GL_TEXTURE_2D,star_texture[2]);
   glBegin(GL_TRIANGLE_FAN);
   glTexCoord2f(0,0);
   glVertex3f(rg.ship_x-256,rg.ship_y+256,-128);
   glTexCoord2f(1.0,0);
   glVertex3f(rg.ship_x+256,rg.ship_y+256,-128);
   glTexCoord2f(1.0,1.0);
   glVertex3f(rg.ship_x+256,rg.ship_y+256,128);
   glTexCoord2f(0,1.0);
   glVertex3f(rg.ship_x-256,rg.ship_y+256,128);
   glEnd();
   glBindTexture(GL_TEXTURE_2D,star_texture[3]);
   glBegin(GL_TRIANGLE_FAN);
   glTexCoord2f(0,0);
   glVertex3f(rg.ship_x-256,rg.ship_y-256,-128);
   glTexCoord2f(1.0,0);
   glVertex3f(rg.ship_x-256,rg.ship_y+256,-128);
   glTexCoord2f(1.0,1.0);
   glVertex3f(rg.ship_x-256,rg.ship_y+256,128);
   glTexCoord2f(0,1.0);
   glVertex3f(rg.ship_x-256,rg.ship_y-256,128);
   glEnd();
   glBindTexture(GL_TEXTURE_2D,star_texture[4]);
   glBegin(GL_TRIANGLE_FAN);
   glTexCoord2f(0,0);
   glVertex3f(rg.ship_x+256,rg.ship_y-256,-128);
   glTexCoord2f(1.0,0);
   glVertex3f(rg.ship_x+256,rg.ship_y+256,-128);
   glTexCoord2f(1.0,1.0);
   glVertex3f(rg.ship_x+256,rg.ship_y+256,128);
   glTexCoord2f(0,1.0);
   glVertex3f(rg.ship_x+256,rg.ship_y-256,128);
   glEnd();


   glDisable(GL_TEXTURE_2D);
   glEnable(GL_DEPTH_TEST);
   return;
  };

 glBegin(GL_TRIANGLE_FAN);
 glTexCoord2f(0,0);
 glVertex3f(0,0,0);
 glTexCoord2f(1.0,0);
 glVertex3f(1024,0,0);
 glTexCoord2f(1.0,1.0);
 glVertex3f(1024,1024,0);
 glTexCoord2f(0,1.0);
 glVertex3f(0,1024,0);
 glEnd();
 glDisable(GL_TEXTURE_2D);
 glEnable(GL_DEPTH_TEST);
};
