

const int MaxLocations = 256;
class Object
{
public:
	char Status;//Negativ: Objekt explodiert gerade.
				//0: Objekt nicht vorhanden.
				//Positiv: Je nach Objekttyp. Bei...
				//                            Asteroiden: Gre (1=klein, 2=mittel, 4=gro) Auerdem ist in den Bits 3 und 4 der Anzeigetyp gespeichert. Im 7. Bit speichere ich auerdem, ob wir den Anzeigetyp genau kennen.
				//                            Spieler: immer 1
				//							  UFO: 2 (gro) oder 1 (klein)
				//                            Schsse: ein herunterlaufender Timer. Wird alle 4 Frames dekrementiert.
	union
	{
		word PositionX;
		word PX[MaxLocations];
	};
	union
	{
		char VelocityX;
		char VX[MaxLocations];
	};
	int cX;
	union
	{
		word PositionY;
		word PY[MaxLocations];
	};
	union
	{
		char VelocityY;
		char VY[MaxLocations];
	};
	int cY;
public:
	Object()
	{
	}

	Object(char Status)
	{
		this->Status = Status;
		cX = cY = 0;
	}

	void SetVelocity(char X, char Y)
	{
		for(int i = 0; i < cX; i++)
			VX[i] = X;
		for(int i = 0; i < cY; i++)
			VY[i] = Y;
		RemoveEqualities();
	}

	bool SetVRamLocation(int x, int y, bool& VRamInvalid)
	{
		assert(!VRamInvalid);
		//printf("vg: %x %x  cx: %i cy: %i\n", x*8, (y-128)*8, cX, cY);
/*		if(VRamCounter == 1)
		{
			for(int i = 0; i < 8; i++)
			{
				PX[i] = x*8+i;
				PY[i] = (y-128)*8+i;
			}
			cX = cY = 8;
		}
		else if(VRamCounter == 2)
		{
			assert(cX == 8 && cY == 8);
			for(int i = 0; i < 8; i++)
			{
				PX[i+8] = x*8+i;
				PY[i+8] = (y-128)*8+i;
			}
			cX = cY = 16;
		}
		else if(VRamCounter == 3)
		{
			assert(cX == 16 && cY == 16);

			word P1[8];
			memcpy(P1, PX, sizeof(word)*8);
			word P2[8];
			memcpy(P2, PX+8, sizeof(word)*8);
			word P3[8];
			for(int i = 0; i < 8; i++)
				P3[i] = x*8+i;
			cX = 0;
			char NewVX = -128;
			do
			{
				for(int i = 0; i < 8; i++)
				{
					if(IsSet(MoveLinearX(P1[i], NewVX, 1), P2) && IsSet(MoveLinearX(P1[i], NewVX, 2), P3))
					{
						assert(cX < MaxLocations);
						PX[cX] = P1[i];
						VX[cX++] = NewVX;
					}
				}
			}while(++NewVX != -128);

			memcpy(P1, PY, sizeof(word)*8);
			memcpy(P2, PY+8, sizeof(word)*8);
			for(int i = 0; i < 8; i++)
				P3[i] = (y-128)*8+i;
			cY = 0;
			char NewVY = -128;
			do
			{
				for(int i = 0; i < 8; i++)
				{
					if(IsSet(MoveLinearY(P1[i], NewVY, 1), P2) && IsSet(MoveLinearY(P1[i], NewVY, 2), P3))
					{
						assert(cY < MaxLocations);
						PY[cY] = P1[i];
						VY[cY++] = NewVY;
					}
				}
			}while(++NewVY != -128);

			VRamAssert(cX && cY, VRamInvalid);
			MoveLinear(2);
		}
		else if(VRamCounter == 0)*/
		{
			//for(int i = 0; i < cX; i++)
			//	printf("%x oder ", PX[i]);
			for(int i = 0; i < cX;)
			{
				if(PX[i]/8 != x)
					RemoveX(i);
				else
					i++;
			}
			for(int i = 0; i < cY;)
			{
				if(PY[i]/8 != y-128)
					RemoveY(i);
				else
					i++;
			}
			VRamAssert(cX && cY, VRamInvalid);
		}
/*		else
			assert(0);*/
		return false;
	}

	void AddLocation(word PositionX, word PositionY, char VelocityX, char VelocityY)
	{
		AddLocationX(PositionX, VelocityX);
		AddLocationY(PositionY, VelocityY);
	}

	void AddLocationX(word PositionX, char VelocityX)
	{
		for(int i = 0; i < cX; i++)
		{
			if(PositionX == PX[i] && VelocityX == VX[i])
				return;
		}
		assert(cX != MaxLocations);
		if(cX == MaxLocations)
			return;
		PX[cX] = PositionX;
		VX[cX] = VelocityX;
		cX++;
	}

	void AddLocationY(word PositionY, char VelocityY)
	{
		for(int i = 0; i < cY; i++)
		{
			if(PositionY == PY[i] && VelocityY == VY[i])
				return;
		}
		assert(cY != MaxLocations);
		if(cY == MaxLocations)
			return;
		PY[cY] = PositionY;
		VY[cY] = VelocityY;
		cY++;
	}

	void SetVelocityY(char VelocityY)
	{
		for(int i = 0; i < cY; i++)
			VY[i] = VelocityY;
		RemoveEqualities();
	}

	void Decide(int IndexX, int IndexY)
	{
		PositionX = PX[IndexX];
		VelocityX = VX[IndexX];
		PositionY = PY[IndexY];
		VelocityY = VY[IndexY];
		cX = cY = 1;
	}

	bool IsFixed() const
	{
		return cX == 1 && cY == 1;
	}

	void SetFixed()
	{
		cX = cY = 1;
	}

	void SetEmpty()
	{
		cX = cY = 0;
	}

	bool IsValid() const
	{
		return cX && cY;
	}

	void MoveLinear(int Steps)
	{
		for(int i = 0; i < cX; i++)
			PX[i] = MoveLinearX(PX[i], VX[i], Steps);
		for(int i = 0; i < cY; i++)
			PY[i] = MoveLinearY(PY[i], VY[i], Steps);
	}

	void ValidatePosition(word PositionX, word PositionY, char VelocityX, char VelocityY) const
	{
		for(int i = 0; i < cX; i++)
		{
			if(PositionX == PX[i] && VelocityX == VX[i])
			{
				for(int i = 0; i < cY; i++)
					if(PositionY == PY[i] && VelocityY == VY[i])
						return;
				assert(0, RamInvalidException());
			}
		}
		assert(0, RamInvalidException());
	}

	void RemoveEqualities()
	{
		for(int i = 0; i < cX; i++)
			for(int j = i+1; j < cX;)
				if(PX[i] == PX[j] && VX[i] == VX[j])
					RemoveX(j);
				else
					j++;

		for(int i = 0; i < cY; i++)
			for(int j = i+1; j < cY;)
				if(PY[i] == PY[j] && VY[i] == VY[j])
					RemoveY(j);
				else
					j++;
	}

	void RemoveX(int Index)
	{
		assert(cX && Index < cX);
		cX--;
		memcpy(PX+Index, PX+Index+1, (cX-Index)*sizeof(word));
		memcpy(VX+Index, VX+Index+1, (cX-Index)*sizeof(char));
	}

	void RemoveY(int Index)
	{
		assert(cY && Index < cY);
		cY--;
		memcpy(PY+Index, PY+Index+1, (cY-Index)*sizeof(word));
		memcpy(VY+Index, VY+Index+1, (cY-Index)*sizeof(char));
	}

	int ExplosionLifetime() const
	{
		assert(Status < 0);
		char NewStatus = Status;
		int Time = 0;
		while(NewStatus < 0)
		{
			NewStatus += (-NewStatus >> 4) + 1;
			Time++;
		}
		return Time;
	}

private:
	static bool IsSet(word Item, const word* Array)
	{
		for(int i = 0; i < 8; i++)
			if(Array[i] == Item)
				return true;
		return false;
	}
};
