// player.cpp: Beispielspieler fr Asteroids
// Harald Bgeholz / c't

#include "stdafx.h"

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <math.h>


#if defined(WINDOWS)
#include <winsock2.h>
#else
// 2 Includes fr socket()
#include <sys/types.h>
#include <sys/socket.h>
// 2 Includes fr inet_addr()
#include <netinet/in.h>
#include <arpa/inet.h>
// 2 Includes fr fcntl()
#include <unistd.h>
#include <fcntl.h>
// fr memset()
#define INVALID_SOCKET -1
#define WSAGetLastError() errno
#endif

#include "global.h"
#include "player.h"

#include <time.h>
#include <stdio.h>

struct tm *newtime;
time_t aclock;





void Player::Run(void)
{

//	for (;;)
	{
		++ticker;         // Zeit
    
    bool lastFrameFired = keys.getFire(); // Zustand merken
		keys.clear();   // alle Tasten loslassen


    static int once = 0;
    if (once == 0) {
      keys.start(true);
      if (game->ship_present) {
        once++;
      }
      return;
    }


/** thrust test 
    if (game->ship_present)
    {
      if (once < 43) {
    //    keys.left(true);
      }
      if (once >= 51 && once <= 66) {
        keys.thrust(true);
      }
      once++;

    }
		SendPacket(keys);
    return;
**/    

/** shoot out 
    if (game->ship_present)
    {
      once++;
      if (once > 15) {
        keys.left(true);
      }
      if (once % 10 == 0) {
        keys.fire(true);
      }
    }
		SendPacket(keys);
    return;
**/    
/** random rotate winkelbyte tracking
    if (game->ship_present)
    {
      once++;
      if (double(rand()) / RAND_MAX > 0.5) {
        if (double(rand()) / RAND_MAX > 0.5) {
          keys.left(true);
        } else {
          keys.right(true);
        }
      }
    }
		SendPacket(keys);
    return;
**/    
 /**
    if (game->ship_present)
    {
      once++;

      if (once < 10) {
        keys.thrust(true);
      }
      if (once == 11) {
        keys.left(true);
      } 
      if (once == 12) {
        keys.fire(true);
      }
    }
		SendPacket(keys);
    return;


**/

    // delay in first level to set Winkelbyte
    if (game->ship_present)
    {
      once++;

      if (once < 12) {
        keys.left(true);
        return;
      }
    }


		int min_dist = 0x7fffffff;
		int min_dx = 0;
		int min_dy = 0;
    int future = 0; // anzahl der frames fr vorausberechnung
    int sdist = 0;
    int sdx = 0;
    int sdy = 0;
    int ret;
    bool toFire; 

		if (game->ship_present)
		{
      int nextAsteroid;
      future = 0;

      if (game->nasteroids == 0 && !game->saucer_present) {  // Pause
        bool thrust=false;
        // bringt nix
/**
        ret = moveToStartPosition(thrust);
        keys.thrust(thrust);
        if (ret == +1) {
          keys.left(true);
        }
        if (ret == -1) {
          keys.right(true);
        }

        ret = rotateToStartPosition(thrust);
        if (ret == +1) {
          keys.left(true);
        }
        if (ret == -1) {
          keys.right(true);
        }
**/        
      }

// In Spielpause bewegen durch Hyperspace
/**
      if ( game->nasteroids == 0
        && !game->saucer_present
        && game->nLevelFrames == 1
        && game->shipCount > 2) {
        keys.hyperspace(true);
      }
**/

      /// Vor Erscheinen der Asteroiden links ran fahren
      if (game->nasteroids == 0 && !game->saucer_present && game->nLevelFrames < 144) {
        // Navigieren
        static int thrustCountX = 0;
        static int thrustCountY = 0;
        if (game->ship.nextWinkelbyte < 125
          && game->ship.x > 160
          && game->ship.x < 800 ) {  // drehen vor thrust
          keys.left(true);
        } else if (game->ship.nextWinkelbyte > 131
          && game->ship.x > 160
          && game->ship.x < 800 ) { // drehen vor thrust
          keys.right(true);
        } else if (game->ship.x > 160 
          && game->ship.x < 800 
          && thrustCountX == 0
          && game->ship.dx8 == 0) {// notwendigen schub berechnen
          thrustCountX = (game->ship.x - 160) >> 4;
          thrustCountX = (thrustCountX * 15) >> 4; // etwas korrigieren
        } else if (thrustCountX > 0) { // schub durchfhren
          thrustCountX--;
          keys.thrust(true);
        } else if (game->ship.nextWinkelbyte > 64
           && game->ship.x <= 160) { // zuletzt schiffsausrichtung setzen
          keys.right(true);
        } else if (game->ship.nextWinkelbyte < 60
          && game->ship.x <= 160) { // zuletzt schiffsausrichtung setzen
          keys.left(true);
        } else if (game->ship.nextWinkelbyte >= 60
           && game->ship.x <= 160
           && game->ship.y <= 550
           && thrustCountY == 0
           && game->ship.dy8 == 0) { // langsam nach oben driften
          thrustCountY = 4;
        } else if (thrustCountY > 0) { // schub durchfhren
          thrustCountY--;
          keys.thrust(true);
        } else if (game->ship.nextWinkelbyte < 210
          && game->ship.x >= 800) { // am rechten rand nur drehen
          keys.left(true);
        }
      }


      /// Vor Erscheinen der Asteroiden schon mal losballern
      if (game->nasteroids == 0 && !game->saucer_present && game->nLevelFrames >= 144) {
        // Ballern
        if (game->nLevelFrames == 144) { keys.fire(true); }
        if (game->nLevelFrames == 150) { keys.fire(true); }
        if (game->nLevelFrames == 156) { keys.fire(true); }
        keys.left(true);
      }


      // Emergency Exit
      if (getEmergencyStatus()) {
        keys.hyperspace(true);
        return;
      }


   // irgendein objekt auf kollisionskurs? 
      future = 1;
      ret = detectCollision(min_dist,min_dx,min_dy,future,toFire,lastFrameFired);
      fprintf(fo,"detectCollision: ret=%2d fire=%d\n",ret,toFire); 
      
      if (ret != -2) {
        if (ret != 0 || toFire) {
          if (ret == +1) {
            keys.left(true);
          }
          if (toFire && !lastFrameFired) {
            keys.fire(true);
          }
          if (ret == -1) {
            keys.right(true);
          }
          if (!toFire) { // schnell noch einen Asteroiden abschiessen
            ret = fireNowAt(min_dist,min_dx,min_dy,future,toFire,lastFrameFired);
            fprintf(fo,"fireNowAt: ret=%d  fire=%d  lf=%d\n",ret,toFire,lastFrameFired);
            if (ret != -2) {
              if (toFire && !lastFrameFired) {
                keys.fire(true);
              }
            }
          }
          return; // wait
        }
      }

 
      ret = fireAtUFO(min_dist,min_dx,min_dy,future,toFire,lastFrameFired);

      if (ret != -2) {      
        if (ret == +1) {
          keys.left(true);
        }
        if (toFire && !lastFrameFired) {
          keys.fire(true);
        }
        if (ret == -1) {
          keys.right(true);
        }
        if (!toFire) { // schnell noch einen Asteroiden abschiessen
          ret = fireNowAt(min_dist,min_dx,min_dy,future,toFire,lastFrameFired);
          fprintf(fo,"fireNowAt: ret=%d  fire=%d  lf=%d\n",ret,toFire,lastFrameFired);
          if (ret != -2) {
            if (toFire && !lastFrameFired) {
              keys.fire(true);
            }
          }
        }
        return; // wait
      }


      if (game->nFrames > 17825 && game->nasteroids == 1) {
        // warten aufs UFO
        return;
      }

      
      if (endspiel()) {
        ret = selectAsteroid(toFire,lastFrameFired);
        fprintf(fo,"selectAsteroid ret: %d\n",ret);
        if (toFire && !lastFrameFired) {
          keys.fire(true);
          return;
        }

        ret = fireAtAsteroid(min_dist, min_dx, min_dy, future, toFire, ret,lastFrameFired);
        fprintf(fo,"endspiel: %d  %d  %d  %d %d\n",ret,min_dist,min_dx,toFire,lastFrameFired);
        
        if (ret != -2) {
        if (ret == +1) {
          keys.left(true);
        }
        if (toFire && !lastFrameFired) {
          keys.fire(true);
        }
        if (ret == -1) {
          keys.right(true);
        }
        return;
        }
        
      }
      

      // Ziel suchen
      ret = fireAt(min_dist,min_dx,min_dy,future,toFire,lastFrameFired);
      fprintf(fo,"fireAt: ret=%d  %d  %d  fire=%d lf=%d\n",ret,min_dist,min_dx,toFire,lastFrameFired);
      
      if (ret == +1) {
				keys.left(true);
      }
      if (toFire && !lastFrameFired) {
				keys.fire(true);
      }
      if (ret == -1) {
				keys.right(true);
      }
      if (!toFire) { // schnell noch einen Asteroiden abschiessen
        ret = fireNowAt(min_dist,min_dx,min_dy,future,toFire,lastFrameFired);
        fprintf(fo,"fireNowAt: ret=%d  fire=%d  lf=%d\n",ret,toFire,lastFrameFired);
        if (ret != -2) {
          if (toFire && !lastFrameFired) {
            keys.fire(true);
          }
        }
      }

      return;

//// ENDE

      {
        nextAsteroid = getNextAsteroid(min_dist,min_dx,min_dy,future);
        
        if (game->saucer_present)
        {
          int dx = game->saucer.x - game->ship.x;
          while (dx < -512) dx += 1024;
          while (dx > 511) dx -= 1024;
          int dy = game->saucer.y - game->ship.y;
          while (dy < -384) dy += 768;
          while (dy > 383) dy -= 768;
          int dist = dx*dx+dy*dy;
          switch (game->saucer.sf)
          {	// Abstand um den ungefhren Radius des UFOs korrigieren
          case 15: // groes UFO
            dist -= 20*20;
            break;
          case 14: // kleines UFO
            dist -= 10*10;
            break;
          }
          sdist = dist;
          sdx = dx;
          sdy = dy;
          if (dist < min_dist)
          {
            min_dist = dist;
            min_dx = dx;
            min_dy = dy;
          }
        }
        future++;
      }

			// Schiff in Richtung auf das nchstgelegene Objekt drehen
			// mathematisch wird hier das Kreuzprodukt aus den Vektoren 
			// ship_dx/y/0 und min_dx/y/0 berechnet
			if (game->ship.bx * min_dy - game->ship.by * min_dx > 0)
				keys.left(true);
			else
				keys.right(true);

      fprintf(fo,"next: n=%d d=%d f=%d\n",nextAsteroid,min_dist,future);

			if (min_dist < 46*46 )  // 45*45 Flucht, wenn Kollision unausweichlich
				keys.hyperspace(true);

			if (min_dist > 800*800) // beschleunigen, wenn nichts in der Nhe
				keys.thrust(true);

			if (ticker % 2 == 0)  // Feuerknopf drcken, so schnell es geht
				keys.fire(true);
		}
	}
}





void Player::InterpretScreen(FramePacket &packet, GameStatus **gameptr)
{
	unsigned short *vector_ram = (unsigned short *)packet.vectorram;
	int dx, dy, sf, vx, vy, vz, vs;
	int v1x = 0;
	int v1y = 0;
	int shipdetect     = 0;
  int scoredetect    = 0;
  int nowLostPackets = 0;

  oldgame = game;  // letzten gamezeiger retten

 	if (packet.frameno != oldgame->frameno + 1) {
    nowLostPackets = (packet.frameno - oldgame->frameno - 1);
    if (nowLostPackets < 0) {
      nowLostPackets += 256;
    }
  }

  game  = &gameHistory[packet.frameno];
	game->clear();
  game->copy(oldgame);

  // wenn nicht JMPL, dann message MAME Format Version 2
  if ((unsigned char)packet.vectorram[1] != 0xe0 && (unsigned char)packet.vectorram[1] != 0xe2) {
    strncpy(game->message,packet.vectorram,20);
    return;
  }

  game->nFrames        = game->nFrames + nowLostPackets + 1;
  game->nLevelFrames   = game->nLevelFrames + nowLostPackets + 1;
  game->nowLostPackets = nowLostPackets;
  game->sumLostPackets = game->sumLostPackets + nowLostPackets;
  game->frameno        = packet.frameno;
  game->readping       = packet.ping;
  game->jmpl           = (unsigned char)packet.vectorram[1];


	int pc = 1;
	for (;;)
	{
		int op = vector_ram[pc] >> 12;
		switch (op)
		{
		case 0xa: // LABS
			vy = vector_ram[pc] & 0x3ff;
			vx = vector_ram[pc+1] & 0x3ff;
			vs = vector_ram[pc+1] >> 12;
      if (vx == 100 && vy == 876) {
        scoredetect = 5;
      }
			break;
		case 0xb: // HALT
			return;
		case 0xc: // JSRL
			switch (vector_ram[pc] & 0xfff)
			{
			case 0x8f3:
				game->addAsteroid(vx, vy, 1, vs);
				break;
			case 0x8ff:
				game->addAsteroid(vx, vy, 2, vs);
				break;
			case 0x90d:
				game->addAsteroid(vx, vy, 3, vs);
				break;
			case 0x91a:
				game->addAsteroid(vx, vy, 4, vs);
				break;

			case 0x929:
				game->setSaucer(vx,vy,vs);
				break;

      case 0xA6D: // 	Raumschiff aufrecht
        game->shipCount++;
				break;

      case 0xADD: // 0 oder O
        if (scoredetect > 0) {
          game->score = game->score*10;
          scoredetect--;
        }
				break;
      case 0xB2C: // blank
        scoredetect--;
				break;
      case 0xB2E: //	1
        if (scoredetect > 0) {
          game->score = game->score*10 + 1;
          scoredetect--;
        }
				break;
 	    case 0xB32: // 	2
        if (scoredetect > 0) {
          game->score = game->score*10 + 2;
          scoredetect--;
        }
				break;
 	    case 0xB3A: // 	3
        if (scoredetect > 0) {
          game->score = game->score*10 + 3;
          scoredetect--;
        }
				break;
 	    case 0xB41: // 	4
        if (scoredetect > 0) {
          game->score = game->score*10 + 4;
          scoredetect--;
        }
				break;
	    case 0xB48: // 	5
        if (scoredetect > 0) {
          game->score = game->score*10 + 5;
          scoredetect--;
        }
				break;
	    case 0xB4F: // 	6
        if (scoredetect > 0) {
          game->score = game->score*10 + 6;
          scoredetect--;
        }
				break;
      case 0xB56: // 	7
        if (scoredetect > 0) {
          game->score = game->score*10 + 7;
          scoredetect--;
        }
				break;
      case 0xB5B: // 	8
        if (scoredetect > 0) {
          game->score = game->score*10 + 8;
          scoredetect--;
        }
				break;
      case 0xB63: // 9	
        if (scoredetect > 0) {
          game->score = game->score*10 + 9;
          scoredetect--;
        }
				break;
			}  
			break;
		case 0xd: // RTSL
			return;
		case 0xe: // JMPL
			/*
			pc = vector_ram[pc] & 0xfff;
			break;
			*/
			return;
		case 0xf: // SVEC
			/*
			dy = vector_ram[pc] & 0x300;
			if ((vector_ram[pc] & 0x400) != 0)
				dy = -dy;
			dx = (vector_ram[pc] & 3) << 8;
			if ((vector_ram[pc] & 4) != 0)
				dx = -dx;
			sf = (((vector_ram[pc] & 8) >> 2) | ((vector_ram[pc] & 0x800) >> 11)) + 2;
			vz = (vector_ram[pc] & 0xf0) >> 4;
			*/
			break;
		default:
			dy = vector_ram[pc] & 0x3ff;
			if ((vector_ram[pc] & 0x400) != 0)
				dy = -dy;
			dx = vector_ram[pc+1] & 0x3ff;
			if ((vector_ram[pc+1] & 0x400) != 0)
				dx = -dx;
			sf = op;
			vz = vector_ram[pc+1] >> 12;
      if (dx == 0 && dy == 0 && vz == 15) {
        game->shots[game->nshots++].set(vx, vy);
      }
			if (op == 6 && vz == 12 && dx != 0 && dy != 0)
			{
				switch (shipdetect)
				{
				case 0:
					v1x = dx;
					v1y = dy;
					++shipdetect;
					break;
				case 1:
          game->setShip(vx,vy,v1x - dx,v1y - dy);
					++shipdetect;
					break;
				}
			}
			else if (shipdetect == 1)
				shipdetect = 0;

			break;
		}
		if (op <= 0xa)
			++pc;
		if (op != 0xe) // JMPL
			++pc;
	}   

}


void Player::ReceivePacket(FramePacket &packet, int timeout)
{
//	sockaddr_in sender;
//	int sender_size = sizeof sender;
	fd_set readfds, writefds, exceptfds;

	do
	{
    // erst mal alles zurcksetzen
		FD_ZERO(&readfds);
		FD_ZERO(&writefds);
		FD_ZERO(&exceptfds);

    // wir warten auf read und error fr unseren socket
		FD_SET(sd, &readfds);
    FD_SET(sd, &exceptfds);
    
    timeval five;  
    five.tv_sec = timeout; // n Sekunden warten
    five.tv_usec = 0;
    
    int cntSockets;
    cntSockets = select(sd+1, &readfds, &writefds, &exceptfds, &five);
    if (cntSockets == 0)
    {
      fprintf(stderr, "Timeout bei select().\n");
      exit(3);
    }
    
    //		select(sd+1, &readfds, &writefds, &exceptfds, NULL);
    
    int bytes_received = recv(sd, (char *)&packet, sizeof packet, 0);
    if (bytes_received != sizeof packet)
    {
      if (bytes_received < sizeof packet) {
        packet.vectorram[bytes_received] = '\0';
      } else {
        int err = WSAGetLastError();
        fprintf(stderr, "Fehler %d bei recvfrom().\n", err);
        exit(1);
      }
    }
    // sind bereits mehr pakete angekommen?
    
    FD_ZERO(&readfds);
    FD_ZERO(&writefds);
    FD_ZERO(&exceptfds);
    FD_SET(sd, &readfds);
		timeval zero;
		zero.tv_sec = zero.tv_usec = 0;
		select(sd+1, &readfds, &writefds, &exceptfds, &zero);
	}
  while(FD_ISSET(sd, &readfds));
}


void Player::SendPacket(KeysPacket &packet)
{
  packet.getKeysAsString(keyString); // debug only

	sockaddr_in server;
	memset(&server, 0, sizeof server);
	server.sin_family = AF_INET;
	server.sin_port = htons(1979);
	server.sin_addr.s_addr = server_ip;
  int packetsize = 8;
  packet.ping++; // jedes gesendete Pckchen erhlt eine individuelle Nummer zur Latenzmessung
	if (packetsize != sendto(sd, (char *)&packet, packetsize, 0, (sockaddr*)&server, sizeof server))
	{
#if defined(WINDOWS)
		int err = WSAGetLastError();
		if (err != WSAEWOULDBLOCK)
		{
			fprintf(stderr, "Fehler %d bei sendto().\n", err);
			exit(1);
		}
#else
		if (errno != EAGAIN)
		{
			perror("Fehler bei sendto()");
			exit(1);
		}
#endif
	}
}


void Player::SendPacketName(char *PlayerName)
{
  
  char buffer[38];
  memset(&buffer, 0, sizeof buffer);
  strcpy(buffer,"ctname");
  strcpy(buffer+6,PlayerName);

	sockaddr_in server;
	memset(&server, 0, sizeof server);
	server.sin_family = AF_INET;
	server.sin_port = htons(1979);
	server.sin_addr.s_addr = server_ip;
  int packetsize = 38;
//  packet.ping++; // jedes gesendete Pckchen erhlt eine individuelle Nummer zur Latenzmessung
	if (packetsize != sendto(sd, (char *)&buffer, packetsize, 0, (sockaddr*)&server, sizeof server))
	{
#if defined(WINDOWS)
		int err = WSAGetLastError();
		if (err != WSAEWOULDBLOCK)
		{
			fprintf(stderr, "Fehler %d bei sendto().\n", err);
			exit(1);
		}
#else
		if (errno != EAGAIN)
		{
			perror("Fehler bei sendto() in SendPacketName");
			exit(1);
		}
#endif
	}
}



void Player::Receive(int timeout)
{
		ReceivePacket(frame,timeout);
}


void Player::Send()
{
  
	SendPacket(keys);
  game->sentKeys = keys;
  keyHistory[keys.ping] = keys;
}



// Differenzen zwischen zwei GameStatus ermitteln
void Player::InterpretScreen(void)
{

  InterpretScreen(frame,&game);

  int k;

  if (game->ship_present && game->mode == UNKNOWN) {
    game->mode = PREPARE;
    game->nLevelFrames = 1;
  }

  if (oldgame->nasteroids > 0 && game->nasteroids == 0) {
    game->mode = LEVELDONE;
    game->nLevelFrames = 1;
  }

  if (oldgame->nasteroids == 0 && game->nasteroids > 0) {
    game->mode = INLEVEL;
  }

  if (oldgame->ship_present && game->ship_present) {
      game->ship.dx = normalizeX((game->ship.x - oldgame->ship.x));
      game->ship.dy = normalizeY((game->ship.y - oldgame->ship.y));
  } else {
      game->ship.dx = 0;
      game->ship.dy = 0;
  }

  //////////////////////////////////////////////////////

  if (oldgame->saucer_present && game->saucer_present) {
      game->saucer.dx = normalizeX((game->saucer.x - oldgame->saucer.x));
      game->saucer.dy = normalizeY((game->saucer.y - oldgame->saucer.y));
  } else {
      game->saucer.dx = 0;
      game->saucer.dy = 0;
  }

  game->saucer.setTarget(oldgame->saucer.getTarget());
  game->saucer.setTargetTimeToLive(oldgame->saucer.getTargetTimeToLive());

  //////////////////////////////////////////////////////
  
  // offenbar nichts geaendert oder abgang + zugang
  if (oldgame->nshots == game->nshots) {
    for (k=0;k<game->nshots;k++) {
      game->shots[k].refindex = oldgame->
        findShot(game->shots[k].x,game->shots[k].y,game->nowLostPackets+1);
    }
    for (k=0;k<game->nshots;k++) {
      int ri = game->shots[k].refindex;
      if (ri >= 0) {
        game->shots[k].dx = normalizeX((game->shots[k].x - oldgame->shots[ri].x));
        game->shots[k].dy = normalizeY((game->shots[k].y - oldgame->shots[ri].y));
        game->shots[k].firstFrameSeen = oldgame->shots[ri].firstFrameSeen;
      } else {
        game->shots[k].dx = 0;
        game->shots[k].dy = 0;
        game->shots[k].firstFrameSeen = game->nFrames;
      }
      game->shots[k].lastFrameSeen = game->nFrames;
    }
  }

  // abgang
  if (oldgame->nshots > game->nshots) {
    for (k=0;k<game->nshots;k++) {
      game->shots[k].refindex = oldgame->
        findShot(game->shots[k].x,game->shots[k].y,game->nowLostPackets+1);
    }
    for (k=0;k<game->nshots;k++) {
      int ri = game->shots[k].refindex;
      if (ri >= 0) {
        game->shots[k].dx = normalizeX((game->shots[k].x - oldgame->shots[ri].x));
        game->shots[k].dy = normalizeY((game->shots[k].y - oldgame->shots[ri].y));
        game->shots[k].firstFrameSeen = oldgame->shots[ri].firstFrameSeen;
      }
      game->shots[k].lastFrameSeen = game->nFrames;
    }
  }

  // neuzugang
  if (oldgame->nshots < game->nshots) {
    for (k=0;k<game->nshots;k++) {
      game->shots[k].refindex = oldgame->
        findShot(game->shots[k].x,game->shots[k].y,game->nowLostPackets+1);
    }
    for (k=0;k<game->nshots;k++) {
      int ri = game->shots[k].refindex;
      if (ri >= 0) {
        game->shots[k].dx = normalizeX((game->shots[k].x - oldgame->shots[ri].x));
        game->shots[k].dy = normalizeY((game->shots[k].y - oldgame->shots[ri].y));
        game->shots[k].firstFrameSeen = oldgame->shots[ri].firstFrameSeen;
      } else {
        game->shots[k].dx = 0;
        game->shots[k].dy = 0;
        game->shots[k].firstFrameSeen = game->nFrames;
        game->shots[k].refindex = -1;
      }
      game->shots[k].lastFrameSeen = game->nFrames;
    }
  }

  //////////////////////////////////////////////////////

  // offenbar nichts geaendert 
  if (oldgame->nasteroids == game->nasteroids) {
    for (k=0;k<game->nasteroids;k++) {
      int ri = oldgame->findAsteroid(
             game->asteroids[k].x,game->asteroids[k].y,game->asteroids[k].type,
             game->asteroids[k].sf,game->nowLostPackets+1);
      game->asteroids[k].refindex = ri;
      if (ri >= 0) {
        game->asteroids[k].dx = normalizeX((game->asteroids[k].x - oldgame->asteroids[ri].x));
        game->asteroids[k].dy = normalizeY((game->asteroids[k].y - oldgame->asteroids[ri].y));
        game->asteroids[k].firstFrameSeen = oldgame->asteroids[ri].firstFrameSeen;
        game->asteroids[k].setTarget(oldgame->asteroids[ri].getTarget());
        game->asteroids[k].setTargetTimeToLive(oldgame->asteroids[ri].getTargetTimeToLive());
      }
      game->asteroids[k].lastFrameSeen = game->nFrames;
    }
  }

  // abgang
  if (oldgame->nasteroids > game->nasteroids) {
    for (k=0;k<game->nasteroids;k++) {
      game->asteroids[k].refindex = oldgame->findAsteroid(
        game->asteroids[k].x,game->asteroids[k].y,game->asteroids[k].type,
        game->asteroids[k].sf,game->nowLostPackets+1);
    }
    for (k=0;k<game->nasteroids;k++) {
      int ri = game->asteroids[k].refindex;
      if (ri >= 0) {
        game->asteroids[k].dx = normalizeX((game->asteroids[k].x - oldgame->asteroids[ri].x));
        game->asteroids[k].dy = normalizeY((game->asteroids[k].y - oldgame->asteroids[ri].y));
        game->asteroids[k].firstFrameSeen = oldgame->asteroids[ri].firstFrameSeen;
        game->asteroids[k].setTarget(oldgame->asteroids[ri].getTarget());
        game->asteroids[k].setTargetTimeToLive(oldgame->asteroids[ri].getTargetTimeToLive());
      }
      game->asteroids[k].lastFrameSeen = game->nFrames;
    }
  }

  // neuzugang
  if (oldgame->nasteroids < game->nasteroids) {
    for (k=0;k<game->nasteroids;k++) {
      game->asteroids[k].refindex = oldgame->findAsteroid(
        game->asteroids[k].x,game->asteroids[k].y,game->asteroids[k].type,
        game->asteroids[k].sf,game->nowLostPackets+1);
    }
    for (k=0;k<game->nasteroids;k++) {
      int ri = game->asteroids[k].refindex;
      if (ri >= 0) {
        game->asteroids[k].dx = normalizeX((game->asteroids[k].x - oldgame->asteroids[ri].x));
        game->asteroids[k].dy = normalizeY((game->asteroids[k].y - oldgame->asteroids[ri].y));
        game->asteroids[k].firstFrameSeen = oldgame->asteroids[ri].firstFrameSeen;
        game->asteroids[k].setTarget(oldgame->asteroids[ri].getTarget());
        game->asteroids[k].setTargetTimeToLive(oldgame->asteroids[ri].getTargetTimeToLive());
      } else {
        game->asteroids[k].dx = 0;
        game->asteroids[k].dy = 0;
        game->asteroids[k].firstFrameSeen = game->nFrames;
        game->asteroids[k].refindex = -1;
        game->asteroids[k].setTarget(0);
        game->asteroids[k].setTargetTimeToLive(0);
      }
      game->asteroids[k].lastFrameSeen = game->nFrames;
    }
  }

  // relative Positionen berechnen
  for (k=0;k<game->nshots;k++) {
    game->shots[k].calcRelativePos(game->ship.x,game->ship.y);
  }

  // Lebenszeit der Schsse abrechnen
  for (k=0;k<game->nasteroids;k++) {
    game->asteroids[k].decTargetTimeToLive();
    game->asteroids[k].calcRelativePos(game->ship.x,game->ship.y);
  }
  game->saucer.decTargetTimeToLive();
  game->saucer.calcRelativePos(game->ship.x,game->ship.y);

  int dw = calcDrehwinkel(); 
  game->ship.adjustWinkelbyte(dw,
    keyHistory[oldgame->readping].drehung(),game->nowLostPackets);

  game->ship.dx8 = calcShipDirX8();
  game->ship.dy8 = calcShipDirY8();

  game->saucer.dx8 = calcSaucerDirX8();
  game->saucer.dy8 = calcSaucerDirY8();

  for (k=0;k<game->nshots;k++) {
    game->shots[k].dx8 = calcShotDirX8(k);
    game->shots[k].dy8 = calcShotDirY8(k);
  }
  for (k=0;k<game->nasteroids;k++) {
    game->asteroids[k].dx8 = calcAstDirX8(k);
    game->asteroids[k].dy8 = calcAstDirY8(k);
    game->asteroids[k].distanz = 
      abstandPunktPunkt(game->ship.x,game->ship.y,game->asteroids[k].x,game->asteroids[k].y);
    game->asteroids[k].kursdistanz = 
      abstandPunktGerade(game->ship.x,game->ship.y,
      game->asteroids[k].x,game->asteroids[k].y,game->asteroids[k].dx8,game->asteroids[k].dy8);
  }

  // Vorhersage newgame
  calcNewGame();
  // todo
}



Asteroid::Asteroid() {
  firstFrameSeen = 0;
  lastFrameSeen  = 0;
  refindex = -1;
}


void Asteroid::set(int x, int y, int type, int sf)
{
	this->x = x;
	this->y = y - 128;
	this->type = type;
	this->sf = sf;
  switch (sf) {
  case 14: this->sfc = 'K';
           break;
  case 15: this->sfc = 'M';
           break;
  default:
           this->sfc = 'G';
  }
}


bool Asteroid::maxTargets()
{
  switch (sf)
  {	// Auf grosse asteroiden ruhig mehrmals schiessen, ev.abhngig vom abstand
  case 0:  // groer Asteroid
    if (getTarget() < 4) {
      return false;
    }
    break;
  case 15: // mittlerer Asteroid
    if (getTarget() < 3) {
      return false;
    }
    break;
  case 14: // kleiner Asteroid
    if (getTarget() < 1) {
      return false;
    }
  }
  return true;
}


bool Asteroid::maxTargets(int future)
{
  if (future < 25) {
    switch (sf)
    {	// Auf grosse asteroiden ruhig mehrmals schiessen, ev.abhngig vom abstand
    case 0:  // groer Asteroid
      if (getTarget() < 4) return false;
      break;
    case 15: // mittlerer Asteroid
      if (getTarget() < 3) return false;
      break;
    case 14: // kleiner Asteroid
      if (getTarget() < 1) return false;
    }
  } else {
    switch (sf)
    {	// Auf grosse asteroiden ruhig mehrmals schiessen, ev.abhngig vom abstand
    case 0:  // groer Asteroid
      if (getTarget() < 3) return false;
      break;
    case 15: // mittlerer Asteroid
      if (getTarget() < 2) return false;
      break;
    case 14: // kleiner Asteroid
      if (getTarget() < 1) return false;
    }
  }
  return true;
}



void Shot::set(int x, int y)
{
	this->x = x;
	this->y = y - 128;
}


// Schsse bewegen sich immer.
// quadrat der distanz zum uebergebenen Punkt
// unter der Annahme, dass sich das objekt gleichfrmig
// zwischen zwei Frames bewegt.
int Shot::distance2(int x1, int y1, char frame)
{
	int fd = (lastFrameSeen - frame) & 0x0F; // nur geringe bewegungen betrachten

  int newdx = x1 - (x + fd * dx); 
  int newdy = y1 - (y + fd * dy);

  return (newdx * newdx) + (newdy * newdy);
}



void Shot::setDistance(int x1, int y1, char frame, int idx, Shot shot[])
{
  int fd = shot[idx].lastFrameSeen;
  fd = (fd - frame) & 0x0F; // nur geringe bewegungen betrachten
  
  if ( fd != 0 )
  {
    dx = (x1 - shot[idx].x) ; 
    dy = (y1 - shot[idx].y) ;
  }
  lastFrameSeen = frame;
  refindex = idx;
  
}



GameStatus *Player::getStatus(void)
{
  return game;
}





/////////////// global Frame reader thread ////////////////////////

 FILE *fo = NULL;
 FILE *fs = NULL;


UINT FrameThread(LPVOID pParam)
{
  Player* pPlayer = (Player*)pParam;
 
  LARGE_INTEGER lpFrequency;
  LARGE_INTEGER lpCounter;
  DWORD lastv;

#ifndef NOLOGS
  fo = fopen ("d:\\ast.txt","w");
  if (!fo) { return -1;}

  fs = fopen ("d:\\statistik.txt","a+");
  if (!fs) { return -1;}
#endif

  QueryPerformanceFrequency(&lpFrequency);

  fprintf(fo,"PerformanceFrequency: Hi=%d  Lo=%d\n",
        lpFrequency.HighPart,
        lpFrequency.LowPart);

  /* Funktionstest */
  fprintf(fo,"liegtPunktInKreis %2d,%2d  %2d,%2d,%2d  = %d\n",
        20,30,0,0,1,liegtPunktInKreis(20,30,0,0,1));
  fprintf(fo,"liegtPunktInKreis %2d,%2d  %2d,%2d,%2d  = %d\n",
        2,3,0,0,2,liegtPunktInKreis(2,3,0,0,2));
  fprintf(fo,"liegtPunktInKreis %2d,%2d  %2d,%2d,%2d  = %d\n",
        2,3,0,0,3,liegtPunktInKreis(2,3,0,0,3));
  fprintf(fo,"liegtPunktInKreis %2d,%2d  %2d,%2d,%2d  = %d\n",
        0,3,0,0,3,liegtPunktInKreis(0,3,0,0,3));
  fprintf(fo,"liegtPunktInKreis %2d,%2d  %2d,%2d,%2d  = %d\n",
        2,3,0,0,4,liegtPunktInKreis(2,3,0,0,4));
  fprintf(fo,"liegtPunktInKreis %2d,%2d  %2d,%2d,%2d  = %d\n",
        2,3,0,0,5,liegtPunktInKreis(2,3,0,0,5));
  fprintf(fo,"liegtPunktInKreis %2d,%2d  %2d,%2d,%2d  = %d\n",
        2,3,0,0,9,liegtPunktInKreis(2,3,0,0,9));
  fprintf(fo,"liegtPunktInKreis %2d,%2d  %2d,%2d,%2d  = %d\n",
        2,3,0,0,15,liegtPunktInKreis(2,3,0,0,15));
  fprintf(fo,"liegtPunktInKreis %2d,%2d  %2d,%2d,%2d  = %d\n",
        20,40,19,39,5,liegtPunktInKreis(20,40,19,39,5));
  fprintf(fo,"liegtPunktInKreis %2d,%2d  %2d,%2d,%2d  = %d\n",
        0,0,0,0,5,liegtPunktInKreis(0,0,0,0,5));

  int i,x1,y1,x2,y2;
  
  i = schnittpunktKreisGerade(0,0, 5, 0,0, 5,5,x1,y1,x2,y2);
  fprintf(fo,"schnittpunktKreisGerade %d %3d,%3d %3d,%3d\n",i,x1,y1,x2,y2);
  
  i = schnittpunktKreisGerade(12,13, 6, 0,0, 17,17,x1,y1,x2,y2);
  fprintf(fo,"schnittpunktKreisGerade %d %3d,%3d %3d,%3d\n",i,x1,y1,x2,y2);
  
  i = schnittpunktKreisGerade(0,0, 60, -30,-60, 40,30,x1,y1,x2,y2);
  fprintf(fo,"schnittpunktKreisGerade %d %3d,%3d %3d,%3d\n",i,x1,y1,x2,y2);
  
  i = schnittpunktKreisGerade(0,0, 50, -30,-60, 40,30,x1,y1,x2,y2);
  fprintf(fo,"schnittpunktKreisGerade %d %3d,%3d %3d,%3d\n",i,x1,y1,x2,y2);

  i = schnittpunktKreisGerade(0,0, 40, -30,-60, 40,30,x1,y1,x2,y2);
  fprintf(fo,"schnittpunktKreisGerade %d %3d,%3d %3d,%3d\n",i,x1,y1,x2,y2);

  i = schnittpunktKreisGerade(0,0, 30, -30,-60, 40,30,x1,y1,x2,y2);
  fprintf(fo,"schnittpunktKreisGerade %d %3d,%3d %3d,%3d\n",i,x1,y1,x2,y2);

  i = schnittpunktKreisGerade(0,0, 20, -30,-60, 40,30,x1,y1,x2,y2);
  fprintf(fo,"schnittpunktKreisGerade %d %3d,%3d %3d,%3d\n",i,x1,y1,x2,y2);


/**** umorganisation der winkeltabelle
  Winkelentry *winkeltab = gs->ship.getWinkeltab();

  for (i=0;i<86;i++) {
    fprintf(fo,"{%d,%d,%d,%d},\n",
      winkeltab[i].ship_bx,
      winkeltab[i].ship_by,
      winkeltab[i].shot_dx8,
      winkeltab[i].shot_dy8);
    fprintf(fo,"{%d,%d,%d,%d},\n",
      winkeltab[i+86+85].ship_bx,
      winkeltab[i+86+85].ship_by,
      winkeltab[i+86+85].shot_dx8,
      winkeltab[i+86+85].shot_dy8);
    fprintf(fo,"{%d,%d,%d,%d},\n",
      winkeltab[i+86].ship_bx,
      winkeltab[i+86].ship_by,
      winkeltab[i+86].shot_dx8,
      winkeltab[i+86].shot_dy8);
  }
****/

//  gs->setLogfile(fo);
//  pPlayer->setLogfile(fo);

  pPlayer->Send(); // Startsequenz an MAME senden

  static int fs_mode  = 0; // 0=nix 1=in level 2=leveldone
  static int fs_level = 0; // level
  static int fs_frame = 0; // statistikframe
  static int fs_frame_weg = 0; // statistikframe
  static int fs_score = 0; // statistikframe
  static int fs_ufo   = 0; // statistikframe
  static int fs_ship  = 0; // statistikframe
  static int fs_score64 = 0; // statistikframe
  static int fs_frame64 = 0; // statistikframe

  static int sendName = 0;
  GameStatus *gs;

  for (;;) {
    pPlayer->Receive(9);


    QueryPerformanceCounter(&lpCounter);

    pPlayer->InterpretScreen(); // hier noch synchronisieren, wenn 2. Thread Berechnung durchfhrt
    gs = pPlayer->getStatus();  // Zeiger auf GameStatusobjekt

    if (pPlayer->version > 1) { // recording sendname, etc
      if (strlen(gs->message) > 0) {
        printf("message: %s",gs->message);
        fprintf(fo,"message: %s\n",gs->message);
        if (strncmp(gs->message,"busy",4) == 0) { // etwas warten
          Sleep(2000); // in milliseconds
          pPlayer->Send();
          continue;
        }
        if (strncmp(gs->message,"game",4) == 0) { // schon vorbei

          fprintf(fs,"%2d %2d %2d %5d %5d %6d %6d GAME OVER\n", fs_level, gs->shipCount, gs->nasteroids, gs->nFrames,
                 gs->nFrames-fs_frame, fs_score64, 0);

          time( &aclock );                 /* Get time in seconds */
          newtime = localtime( &aclock );  /* Convert time to struct */
          printf("GAME OVER.\n");
          printf("SCORE: %d %s",fs_score64,asctime( newtime )); // asctime contains \n

          if (fo) fclose(fo);
          if (fs) fclose(fs);
          exit(0);
        }
        pPlayer->Send(); // Startsequenz an MAME senden
        sendName = 0;
        continue;
      } else {
        if (sendName == 0) {
          sendName = 1;
          pPlayer->SendPacketName("Raumfahrer Fips"); // Name an MAME senden
          continue;
        }
      }
    }


    if (gs->nFrames > 19000) {
      if (fo) fclose(fo);
      if (fs) fclose(fs);
      exit(0);
    }

    if (gs->ship_present) {
      static int startx = 0;
      pPlayer->logOn = true;

      if (startx == 0) {
        startx++;
        gs->nFrames = 1;                 /* reset Framecounter */
        fs_frame64  = 0;
        time( &aclock );                 /* Get time in seconds */
        newtime = localtime( &aclock );  /* Convert time to struct */
        fprintf(fs,"\nStart BOT:  %s", asctime( newtime ) ); // asctime contains \n
        fprintf(fs,"Lv RS AS Frame local Punkte Ereignis\n"); // asctime contains \n
        fprintf(fs,"%2d %2d    %5d %5d %6d\n", fs_level,gs->shipCount, gs->nFrames,
                   gs->nFrames-fs_frame, gs->score );
        fs_score = gs->score;
        fs_frame = gs->nFrames;
      }
    }


    if (gs->nasteroids == 0 && fs_mode != 2) {
      fs_mode = 2; // leveldone
      fprintf(fs,"%2d %2d    %5d %5d %6d %6d Asteroiden weg %3d Punkte je 100 Frames\n", fs_level,gs->shipCount, gs->nFrames,
                 gs->nFrames-fs_frame, gs->score, gs->score-fs_score,
                 ((gs->score-fs_score)*100)/(gs->nFrames-fs_frame_weg));
      fs_score = gs->score;
      fs_frame = gs->nFrames;
      fs_frame_weg = gs->nFrames;
      fs_level++;
      gs->level++;
    }
    if (gs->nasteroids > 0 && fs_mode != 1 && fs_ship == 1) {
      fs_mode = 1; // in level
      fs_frame64 = 0;
      fprintf(fs,"%2d %2d %2d %5d %5d %6d %6d NEW LEVEL\n", fs_level, gs->shipCount, gs->nasteroids,
                 gs->nFrames, gs->nFrames-fs_frame, gs->score,gs->nasteroids*520 );
      fs_score = gs->score;
      fs_frame = gs->nFrames;
    }
    if (gs->nasteroids > 0 || gs->saucer_present || gs->nFrames > 17995) {
      fs_frame64++;
      if (fs_frame64 >= 128 || gs->nFrames > 17995) {
        fs_frame64 = 0;
        fprintf(fs,"%2d %2d %2d %5d %5d %6d %6d SCORE%s\n", fs_level, gs->shipCount, gs->nasteroids, gs->nFrames,
                 gs->nFrames-fs_frame, gs->score, gs->score - fs_score64,
                 (gs->nFrames == 18000) ? " End BOT." : "");
        fs_score64 = gs->score;
      }
    }
    if (gs->saucer_present && fs_ufo == 0) { // ufo taucht auf
      fs_ufo = 1; // present
      fprintf(fs,"%2d %2d %2d %5d %5d %6d %c UFO da %d %d\n", fs_level,gs->shipCount, gs->nasteroids,
                 gs->nFrames,gs->nFrames-fs_frame,gs->score,gs->saucer.sfc,
                 gs->saucer.x,gs->saucer.y);
    }
    if (!gs->saucer_present && fs_ufo == 1) { // ufo taucht ab
      fs_ufo = 0; // present
      fprintf(fs,"%2d %2d %2d %5d %5d %6d %c UFO weg\n", fs_level,gs->shipCount, gs->nasteroids,
                 gs->nFrames,gs->nFrames-fs_frame,gs->score,gs->saucer.sfc );
    }
    if (gs->ship_present && fs_ship == 0) { // ship taucht auf
      fs_ship = 1; // present
      fprintf(fs,"%2d %2d %2d %5d %5d %6d   SCHIFF da %d %d\n", fs_level,gs->shipCount, gs->nasteroids,
                 gs->nFrames,gs->nFrames-fs_frame,gs->score,
                 gs->ship.x,gs->ship.y);
    }
    if (!gs->ship_present && fs_ship == 1) { // ship taucht ab
      fs_ship = 0; // present
      fprintf(fs,"%2d %2d %2d %5d %5d %6d   SCHIFF weg\n", fs_level,gs->shipCount, gs->nasteroids,
                 gs->nFrames,gs->nFrames-fs_frame,gs->score );
    }
    if (!gs->ship_present && fs_ship == 1) { // ship taucht ab
      fs_ship = 0; // present
      fprintf(fs,"%2d %2d %2d %5d %5d %6d   SCHIFF weg\n", fs_level,gs->shipCount, gs->nasteroids,
                 gs->nFrames,gs->nFrames-fs_frame,gs->score );
    }

//////////////////////////////////////////

    if (pPlayer->logOn) {
      fprintf(fo,"------------\n");
      fprintf(fo,"K: %03d -%-6s-\n",
        pPlayer->oldgame->sentKeys.ping,pPlayer->keyString);
      char buffer[20];
      pPlayer->keyHistory[gs->readping].getKeysAsString(buffer);
      fprintf(fo,"F: %03d -%-6s- %5d %5d %03d M%d L%d (%02X) [%d] =>%05d<=\n",
         gs->readping , buffer, gs->nFrames, gs->nLevelFrames, gs->frameno,
         gs->mode, gs->level, gs->jmpl,gs->shipCount,gs->score);

      if (false) { // counter
        fprintf(fo,"count:    %d   %d %d\n",
          lpCounter.LowPart - lastv,
          lpCounter.LowPart,
          lpCounter.HighPart);
        lastv = lpCounter.LowPart;
      }
     
      if (true) { // ship
        fprintf(fo,"R: %c  WB=%3d,%3d %4d %4d   %2d %2d (%3d) (%3d)   %d %d\n",
          gs->ship_present ? 'X' : '-', gs->ship.thisWinkelbyte, gs->ship.nextWinkelbyte,
          gs->ship.x, gs->ship.y, gs->ship.dx, gs->ship.dy,gs->ship.dx8, gs->ship.dy8,
          gs->ship.bx, gs->ship.by);
        if (gs->saucer_present) {
          fprintf(fo,"U: %c             %4d %4d   %2d %2d (%3d) (%3d)\n",
            gs->saucer.sfc, gs->saucer.x, gs->saucer.y, gs->saucer.dx, gs->saucer.dy,
            gs->saucer.dx8, gs->saucer.dy8);
        }
      }
      
      int k;
      

      if (true) { // asteroiden ausgeben
        for (k=0;k<gs->nasteroids;k++) {
          Asteroid a = gs->asteroids[k];
          fprintf(fo,"A: %c%1d %2d: ref=%2d %4d %4d   %2d %2d (%3d) (%3d) [%3d] %4d %4d T=%1d %2d\n",
            a.sfc, a.type, k, a.refindex, a.x, a.y,a.dx,a.dy, a.dx8,a.dy8,
              a.lastFrameSeen-a.firstFrameSeen, a.kursdistanz, a.distanz,
              a.target,a.targetTimeToLive);
        }
      }

      // neuer Status
      if (true) { // asteroiden+1 ausgeben
        fprintf(fo,"\n");
        for (k=0;k<gs->nasteroids;k++) {
          Asteroid a = pPlayer->newgame->asteroids[k];
          fprintf(fo,"A: %c%1d %2d: ref=%2d %4d %4d   %2d %2d (%3d) (%3d) [%3d] %4d %4d T=%1d %2d\n",
            a.sfc, a.type, k, a.refindex, a.x, a.y,a.dx,a.dy, a.dx8,a.dy8,
              a.lastFrameSeen-a.firstFrameSeen, a.kursdistanz, a.distanz,
              a.target,a.targetTimeToLive);
        }
      }
    }

    pPlayer->Run();   // was ist zu tun ?
    
    
    if (true) { // schuesse erst hier ausgeben, da in run debug info (sfc) berechnet wird
      for (int k=0;k<gs->nshots;k++) {
        Shot shot = gs->shots[k];
        fprintf(fo,"S: %c %2d: ref=%2d %4d %4d   %2d %2d (%3d) (%3d) [%3d]\n",
          shot.sfc, k, shot.refindex, 
          shot.x, shot.y,shot.dx,shot.dy,
          shot.dx8,shot.dy8,
          shot.lastFrameSeen-shot.firstFrameSeen);
          /* historie ausgeben
          for (m=0;m<16;m++) {
          Shot shot = pPlayer->gameHistory[m].shots[0];
          fprintf(fo,"S:  %2d: ref=%2d %3d %6d %6d   %d %d %d %d\n",
          m, shot.refindex, shot.firstFrameSeen & 0xFF,
          shot.x, shot.y,shot.dx,shot.dy,
          gs->summe8x,gs->summe8y);
          }
        */
      }
    }

    pPlayer->Send();  // Tasten senden
    Sleep(0);         // relinqish thread timeslice
 
  }

  if (fo) fclose(fo);

  return 0;   // Thread erfolgreich ausgefhrt
}


// ermittelt die Richtung eines Schuss in X-Richtung x 8
int Player::calcShotDirX8(int nr)
{

  int s8;
  unsigned char idx;
  int origin = game->shots[nr].x;

  // default ist die distanz zu schuss-1 * 8
  s8 = game->shots[nr].dx*8;

  int si = -1; //schussindex
  unsigned char sc = 0;  //framecount

  si = game->shots[nr].refindex;

  while (si >= 0 && sc < 8) {
    sc++;
    idx = game->frameno - sc;
    // sind bereits gengend frames da und ist das auch gltig
    if (gameHistory[idx].nFrames == game->nFrames-sc) {
      s8 = normalizeX(origin - gameHistory[idx].shots[si].x);
    }
    si = gameHistory[idx].shots[si].refindex;
  }
  if (sc > 0) {
    s8 = (s8 * 8) / sc;
  }
  return s8;

}



int Player::calcShotDirY8(int nr)
{

  int s8;
  unsigned char idx;
  int origin = game->shots[nr].y;

  s8 = game->shots[nr].dy*8;

  int si = -1; //schussindex
  unsigned char sc = 0;  //framecount

  si = game->shots[nr].refindex;
  while (si >= 0 && sc < 8) {
    sc++;
    idx = game->frameno - sc;
    // sind bereits gengend frames da und ist das auch gltig
    if (gameHistory[idx].nFrames == game->nFrames-sc) {
      s8 = normalizeY(origin - gameHistory[idx].shots[si].y);
    }
    si = gameHistory[idx].shots[si].refindex;
  }

  if (sc > 0) {
    s8 = (s8 * 8) / sc;
  }

  return s8;
  
}


// ermittelt die Richtung eines Asteroiden in X-Richtung x 8
int Player::calcAstDirX8(int nr)
{

  int s8;
  unsigned char idx;
  int origin = game->asteroids[nr].x;

  // default ist die distanz zu frame-1 * 8
  s8 = game->asteroids[nr].dx*8;

  int si = -1; //frameindex
  unsigned char sc = 0;  //framecount

  si = game->asteroids[nr].refindex;

  while (si >= 0 && sc < 8) {
    sc++;
    idx = game->frameno - sc;
    // sind bereits gengend frames da und ist das auch gltig
    if (gameHistory[idx].nFrames == game->nFrames-sc) {
      s8 = normalizeX(origin - gameHistory[idx].asteroids[si].x);
    }
    si = gameHistory[idx].asteroids[si].refindex;
  }
  if (sc > 0) {
    s8 = (s8 * 8) / sc;
  }
  return s8;

}



int Player::calcAstDirY8(int nr)
{

  int s8;
  unsigned char idx;
  int origin = game->asteroids[nr].y;

  s8 = game->asteroids[nr].dy*8;

  int si = -1; //schussindex
  unsigned char sc = 0;  //framecount

  si = game->asteroids[nr].refindex;
  while (si >= 0 && sc < 8) {
    sc++;
    idx = game->frameno - sc;
    // sind bereits gengend frames da und ist das auch gltig
    if (gameHistory[idx].nFrames == game->nFrames-sc) {
      s8 = normalizeY(origin - gameHistory[idx].asteroids[si].y);
    }
    si = gameHistory[idx].asteroids[si].refindex;
  }

  if (sc > 0) {
    s8 = (s8 * 8) / sc;
  }

  return s8;
  
}


// ermittelt die geschwindigkeit des ufo in X-Richtung x 8
int Player::calcSaucerDirX8()
{

  int s8 = 0;
  unsigned char idx;
  int si = 0; //schussindex
  unsigned char sc = 0;  //framecount
  int origin = game->saucer.x;

  // default ist die distanz zu frame-1 * 8
  idx = game->frameno-1;
  if (!gameHistory[idx].saucer_present) {
    return 0;
  }

  while (si >= 0 && sc < 8) {
    sc++;
    idx = game->frameno - sc;
    if (gameHistory[idx].saucer_present) {
      s8 = normalizeX(origin - gameHistory[idx].saucer.x);
    } else {
      si = -1;
      sc--;
    }
  }
  if (sc > 0) {
    s8 = (s8 * 8) / sc;
  }
  return s8;

}




// ermittelt die geschwindigkeit des ufo in Y-Richtung x 8
int Player::calcSaucerDirY8()
{

  int s8 = 0;
  unsigned char idx;
  int si = 0; //schussindex
  unsigned char sc = 0;  //framecount
  int origin = game->saucer.y;

  // default ist die distanz zu frame-1 * 8
  idx = game->frameno - 1;
  if (!gameHistory[idx].saucer_present) {
    return 0;
  }

  while (si >= 0 && sc < 8) {
    sc++;
    idx = game->frameno - sc;
    if (gameHistory[idx].saucer_present) {
      s8 = normalizeY(origin - gameHistory[idx].saucer.y);
    } else {
      si = -1;
      sc--;
    }
  }
  if (sc > 0) {
    s8 = (s8 * 8) / sc;
  }
  return s8;

}




// ermittelt die geschwindigkeit des schiffs in X-Richtung x 8
int Player::calcShipDirX8()
{

  int s8 = 0;
  unsigned char idx;
  int si = 0; //schussindex
  unsigned char sc = 0;  //framecount
  int origin = game->ship.x;

  // default ist die distanz zu frame-1 * 8

  idx = game->frameno - 1;
  if (!gameHistory[idx].ship_present) {
    return 0;
  }

  while (si >= 0 && sc < 8) {
    sc++;
    idx = game->frameno - sc;
    if (gameHistory[idx].ship_present) {
      s8 = normalizeX(origin - gameHistory[idx].ship.x);
    } else {
      si = -1;
      sc--;
    }
  }
  if (sc > 0) {
    s8 = (s8 * 8) / sc;
  }
  return s8;

}




// ermittelt die geschwindigkeit des Schiffs in Y-Richtung x 8
int Player::calcShipDirY8()
{

  int s8 = 0;
  unsigned char idx;
  int si = 0; //schussindex
  unsigned char sc = 0;  //framecount
  int origin = game->ship.y;

  // default ist die distanz zu frame-1 * 8
  idx = game->frameno - 1;
  if (!gameHistory[idx].ship_present) {
    return 0;
  }

  while (si >= 0 && sc < 8) {
    sc++;
    idx = game->frameno - sc;
    if (gameHistory[idx].ship_present) {
      s8 = normalizeY(origin - gameHistory[idx].ship.y);
    } else {
      si = -1;
      sc--;
    }
  }
  if (sc > 0) {
    s8 = (s8 * 8) / sc;
  }
  return s8;

}



// naechstgelegenen Asteroiden oder ufo ermitteln
// return -1  turn left
// return  0  stay
// return +1  turn right
int Player::fireAtUFO(int &min_dist, int &min_dx, int &min_dy, int &futureFrame, bool &fire,bool lastFrameFired)
{
  int index  = -1;
  int future =  futureFrame;
  bool b;
  GameStatus *gs = newgame;

  fire = false;

  // wenn ufo nicht gesichtet, dann weiterspielen
  if (!gs->saucer_present)        return -2; // do nothing
  if (gs->saucer.maxTargets()) return -2;

  for (future=0; future<115; future++) {
    for (int f1=-future; f1 <= future; f1++) {
      int sx1,sy1,sx52,sy52;
      
     // if (f1 == 0 && lastFrameFired) continue; //schiessen nicht mglich

      int f2 = future - abs(f1); // entweder drehen oder schiessen
      if (f2 > 69) continue;

      sx1 = gs->ship.getNextWinkelbyteDx8(f1);
      sy1 = gs->ship.getNextWinkelbyteDy8(f1);
      sx52 = (sx1*5) >> 1;  // * 2.5 bzw * 5/2
      sy52 = (sy1*5) >> 1;  
      
      int size = 0;
      
      if (gs->saucer.sf == 15) {
        // Abstand um den ungefhren Radius des UFOs korrigieren
        // groes UFO
        size = 17*8; // 21*8
      } else {
        size = 9*8; // 11*8
      }
      
      b = liegtPunktInKreis( 
        // origin (0) + austrittspunkt + flugbahn
        sx52 + sx1 * f2,
        sy52 + sy1 * f2,
        gs->saucer.relX8 + gs->saucer.dx8 * (future),
        gs->saucer.relY8 + gs->saucer.dy8 * (future),
        size); // durchmesser * 8
      if (b) {
        if (f1 < 0) return -1;
        if (f1 > 0) return +1;
        if (!lastFrameFired && gs->nshots < 4) {
          game->saucer.incTarget(f2);
          fire = true;
          return 0;
        }
      }
      
    } // for f1
  } // for future */
  return 0;
  
}


// Asteroiden auf Abschuss prfen
// return -1  turn left
// return  0  stay
// return +1  turn right
int Player::fireAtAsteroid(int &f1, int &f2, int &min_dy, int &futureFrame, bool &fire, int i,bool lastFrameFired)
{
  int  index  = -1;
  int  future =  futureFrame;
  bool b;
  fire = false;
  GameStatus *gs = newgame;

  if (gs->asteroids[i].maxTargets()) return -2;

  // test, ob bereits etwas ueber die bewegung des asteroiden bekannt ist
  if (gs->asteroids[i].dx8 == 0 && gs->asteroids[i].dy8 == 0) {
    return -2;
  }

  for (future=0; future<132; future++) {
    for (f1=-future; f1 <= future; f1++) {
      int sx1,sy1,sx52,sy52;
      
      // if (f1 == 0 && lastFrameFired) continue; //schiessen nicht mglich
      // future ist die summe von f1 und f2
      // f1 ist die Anzahl der notwendigen Drehungen
      // f2 ist die Anzahl der Flugschritte des Schusses
      f2 = future - abs(f1); // entweder drehen oder schiessen
      if (f2 > 68) continue;

      sx1 = gs->ship.getNextWinkelbyteDx8(f1);
      sy1 = gs->ship.getNextWinkelbyteDy8(f1);
      sx52 = (sx1*5) >> 1;  // * 2.5 bzw * 5/2
      sy52 = (sy1*5) >> 1;  
      
      
      int size = 0;
      
      switch (gs->asteroids[i].sf)
      {	// Abstand um den ungefhren Radius des Asteroiden korrigieren
        // je kleiner der Radius gewhlt wird, um so sicherer ein abschuss
      case 0:  // groer Asteroid
        size = 23*8; // 31
        break;
      case 15: // mittlerer Asteroid
        size = 11*8;  //15
        break;
      case 14: // kleiner Asteroid
        size = 5*8;  //7
        break;
      }
      
      // gesucht ist schnittpunkt asteroid / schuss-flugbahn
      
      
      b = liegtPunktInKreis( 
        // origin (0) + austrittspunkt + flugbahn des Schusses
        sx52 + sx1 * f2,
        sy52 + sy1 * f2,
        gs->asteroids[i].relX8 + gs->asteroids[i].dx8 * (future),  //+1
        gs->asteroids[i].relY8 + gs->asteroids[i].dy8 * (future),  //+1
        size); // asteroidendurchmesser * 8
      if (b) {
        fprintf(fo,"fireAtAst: A=%2d x=%4d y=%4d sx1=%4d sy1=%3d sx52=%4d sy52=%3d f1=%2d ttl=%2d\n",
          i, gs->ship.x + sx52/8, gs->ship.y + sy52/8,sx1,sy1,sx52,sy52,f1,f2);
        
        if (f1 < 0) return -1;
        if (f1 > 0) return +1;
        // Auf grosse asteroiden ruhig mehrmals schiessen, ev.abhngig vom abstand
        if (!gs->asteroids[i].maxTargets()) {
          if (!lastFrameFired && gs->nshots < 4) {  // UFO Schsse noch bercksichtigen
            game->asteroids[i].incTarget(f2);
            fire = true;
          }
        }
        
      }
      
    } // for f1
  } // for future 
  return 0;
  
}





int Player::selectAsteroid(bool &fire,bool lastFrameFired)
{
  int max_value = -1;
  int max_idx   = 0;
  int value;
  int drehen,schiessen,dummy;
  int i4;
  
  for (i4=0; i4<game->nasteroids; i4++)
  {   // nchstgelegenen Asteroiden suchen
    
    // wurde bereits auf diesen asteroiden geschossen?
    if (game->asteroids[i4].maxTargets()) continue;

    fireAtAsteroid(drehen,schiessen,dummy,dummy,fire,i4,lastFrameFired);
    fprintf(fo,"select %d %d %d\n",i4,drehen,schiessen);
    if (schiessen > 0 && schiessen < 60) {
      value = abs(drehen) + schiessen;  // anzahl der schritte
      if (value > max_value) {
        max_value = value;
        max_idx   = i4;
      }
    }

    
  }
  
  return max_idx;
  
}



// naechstgelegenen Asteroiden ermitteln
// return -1  turn left
// return  0  stay
// return +1  turn right
int Player::fireAt(int &min_dist, int &min_dx, int &min_dy, int &futureFrame, bool &fire,bool lastFrameFired)
{
  int index  = -1;
  int future =  futureFrame;
  int sx1,sy1,sx52,sy52;
  int i;
  fire = false;
  GameStatus *gs = newgame;

  // test, ob bereits etwas ueber die bewegung der asteroiden bekannt ist
  bool b=true;

  for (i=0; i<gs->nasteroids; ++i) {
    if (gs->asteroids[i].dx8 != 0 || gs->asteroids[i].dy8 != 0) {
      b=false;
      break;
    }
  }
  if (b) return 0; // do nothing


  for (future=0; future<330; future++) {
    for (int f1=0; f1 <= future; f1++) {
      int f2 = future - f1;
      if (f2 > 69) continue;
      for (int mult=-1;mult <= 1; mult+=2) {

      sx1 = gs->ship.getNextWinkelbyteDx8(f1*mult);
      sy1 = gs->ship.getNextWinkelbyteDy8(f1*mult);
      sx52 = (sx1*5) >> 1;  // * 2.5 bzw * 5/2
      sy52 = (sy1*5) >> 1;  
      
      for (i=0; i<gs->nasteroids; ++i)
      {   // nchstgelegenen Asteroiden suchen

        // wurde bereits auf diesen asteroiden geschossen?
        if (gs->asteroids[i].maxTargets(future)) continue;
        if (gs->asteroids[i].lastFrameSeen - gs->asteroids[i].firstFrameSeen < 8) continue;
        
        int size = 0;
        
        switch (gs->asteroids[i].sf)
        {	// gre ermitteln
        case 0:  // groer Asteroid
          size = 23*8; //31
          break;
        case 15: // mittlerer Asteroid
          size = 11*8; //15
          break;
        case 14: // kleiner Asteroid
          size = 5*8;  //7 5
          break;
        }
        
        // gesucht ist schnittpunkt asteroid / schuss-flugbahn
        int wait;
        for (wait = 0; wait<2; wait++) {
        b = liegtPunktInKreis( 
          // origin (0) + austrittspunkt + flugbahn des Schusses im next frame
          sx52 + sx1 * f2,
          sy52 + sy1 * f2,
          gs->asteroids[i].relX8 + gs->asteroids[i].dx8 * (future+wait),  //
          gs->asteroids[i].relY8 + gs->asteroids[i].dy8 * (future+wait),  //
          size); // asteroidendurchmesser * 8
          if (b) break;
        }
/*
        fprintf(fo,"fireAt i=%d f1=%d f2=%d %d %d %d %d %d b=%d\n",
          i,f1,f2,
          sx52 + sx1 * f2,
          sy52 + sy1 * f2,
          gs->asteroids[i].relX8 + gs->asteroids[i].dx8 * (future),  //
          gs->asteroids[i].relY8 + gs->asteroids[i].dy8 * (future),  //
          size,b);
*/        
        if (b) {
          fprintf(fo,"fireAt: A=%2d x=%4d y=%4d sx1=%4d sy1=%3d sx52=%4d sy52=%3d rot=%2d ttl=%2d\n",
            i, gs->ship.x + sx52/8, gs->ship.y + sy52/8,sx1,sy1,sx52,sy52,f1*mult,f2);

          if (wait > 0) return 0;
          if (f1*mult < 0) return -1;
          if (f1*mult > 0) return +1;

          // Auf grosse asteroiden ruhig mehrmals schiessen, ev.abhngig vom abstand
          if (!gs->asteroids[i].maxTargets()) {
            if (!lastFrameFired && gs->nshots < 4) {
              game->asteroids[i].incTarget(f2);
              fire = true;
            }
          }
          return 0;
        }
        
      } //for i
      } // for mult
    } // for f2
  } // for f1 */
  return 0;
  
}


// Kann beim aktuellen Winkelbyte ein Asteroid getroffen werden?
// wird bei der UFO Jagd verwendet, um zustzliche Asteroiden abzuschiessen
// return -2  do nothing
int Player::fireNowAt(int &min_dist, int &min_dx, int &min_dy, int &futureFrame, bool &fire,bool lastFrameFired)
{
  int index  = -1;
  int future =  futureFrame;
  int sx1,sy1,sx52,sy52;
  int i;
  fire = false;
  GameStatus *gs = newgame;
  
  // test, ob bereits etwas ueber die bewegung der asteroiden bekannt ist
  bool b=true;
  
  for (i=0; i<gs->nasteroids; ++i) {
    if (gs->asteroids[i].dx8 != 0 || gs->asteroids[i].dy8 != 0) {
      b=false;
      break;
    }
  }
  if (b) return -2; // do nothing
  
  
  for (int f2=0; f2 <= 72; f2++) {
    
    sx1 = gs->ship.getNextWinkelbyteDx8(0);
    sy1 = gs->ship.getNextWinkelbyteDy8(0);
    sx52 = (sx1*5) >> 1;  // * 2.5 bzw * 5/2
    sy52 = (sy1*5) >> 1;  
    
    for (i=0; i<gs->nasteroids; ++i)
    {   // nchstgelegenen Asteroiden suchen
      
      // wurde bereits auf diesen asteroiden geschossen?
      if (gs->asteroids[i].maxTargets(0)) continue;
      if (gs->asteroids[i].lastFrameSeen - gs->asteroids[i].firstFrameSeen < 8) continue;
      
      int size = 0;
      
      switch (gs->asteroids[i].sf)
      {	// gre ermitteln
      case 0:  // groer Asteroid
        size = 23*8; //31
        break;
      case 15: // mittlerer Asteroid
        size = 11*8; //15
        break;
      case 14: // kleiner Asteroid
        size = 5*8;  //7
        break;
      }
      
      // gesucht ist schnittpunkt asteroid / schuss-flugbahn
      b = liegtPunktInKreis( 
        // origin (0) + austrittspunkt + flugbahn des Schusses im next frame
        sx52 + sx1 * f2,
        sy52 + sy1 * f2,
        gs->asteroids[i].relX8 + gs->asteroids[i].dx8 * (f2),  //
        gs->asteroids[i].relY8 + gs->asteroids[i].dy8 * (f2),  //
        size); // asteroidendurchmesser * 8
               /*
               fprintf(fo,"fireAt i=%d f1=%d f2=%d %d %d %d %d %d b=%d\n",
               i,f1,f2,
               sx52 + sx1 * f2,
               sy52 + sy1 * f2,
               gs->asteroids[i].relX8 + gs->asteroids[i].dx8 * (f2),  //
               gs->asteroids[i].relY8 + gs->asteroids[i].dy8 * (f2),  //
               size,b);
      */        
      if (b) {
        fprintf(fo,"fireNowAt: A=%2d x=%4d y=%4d sx1=%4d sy1=%3d sx52=%4d sy52=%3d ttl=%2d\n",
          i, gs->ship.x + sx52/8, gs->ship.y + sy52/8,sx1,sy1,sx52,sy52,f2);
        
        // Auf grosse asteroiden ruhig mehrmals schiessen, ev.abhngig vom abstand
        if (!gs->asteroids[i].maxTargets()) {
          if (!lastFrameFired && gs->nshots < 3) {  // ein schuss fr ufo briglassen
            game->asteroids[i].incTarget(f2);
            fire = true;
          }
        }
        return 0;
      }
      
    } //for i
    
  } // for f2
  return -2;
  
}

// Asteroid auf Kollisionskurs?
// dann weg damit
// return +1 left
// return  0 stay
// return -1 right
int Player::detectCollision(int &min_dist, int &min_dx, int &min_dy, int &futureFrame,bool &fire,bool lastFrameFired)
{
  int index  = -1;
  int future =  futureFrame;
  int size = 0;
  min_dist = 0x7fffffff;
  min_dx   = 0;
  min_dy   = 0;
  int min_idx  = -1;
  int dx,dy,dx2,dy2,dist1,dist2;
  int s,s1;
  int anzahlKollisionen = 0;

  fire = false;
 
  for (int i=0; i<game->nasteroids; ++i)
  {   // Asteroiden auf kollisionskurs suchen


    if (game->asteroids[i].maxTargets()) continue;
    
    if (game->asteroids[i].dx8 == 0 && game->asteroids[i].dy8 == 0) continue;

    // wie nahe schrammt der Asteroid am Raumschiff vorbei?
    s = abstandPunktGerade(
      0,0,
      game->asteroids[i].relX8,
      game->asteroids[i].relY8,
      game->asteroids[i].dx8,
      game->asteroids[i].dy8
    );

    fprintf(fo,"Abstand RS Asteroidenkurs %d: %4d\n",i,s/8);

    switch (game->asteroids[i].sf)
    {	// Abstand um den ungefhren Radius des Asteroiden + Raumschiff (24) korrigieren
    case 0:  // groer Asteroid 64
      if (abs(s) > 56*8) continue; 
      size = 58*8; // 40
      break;
    case 15: // mittlerer Asteroid 32
      if (abs(s) > 40*8) continue;
      size = 42*8;  // 20
      break;
    case 14: // kleiner Asteroid 16
      if (abs(s) > 32*8) continue;
      size = 34*8; // 10
      break;
    }
    
    dx  = game->asteroids[i].relX8;
    dy  = game->asteroids[i].relY8;
    dx2 = dx + game->asteroids[i].dx8;
    dy2 = dy + game->asteroids[i].dy8;
    
    dist1 = dx*dx+dy*dy;  // Quadrat des Abstands zu diesem Asteroiden
    dist2 = dx2*dx2+dy2*dy2;
    if (dist2 > dist1) { // Asteroid entfernt sich -> kein Problem
      continue;
    }

//    fprintf(fo,"Abstand Asteroid %d  %d %d\n",i,dist1,dist2);

    index = i;


    s1 = 0x7fffffff;
    int sx1,sy1,sx2,sy2,a1,a2,d;

    // wann wird die Kollision stattfinden?
    s = schnittpunktKreisGerade(0,0,size,
          game->asteroids[index].relX8,game->asteroids[index].relY8,
          game->asteroids[index].dx8,game->asteroids[index].dy8,
          sx1,sy1,sx2,sy2);
    if (s == 0) continue; //nanu?
    
    a1 = abstandPunktPunkt8( sx1,sy1,
        game->asteroids[index].relX8,
        game->asteroids[index].relY8);

    a2 = abstandPunktPunkt8( sx2,sy2,
        game->asteroids[index].relX8,
        game->asteroids[index].relY8);

    d = (int)sqrt(game->asteroids[i].dx8 * game->asteroids[i].dx8 
           + game->asteroids[i].dy8 * game->asteroids[i].dy8);

    int e = 999;

    if ( d > 0) {
      if (a1 < a2) {
        e = a1/d;
      } else {
        e = a2/d;
      }
    }
  
    fprintf(fo,"Einschlag Asteroid %d in %d Frames\n",index,e);
    anzahlKollisionen++;

    if (e < min_dist)
    {
      min_dist = e;
      min_dx   = dx;
      min_dy   = dy;
      min_idx  = index;
    }
  }

  if (index < 0) return -2;
  if (min_dist > 50 && anzahlKollisionen < 2) return -2;  // 80, 85

  return fireAtAsteroid(min_dist, min_dx, min_dy, futureFrame, fire,min_idx,lastFrameFired);

}



// naechstgelegenen Asteroiden ermitteln
int Player::getNextAsteroid(int &min_dist, int &min_dx, int &min_dy, int &futureFrame)
{
  int index  = -1;
  int future =  futureFrame;

 /* for (int future=0; future<40; future++) { */
    for (int i=0; i<game->nasteroids; ++i)
    {   // nchstgelegenen Asteroiden suchen
      int s;
      int sx1,sy1,sx2,sy2;

      s = schnittpunktKreisGerade(
        game->ship.x * 8 + game->ship.dx8 * future,
        game->ship.y * 8 + game->ship.dy8 * future,
        800, // Schiffdurchmesser * 8
        game->asteroids[i].x * 8 + game->asteroids[i].dx8 * future,
        game->asteroids[i].y * 8 + game->asteroids[i].dy8 * future,
        game->asteroids[i].dx8,
        game->asteroids[i].dy8,
        sx1,sy1,sx2,sy2);

      if (s < 2) continue;

      int dx = ((game->asteroids[i].x * 8 + game->asteroids[i].dx8 * future)
        - (game->ship.x * 8 + game->ship.dx8 * future))/8;
      
      while (dx < -512) dx += 1024; // dx normalisieren auf -512 ... 511
      while (dx >  511) dx -= 1024;
      
      int dy = ((game->asteroids[i].y * 8 + game->asteroids[i].dy8 * future)
        - (game->ship.y * 8 + game->ship.dy8 * future))/8;
      
      while (dy < -384) dy += 768;  // dy normalisieren auf -384 ... 383
      while (dy >  383) dy -= 768;
      
      int dist = dx*dx+dy*dy;  // Quadrat des Abstands zu diesem Asteroiden
      switch (game->asteroids[i].sf)
      {	// Abstand um den ungefhren Radius des Asteroiden korrigieren
      case 0:  // groer Asteroid
        dist -= 40*40;
        break;
      case 15: // mittlerer Asteroid
        dist -= 20*20;
        break;
      case 14: // kleiner Asteroid
        dist -= 8*8;
        break;
      }
      if (dist < min_dist)
      {
        index = i;
        min_dist = dist;
        min_dx = dx;
        min_dy = dy;
        futureFrame = future;
      }
    }
/*  } // for future */
  return index;
  
}


// ermittelt drehwinkel aus der letzten empfangenen keyinformation
int Player::calcDrehwinkel()
{

  // hier noch die lostframes bercksichtigen !!!

  // das in diesem Frame gelesene Pingbyte ermitteln
  return keyHistory[game->readping].drehung();

}


// beim Start eines Levels mglichst nicht am Rand aufhalten
int Player::moveToStartPosition(bool &thrust)
{

  int dir = 0;
  int min,minx,miny;
  int px,py; // Zielpunkt
  int a;
  thrust = false;

  px = 200;
  py = 200;
  min = abstand2PunktPunkt(game->ship.x,game->ship.y,px,py);

  a = abstand2PunktPunkt(game->ship.x,game->ship.y,800,560);
  if (a < min) {
    min  = a;
    px = 800;
    py = 200;
  }

  a = abstand2PunktPunkt(game->ship.x,game->ship.y,800,560);
  if (a < min) {
    min  = a;
    px = 800;
    py = 560;
  }

  a = abstand2PunktPunkt(game->ship.x,game->ship.y,200,560);
  if (a < min) {
    min  = a;
    px = 200;
    py = 560;
  }

  int sx1,sx2,sy1,sy2;
  int s;

  s = schnittpunktKreisGerade(px,py,40,
         game->ship.x,game->ship.y,game->ship.bx,game->ship.by,
                 sx1,sy1,sx2,sy2);

  if (a > 3600 && abs(game->ship.dx8) < 3 && abs(game->ship.dy8) < 3 && s > 0) {
    // richtige orientierung?
    if(a > abstand2PunktPunkt(game->ship.x+(game->ship.bx/8),game->ship.y+(game->ship.by/8),px,py)) {
      thrust = true;
    }
  }

  minx = normalizeX(px-game->ship.x);
  miny = normalizeY(py-game->ship.y);

  if (a > 3600 && s == 0) {
    if (game->ship.bx * miny - game->ship.by * minx > 0)
	  	dir = +1;
  	else
	  	dir = -1;
  }

  fprintf(fo,"mov %8d %2d %d (%3d) (%3d)\n", a, dir, thrust, game->ship.dx8 ,game->ship.dy8);

  return dir;

}


// beim Start eines Levels mglichst zum Rand zielen
int Player::rotateToStartPosition(bool &thrust)
{

  int dir = 0;
  int min,minx,miny;
  int px,py; // Zielpunkt
  int a;
  thrust = false;

  px = 0;
  py = 0;
  min = abstand2PunktPunkt(game->ship.x,game->ship.y,px,py);

  a = abstand2PunktPunkt(game->ship.x,game->ship.y,511,0);
  if (a < min) {
    min  = a;
    px = 511;
    py = 0;
  }

  a = abstand2PunktPunkt(game->ship.x,game->ship.y,1023,0);
  if (a < min) {
    min  = a;
    px = 1023;
    py = 0;
  }

  a = abstand2PunktPunkt(game->ship.x,game->ship.y,1023,383);
  if (a < min) {
    min  = a;
    px = 1023;
    py = 383;
  }

  a = abstand2PunktPunkt(game->ship.x,game->ship.y,1023,767);
  if (a < min) {
    min  = a;
    px = 1023;
    py = 767;
  }

  a = abstand2PunktPunkt(game->ship.x,game->ship.y,511,767);
  if (a < min) {
    min  = a;
    px = 511;
    py = 767;
  }

  a = abstand2PunktPunkt(game->ship.x,game->ship.y,0,767);
  if (a < min) {
    min  = a;
    px = 0;
    py = 767;
  }

  a = abstand2PunktPunkt(game->ship.x,game->ship.y,0,383);
  if (a < min) {
    min  = a;
    px = 0;
    py = 383;
  }

  int sx1,sx2,sy1,sy2;
  int s;

  s = schnittpunktKreisGerade(px,py,40,
         game->ship.x,game->ship.y,game->ship.bx,game->ship.by,
                 sx1,sy1,sx2,sy2);

  minx = normalizeX(px-game->ship.x);
  miny = normalizeY(py-game->ship.y);

  if (s == 0) {
    if (game->ship.bx * miny - game->ship.by * minx > 0)
	  	dir = +1;
  	else
	  	dir = -1;
  }

  fprintf(fo,"rot %8d %2d %d (%3d) (%3d)\n", a, dir, thrust, game->ship.dx8 ,game->ship.dy8);

  return dir;

}


// Zeit fuer Hyperspace ?
// wenn schsse ufo oder asteroid zu nahe kommen
// 
bool Player::getEmergencyStatus()
{

  int i;
  int dist1,dist2;
  int dx,dx2;
  int dy,dy2;

  for (i=0; i<game->nshots; ++i)
  { // gefhrlichen Schuss suchen
    // gerade erst aufgetaucht?, dann erst mal keine Gefahr
    // oder UFO ist so nahe, dass Kollision mit UFO droht
    if (game->shots[i].dx == 0 && game->shots[i].dy == 0) {
      game->shots[i].sfc = '?'; // unbekannte Richtung markieren fr LOG
      continue;
    }

    dx  = game->shots[i].relX8;    // jetzige Position
    dy  = game->shots[i].relY8;
    dx2 = dx + game->shots[i].dx8; // nchste Position
    dy2 = dy + game->shots[i].dy8;
    
    dist1 = dx*dx+dy*dy;       // Quadrat des Abstands zu diesem Schuss
    dist2 = dx2*dx2+dy2*dy2;   // Quadrat des Abstands zur nchsten Position
    if (dist2 > dist1) {       // schuss entfernt sich -> kein Problem
      game->shots[i].sfc = '-'; // ungefhrlich markieren fr LOG
      continue;
    }
    game->shots[i].sfc = '!';   // gefhrlich markieren fr LOG
    if (dist2 < 22*22*8*8) {   // jetzt aber weg  22
      fprintf(fo,"Emergency shot i: %d %d %d\n",i,dist1,dist2);
      return true;
    }
  }


  for (i=0; i<game->nasteroids; ++i)
  {   // gefhrlichen Asteroiden suchen
    
    dx  = game->asteroids[i].relX8;
    dy  = game->asteroids[i].relY8;
    dx2 = dx + game->asteroids[i].dx8; // nchste Position
    dy2 = dy + game->asteroids[i].dy8;
    
    dist1 = dx*dx+dy*dy;       // Quadrat des Abstands zu diesem Asteroiden
    dist2 = dx2*dx2+dy2*dy2;   // Quadrat des Abstands zur nchsten Position

    if (dist2 > dist1) {       // Asteroid entfernt sich -> kein Problem
      continue;                // ungefhrlich markieren fr LOG
    }
    
    switch (game->asteroids[i].sf)
    {	// Abstand um den ungefhren Radius des Asteroiden korrigieren
    case 0:  // groer Asteroid
      dist2 -= 41*41*8*8;
      break;
    case 15: // mittlerer Asteroid
      dist2 -= 21*21*8*8;
      break;
    case 14: // kleiner Asteroid
      dist2 -= 10*10*8*8;
      break;
    }

    if (dist2 < 22*22*8*8)  { // 12 + 4 + 4
      fprintf(fo,"Emergency asteroid i: %d %d\n",i,dist1);
      return true;
    }
  }


  
  if (game->saucer_present)
  {
    dx = game->saucer.relX8;
    dy = game->saucer.relY8;
    dx2 = dx + game->saucer.dx8; // nchste Position
    dy2 = dy + game->saucer.dy8;
    
    dist1 = dx*dx+dy*dy;       // Quadrat des Abstands zu diesem UFO
    dist2 = dx2*dx2+dy2*dy2;   // Quadrat des Abstands zur nchsten Position

    switch (game->saucer.sf)
    {	// Abstand um den ungefhren Radius des UFOs korrigieren
    case 15: // groes UFO
      dist2 -= 20*20*8*8;
      break;
    case 14: // kleines UFO
      dist2 -= 10*10*8*8;
      break;
    }

    if (dist2 < 22*22*8*8)  {
      fprintf(fo,"Emergency UFO: %d %d\n",dist1,dist2);
      return true;
    }
  }
  
  return false;
  
}

bool Player::endspiel()
{
  return false;
  return (game->nasteroidsG == 0 && game->nasteroidsM == 0);
}


// aus den vergangenen Daten das neue Frame berechnen
// fr das die Tasten gelten werden.
void Player::calcNewGame()
{
  newgame = &gameHistory[game->frameno+1];

  *newgame = *game;
  int k,t;
  for (k=0;k<game->nasteroids;k++) {
    t = newgame->asteroids[k].x * 8 + game->asteroids[k].dx8;
    newgame->asteroids[k].x = wrapX(t >> 3);
    t = newgame->asteroids[k].y * 8 + game->asteroids[k].dy8;
    newgame->asteroids[k].y = wrapY(t >> 3);
  }
  for (k=0;k<game->nshots;k++) {
    t = newgame->shots[k].x * 8 + game->shots[k].dx8;
    newgame->shots[k].x = wrapX(t >> 3);
    t = newgame->shots[k].y * 8 + game->shots[k].dy8;
    newgame->shots[k].y = wrapY(t >> 3);
  }
  if (newgame->saucer_present) {
    t = newgame->saucer.x * 8 + game->saucer.dx8;
    newgame->saucer.x = wrapX(t >> 3);
    t = newgame->saucer.y * 8 + game->saucer.dy8;
    newgame->saucer.y = wrapY(t >> 3);
  }
  if (newgame->ship_present) {
    t = newgame->ship.x * 8 + game->ship.dx8;
    newgame->ship.x = wrapX(t >> 3);
    t = newgame->ship.y * 8 + game->ship.dy8;
    newgame->ship.y = wrapY(t >> 3);
    newgame->ship.thisWinkelbyte = newgame->ship.nextWinkelbyte;
  }

    // relative Positionen berechnen
  for (k=0;k<newgame->nshots;k++) {
    newgame->shots[k].calcRelativePos(newgame->ship.x,newgame->ship.y);
  }

  // Lebenszeit der Schsse abrechnen
  for (k=0;k<game->nasteroids;k++) {
    newgame->asteroids[k].decTargetTimeToLive();
    newgame->asteroids[k].calcRelativePos(newgame->ship.x,newgame->ship.y);
  }
  newgame->saucer.decTargetTimeToLive();
  newgame->saucer.calcRelativePos(newgame->ship.x,newgame->ship.y);

}
