// player.h: Beispielspieler fr Asteroids
// Harald Bgeholz / c't
#ifndef PLAYER_H
#define PLAYER_H

#if defined(WINDOWS)
#include <winsock2.h>
#define ADDRESS DWORD
#else
#define SOCKET int
#define ADDRESS in_addr_t
// 3 Includes fr sockaddr_in
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#endif

#include "global.h"
#include "KeysPacket.h"
#include "gamestatus.h"


class Player
{
public:
	void calcNewGame();
	FlyingObject * abschussliste[30];
	bool logOn;
	bool endspiel();
	int version;
  int rotateToStartPosition(bool &thrust);
	int moveToStartPosition(bool &thrust);
	bool getEmergencyStatus();
  int  detectCollision(int &min_dist, int &min_dx, int &min_dy, int &futureFrame, bool &fire, bool lastFrameFired);
	int calcDrehwinkel();
  int fireAtAsteroid(int &min_dist, int &min_dx, int &min_dy, int &futureFrame, bool &fire, int i,bool lastFrameFired);
	int fireAtUFO(int &min_dist,int &min_dx, int &min_dy, int &future, bool &fire,bool lastFrameFired);
	int fireAt(int &min_dist,int &min_dx, int &min_dy, int &future, bool &fire,bool lastFrameFired);
	int fireNowAt(int &min_dist,int &min_dx, int &min_dy, int &future, bool &fire,bool lastFrameFired);
	int getNextAsteroid(int &min_dist,int &min_dx, int &min_dy, int &future);
  int selectAsteroid(bool &fire,bool lastFrameFired);

//	void setLogfile(FILE *fo);
//	FILE *fo;
	int calcShipDirY8();
	int calcShipDirX8();
	int calcSaucerDirY8();
	int calcSaucerDirX8();
	int calcShotDirY8(int nr);
	int calcShotDirX8(int nr);
	int calcAstDirY8(int nr);
	int calcAstDirX8(int nr);
	void Send(void);
	void Receive(int timeout);
  Player(SOCKET sd, ADDRESS server_ip, int version) :
    sd(sd),
    server_ip(server_ip),
    version(version) {
    game    = &gameHistory[0];
    oldgame = &gameHistory[255];
    ticker  = 0;
    logOn   = false;
  };
	void Run(void);
	void InterpretScreen(void);
	void InterpretScreen(FramePacket &packet, GameStatus **gameptr);
	void ReceivePacket(FramePacket &packet,int timeout);
	void SendPacket(KeysPacket &packet);
  void SendPacketName(char *PlayerName);
  GameStatus* getStatus(void);

  char keyString[7]; // nur fr logging
	GameStatus *oldgame; // zeigt auf letzten empfangenen Eintrag in gameHistory
	GameStatus *newgame; // zeigt auf den nchsten Eintrag in gameHistory
                       // berechnet aus olgame,game + keyping
	GameStatus gameHistory[256]; // die letzen GameStatus
	GameStatus gameFuture[16]; // hier noch auf zeiger umbauen
  KeysPacket keyHistory[256];



private:
	SOCKET sd;
	ADDRESS server_ip;
 	FramePacket frame;
	KeysPacket keys;
	GameStatus *game;    // zeigt auf aktuellen Eintrag in gameHistory

//	char prevframe;
	int ticker;

};

UINT FrameThread(LPVOID pParam);

#endif
