// player.cpp: Beispielspieler fr Asteroids
// Harald Bgeholz / c't

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include "stdafx.h"

#include <math.h>

#include "GameStatus.h"
#include "global.h"

GameStatus::GameStatus() {
  sumLostPackets = 0;
  nFrames        = 0;
  nLevelFrames   = 0;
  level          = 0;
  mode           = UNKNOWN;
};


// wird vor der Interpretation des Frame aufgerufen
// und setzt "statische" Werte zurck

void GameStatus::clear(void)
{
	ship_present   = false;
	saucer_present = false;
	nasteroidsK    = 0;     // Anzahl Asteroiden Klein
	nasteroidsM    = 0;     // Anzahl Asteroiden Mittel
	nasteroidsG    = 0;     // Anzahl Asteroiden Gro
	nasteroids     = 0;
	nshots         = 0;
  shipCount      = 0;
  score          = 0;
  message[0]     = '\0';
}


// wird vor der Interpretation des Frame aufgerufen
// und rettet "dynamische" Werte aus dem alten Status in den neuen
void GameStatus::copy(GameStatus *old)
{
	level   = old->level;
  mode    = old->mode;
  nFrames = old->nFrames;
  nLevelFrames        = old->nLevelFrames;
  sumLostPackets      = old->sumLostPackets;
  ship.thisWinkelbyte = old->ship.thisWinkelbyte;
}

int wrapX(int x) {
  if (x > 1023) return x - 1024;
  if (x < 0)    return x + 1024;
  return x;
}

int wrapY(int y) {
  if (y > 767) return y - 768;
  if (y < 0)   return y + 768;
  return y;
}

int normalizeX (int x) {
  if (x < -512) return x + 1024;
  if (x >  511) return x - 1024;
  return x;
}

int normalizeY (int y) {
  if (y < -384) return y + 768;
  if (y >  383) return y - 768;
  return y;
}

int normalizeX8 (int x) {
  if (x < -2048) return x + 4096;
  if (x >  2047) return x - 4096;
  return x;
}

int normalizeY8 (int y) {
  if (y < -1536) return y + 3072;
  if (y >  1535) return y - 3072;
  return y;
}


// Berechnung des Abstands eines Punktes von einer Geraden
// nicht absolut! positive und negative Ergebnisse mglich
// Punkt  ist Ortsvektor px,py
// Gerade ist Ortsvektor gx,gy und Richtungsvektor gvx, gvy
int abstandPunktGerade(int px, int py, int gx, int gy, int gvx, int gvy) {
  int tx = px - gx;
  int ty = py - gy;
  int kp;
  int sp;

  // kreuzprodukt
  kp = tx * gvy - ty * gvx;
  // skalarprodukt ohne wurzel
  // ist dann == 0, wenn Richtungsvektor == (0,0),
  // also die gerade ein Punkt war
  sp = gvx * gvx + gvy * gvy;

  if (sp > 0) {
    return kp / (int)sqrt(sp);
  }

  // sonst abstand beider Punkte
  return abstandPunktPunkt(px,py,gx,gy);

}


// Quadrat des Abstands zweier Punkte
// Punkt1 ist Ortsvektor x1,y1
// Punkt2 ist Ortsvektor x2,y2
int abstand2PunktPunkt (int x1,int y1,int x2, int y2) {
	int dx = x2 - x1;
	while (dx < -512) dx += 1024;
	while (dx >  511) dx -= 1024;
	int dy = y2 - y1;
	while (dy < -384) dy += 768;
	while (dy >  383) dy -= 768;
	return dx*dx+dy*dy;
}


// Abstand zweier Punkte
// Punkt1 ist Ortsvektor x1,y1
// Punkt2 ist Ortsvektor x2,y2
int abstandPunktPunkt (int x1,int y1,int x2, int y2) {
	int dx = x2 - x1;
	while (dx < -512) dx += 1024;
	while (dx >  511) dx -= 1024;
	int dy = y2 - y1;
	while (dy < -384) dy += 768;
	while (dy >  383) dy -= 768;
	return (int)sqrt(dx*dx+dy*dy);
}


// Abstand zweier Punkte
// Punkt1 ist Ortsvektor x1,y1
// Punkt2 ist Ortsvektor x2,y2
int abstandPunktPunkt8 (int x1,int y1,int x2, int y2) {
	int dx = x2 - x1;
	while (dx < -4096) dx += 8192;
	while (dx >  4095) dx -= 8192;
	int dy = y2 - y1;
	while (dy < -3072) dy += 6144;
	while (dy >  3071) dy -= 6144;
	return (int)sqrt(dx*dx+dy*dy);
}


// liegtPunktInKreis
// Punkt ist Ortsvektor x1,y1
// Kreismittelpunkt ist Ortsvektor kx,ky
// Radius des Kreises ist r
bool liegtPunktInKreis (int x1,int y1,int kx, int ky, int r) {
	int dx = x1 - kx;
//	while (dx < -512) dx += 1024;
//	while (dx >  511) dx -= 1024;
	int dy = y1 - ky;
//	while (dy < -384) dy += 768;
//	while (dy >  383) dy -= 768;
	return dx*dx + dy*dy <= r*r;
}


// Kreismittelpunkt ist Ortsvektor kx,ky
// Radius des Kreises ist r, Kreisradius r > 0
// Gerade ist Ortsvektor gx,gy und Richtungsvektor gvx, gvy
// Schnittpunkte in sx1,sy1 sx2,sy2 zurckgeben
// der returnwert enthlt die Anzahl der Schnittpunkte
int schnittpunktKreisGerade(int kx,int ky,int r,int gx,int gy,int gvx,int gvy,
                             int &sx1,int &sy1,int &sx2,int &sy2) {
  int a = abstandPunktGerade(kx, ky, gx, gy, gvx, gvy);
  if (r < abs(a)) { // kein Schnittpunkt
    return 0;
  }
  int b = (int)sqrt(r * r - a * a);
  // senkrechte auf geradenrichtungsvektor bilden
  int senkrechtx = -gvy;
  int senkrechty = gvx;
  int normg = (int)sqrt(gvx * gvx + gvy * gvy);
  int norms = (int)sqrt(senkrechtx * senkrechtx + senkrechty * senkrechty);
  int gbx;
  int gby;
  int gax;
  int gay;

  if (normg == 0 || norms == 0) {
    return 0;
  }

  if (a == 0) { //  Gerade luft durch den Mittelpunkt des Kreises
    if (b != 0) {
      gbx = (gvx*b)/normg;
      gby = (gvy*b)/normg;
      sx1 = kx + gbx;
      sy1 = ky + gby;
      sx2 = kx - gbx;
      sy2 = ky - gby;
      return 2;
    }
  } else {
    gax = (senkrechtx*a)/norms;
    gay = (senkrechty*a)/norms;
    if (b != 0) {
      gbx = (gvx*b)/normg;
      gby = (gvy*b)/normg;
      sx1 = kx + gax + gbx;
      sy1 = ky + gay + gby;
      sx2 = kx + gax - gbx;
      sy2 = ky + gay - gby;
      return 2;
    } else {  // nur ein Schnittpunkt Tangente
      sx1 = kx + gax;
      sy1 = ky + gay;
      sx2 = sx1;
      sy2 = sy1;
      return 1;
    }
  }
  return 0;

}


// diese Methode wird auf einem ALTEN Gamestatus aufgerufen,
// um einen Schuss aus dem AKTUELLEN Gamestatus wieder zu finden.
// frames: Anzahl der Frames, die zwischen alt und neu liegen, normalerweise 1
int GameStatus::findShot(int x, int y, int frames)
{
  int i        = 0;

  // nur ein schuss vorhanden
  if (nshots == 1) {
    // schon mal gesehen, nicht? dann Annahme gefunden
    if (shots[i].dx == 0 && shots[i].dy == 0) {
      return i; 
    }
  }

  for (i=0;i<nshots;i++) {
    // erst mal die bekannten tracken
    if (shots[i].refindex == -1) {
      continue;
    }
    if ( abs(normalizeX(shots[i].x + (shots[i].dx8 * frames)/8 - x)) < 2
      && abs(normalizeY(shots[i].y + (shots[i].dy8 * frames)/8 - y)) < 2) {
      return i;
    }
  }

  // haben wir keinen passenden shot gefunden, nehmen wir
  // einen der briggebliebenen
  for (i=0;i<nshots;i++) {
    if (shots[i].refindex == -1) {  /// maximale schuss geschwindigkeit 111/8 Frames
      if ( abs(normalizeX(shots[i].x + (14 * frames) - x)) < 1+14*(frames+1)
        && abs(normalizeY(shots[i].y + (14 * frames) - y)) < 1+14*(frames+1)) {
        return i;
      }
    }
  }

  // sonst nicht gefunden
  return -1;
}


void GameStatus::addAsteroid(int x, int y, int type, int sf)
{
  asteroids[nasteroids++].set(x, y, type, sf);
  switch (sf) { // 0 = gro, 15 = mittel, 14 = klein
  case 14: nasteroidsK++;
    break;
  case 15: nasteroidsM++;
    break;
  case  0: nasteroidsG++;
    break;
  }
}


// diese Methode wird auf einem ALTEN Gamestatus aufgerufen,
// um einen Asteroiden aus dem AKTUELLEN Gamestatus wieder zu finden.
int GameStatus::findAsteroid(int x, int y, int type, int sf, int frames)
{
  int i;
  int anzahl = 0;
  int index  = -1;

/*
  // suchen ueber type und size
  for (i=0;i<nasteroids;i++) {
    if ( asteroids[i].type == type 
      && asteroids[i].sf == sf) {
      anzahl++;
      index = i;
    }
  }

  // wenn nur einer gefunden, dann diesen nehmen
  if (anzahl == 1) {
    return index;
  }
*/

  for (i=0;i<nasteroids;i++) {
    if ( asteroids[i].type == type 
      && asteroids[i].sf == sf
      && (abs(normalizeX(asteroids[i].x + (asteroids[i].dx8*frames)/8 - x))) < 2
      && (abs(normalizeY(asteroids[i].y + (asteroids[i].dy8*frames)/8 - y))) < 2) {
      return i;
    }
  }

  for (i=0;i<nasteroids;i++) { // maximale geschwindigkeit 32/8 Pixel/Frame
    if ( asteroids[i].type == type 
      && asteroids[i].sf == sf
      && (abs(normalizeX(asteroids[i].x + (4*frames) - x))) < 1+4*(frames+1)
      && (abs(normalizeY(asteroids[i].y + (4*frames) - y))) < 1+4*(frames+1)) {
      return i;
    }
  }
  return -1;
}



void GameStatus::setSaucer(int x, int y, int size)
{
  saucer_present = true;
  saucer.x  = x;
	saucer.y  = y - 128;
  saucer.dx = 0;
	saucer.dy = 0;
	saucer.sf = size;
  if (size == 15) {
    saucer.sfc = 'M';
  } else {
    saucer.sfc = 'K';
  }

}

void GameStatus::setShip(int x, int y, int bx, int by)
{
	ship_present = true;
	ship.x  = x;
	ship.y  = y - 128;
	ship.bx = bx;
	ship.by = by;
  ship.dx = 0;
  ship.dy = 0;

}

bool GameStatus::isThrustEnabled()
{
  return jmpl == 0xE2;
}
