// KeysPacket.h: Schnittstelle fr die Klasse KeysPacket.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_KEYSPACKET_H__238EF165_79D4_460A_A928_EF9F9BC54401__INCLUDED_)
#define AFX_KEYSPACKET_H__238EF165_79D4_460A_A928_EF9F9BC54401__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

static const char KEY_HYPERSPACE = 0x01;
static const char KEY_FIRE       = 0x02;
static const char KEY_THRUST     = 0x04;
static const char KEY_RIGHT      = 0x08;
static const char KEY_LEFT       = 0x10;
static const char KEY_START      = 0x20;

#pragma pack(1)
struct FramePacket
{
	char vectorram[1024];
	unsigned char frameno;  // wird bei jedem Frame inkrementiert
	unsigned char ping;     // Der Server schickt das letzte empfangene ping-Byte zurck
};


class KeysPacket
{
private:
	char signature[6];
public:
	char keys;
	unsigned char ping;   // wird vom Server bei nchster Gelegenheit zurckgeschickt. Fr Latenzmessung.

	KeysPacket(void);
  int  drehung(void);       // +1 left, 0 sonst ; -1 right
	void clear(void);         // alle Tasten loslassen
	void hyperspace(bool b);  // Hyperspace drcken (true) oder loslassen (false)
	void fire(bool b);        // Feuerknopf drcken (true) oder loslassen (false)
	bool getFire();
	void thrust(bool b);      // Beschleunigen ...
	void right(bool b);       // rechts drehen ...
	void left(bool b);        // links drehen
	void start(bool b);       // starttaste
  void getKeysAsString(char keyString[7] );
};
#pragma pack()


#endif // !defined(AFX_KEYSPACKET_H__238EF165_79D4_460A_A928_EF9F9BC54401__INCLUDED_)
