package core;

import core.asteroid.Ship;


public class KeyControl {
	
	private static final int KEY_MASK_HYPERSPACE	= 0x01;
	private static final int KEY_MASK_SHOT			= 0x02;
	private static final int KEY_MASK_ACCELERATE	= 0x04;
	private static final int KEY_MASK_TURN_RIGHT	= 0x08;
	private static final int KEY_MASK_TURN_LEFT		= 0x10;
	private static final int KEY_MASK_START			= 0x20;
	
	public static final int KEY_HYPERSPACE	= 0;
	public static final int KEY_SHOT		= 1;
	public static final int KEY_ACCELERATE	= 2;
	public static final int KEY_TURN_RIGHT	= 3;
	public static final int KEY_TURN_LEFT	= 4;
	public static final int KEY_START		= 5;
	
	
	private MameClient mame;
	private int[][] pressReleaseTimes;
	private int[] turnTicks;
	private int keyMask;
	
	
	KeyControl(MameClient mame) {
		pressReleaseTimes = new int[6][2];
		initKeyStates();
		turnTicks = new int[10];
		for(int i=0; i<turnTicks.length; i++) {
			turnTicks[i] = 0;
		}
		
		this.mame = mame;
	}
	
	
	private void initKeyStates() {
		keyMask = 0;
		for(int i=0; i<pressReleaseTimes.length; i++) {
			pressReleaseTimes[i][0] = -1;
			pressReleaseTimes[i][1] = -1;
		}
	}
	
	
	private void pressKey(int key) {
		switch(key) {
		case KEY_HYPERSPACE: keyMask |= KEY_MASK_HYPERSPACE; 	break;
		case KEY_SHOT:		 keyMask |= KEY_MASK_SHOT;		 	break;
		case KEY_ACCELERATE: keyMask |= KEY_MASK_ACCELERATE; 	break;
		case KEY_TURN_RIGHT: keyMask |= KEY_MASK_TURN_RIGHT; 	break;
		case KEY_TURN_LEFT:	 keyMask |= KEY_MASK_TURN_LEFT;	 	break;
		case KEY_START:		 keyMask |= KEY_MASK_START;		 	break;
		}
		mame.setKeyMask(keyMask);
	}
	
	
	private void releaseKey(int key) {
		switch(key) {
		case KEY_HYPERSPACE: keyMask &= ~KEY_MASK_HYPERSPACE;	break;
		case KEY_SHOT:		 keyMask &= ~KEY_MASK_SHOT;			break;
		case KEY_ACCELERATE: keyMask &= ~KEY_MASK_ACCELERATE;	break;
		case KEY_TURN_RIGHT: keyMask &= ~KEY_MASK_TURN_RIGHT;	break;
		case KEY_TURN_LEFT:	 keyMask &= ~KEY_MASK_TURN_LEFT;	break;
		case KEY_START:		 keyMask &= ~KEY_MASK_START;		break;
		}
		mame.setKeyMask(keyMask);
	}
	
	
	public void pressKey(int key, int delay, int duration) {
		if(key == KEY_HYPERSPACE) {
			initKeyStates();
		}
		pressReleaseTimes[key][0] = delay;
		pressReleaseTimes[key][1] = delay+duration;
	}
	
	
	public int getPrevTurnTicks(int latency) {
		int ticks = 0;
		// Bei einer Latenz von 1 ist die Drehung in den letzten beiden Frames interessant
		for(int i=turnTicks.length-1; i>turnTicks.length-2-latency && i > 0; i--) {
			ticks += turnTicks[i];
		}
		return ticks;
	}

	
	public void setKeys(int packetIncrement) {
		int f = packetIncrement;
		
		for(int i=0; i<pressReleaseTimes.length; i++) {
			if(pressReleaseTimes[i][0] >= 0 && pressReleaseTimes[i][0] - f < 0) {
				// Taste drcken
				pressKey(i);
			}
			if(pressReleaseTimes[i][1] >= 0 && pressReleaseTimes[i][1] - f < 0) {
				// Taste loslassen
				releaseKey(i);
			}
			if(pressReleaseTimes[i][0] >= 0) pressReleaseTimes[i][0] -= f;
			if(pressReleaseTimes[i][1] >= 0) pressReleaseTimes[i][1] -= f;
		}
		
		if((keyMask & KEY_MASK_TURN_LEFT) != 0 && (keyMask & KEY_MASK_TURN_RIGHT) != 0) {
			releaseKey(KEY_TURN_RIGHT);
		}

		/*Ship ship = objects.getShip();
		if(ship == null) {
			releaseKey(KEY_TURN_LEFT);
			releaseKey(KEY_TURN_RIGHT);
		}*/
		
		for(int i=0; i<turnTicks.length-1; i++) turnTicks[i] = turnTicks[i+1];
		if((keyMask & KEY_MASK_TURN_LEFT) != 0) {
			turnTicks[turnTicks.length-1] = -1;
			Ship.tickLeft();
		} else if((keyMask & KEY_MASK_TURN_RIGHT) != 0) {
			turnTicks[turnTicks.length-1] = 1;
			Ship.tickRight();
		} else {
			turnTicks[turnTicks.length-1] = 0;
		}
	}
	
}
