package core.bot;

import java.util.Vector;

import util.MameFrameListener;
import util.Statistics;
import util.Vector2D;
import core.GameInfo;
import core.KeyControl;
import core.MameClient;
import core.asteroid.AsteroidObject;
import core.asteroid.Ship;
import core.opCodes.OpLocation;

public class AsteroidBot extends Thread implements MameFrameListener {

	private KeyControl keyCtrl;
	private boolean stopRequested;
	private boolean processing;
	private int droppedFrames;
	
	//private boolean initTest = true;
	
	//private MameClient mame;
	private GameInfo objInfo;
	private TargetSolution target;
	private TargetAcquisition targetAc;
	
	
	public AsteroidBot(MameClient mame) {
		//this.mame = mame;
		keyCtrl = mame.getKeyControl();
		
		stopRequested = false;
		processing = false;
		droppedFrames = 0;
		
		targetAc = new TargetAcquisition(mame);
		
		setPriority(Thread.MAX_PRIORITY);
		start();

		mame.addAsteroidFrameListener(this);
	}
	
	
	public void run() {
		int jumpCount = 0;
		
		while(!stopRequested) {
			try {
				// aufs nchste Frame warten
				waitForFrameData();
				if(stopRequested) {
					break;
				}
				
				// Feuerleitlsungen aktualisieren
				updateSolutions();
				
				if(objInfo.isShipPresent()) {
					Ship ship = objInfo.getShip();
	
					// Kollision nur noch mit Hyperjump vermeidbar?
					boolean jump = false;
					Vector<AsteroidObject> colObjs = objInfo.getCollisionObjects();
					for(int i=0; i<colObjs.size(); i++) {
						AsteroidObject co = colObjs.get(i);
						if(co.getCollisionTime() < 3+objInfo.getLatency()) {
							// Das Objekt wird wohl treffen lieber hyperjumpen...
							keyCtrl.pressKey(KeyControl.KEY_HYPERSPACE, 0, 2);
							jump = true;
							if(jump && jumpCount == 0) {
								jumpCount = 10;
								float jumps = Statistics.getFloat(Statistics.KEY_HYPERJUMPS);
								Statistics.putFloat(Statistics.KEY_HYPERJUMPS, jumps+1);
							}
						}
					}
					if(jumpCount > 0) jumpCount--;
					
					if(!jump) {
						Vector2D shipDir = Ship.getCurrentShotDirection();
						if(shipDir != null) {
							ship.checkDirection(keyCtrl, objInfo.getLatency());
							
							// Sind noch angreifbare Ziele vorhanden?
							boolean fly = false;
							boolean steer = false;
							if(objInfo.getDestroyableObjects().size() < 3) {
								fly = true;
							}
							if(objInfo.getDestroyableObjects().size() == 0) {
								steer = true;
							}
							
							// angreifen
							attack();
							// zum nchsten Rand drehen
							if(steer) {
								turnToNearestBorder();
							}
							// Richtung Mitte fliegen
							if(fly) {
								//flyToCenter(steer);
							}
							
						} else {
							ship.initDirection(keyCtrl);
						}
					}
					
				}
				
			} catch(Exception e) {
				e.printStackTrace();
			}
		}
	}
	
	
	private void attack() {
		Ship ship = objInfo.getShip();
		if(ship == null) {
			System.out.println("[attack()] ship == null");
			return;
		}
		
		Vector<AsteroidObject> colObjs = objInfo.getCollisionObjects();
		for(int i=0; i<colObjs.size(); i++) {
			AsteroidObject co = colObjs.get(i);
			if(co.isDestroyable() && co.getCollisionTime() < 50 &&
					 co.getHitTime() == 0 && !co.isHitPreliminary()) {
				// langsam wirds eng - aktuelles ziel ndern
				target = co.getTargetSolution();
			}
		}
		
		//if(target == null) {
			// Bei Bedarf neues Ziel suchen
			target = targetAc.getBestTarget(objInfo);
		//}
		
		if(target != null) {
			if(objInfo.getDestroyableObjects().contains(target.target)) {
				// Ziel angreifen bis es getroffen ist
				target = targetAc.fliegenUndToeten(target, objInfo);
			} else {
				// Ziel ist weg...
				target = null;
			}
		}
		
		/*Vector2D loc = new Vector2D(ship.getLocation().x, ship.getLocation().y);
		Vector2D vs = ship.getVelocity();
		if(objInfo.accelerate(loc, ship.getCurrentShotDirection(), vs) && vs.getLength() < 1) {
			keyCtrl.pressKey(KeyControl.KEY_ACCELERATE, 0, 1);
		}*/
	}
	
	
	private void turnToNearestBorder() {
		Ship ship = objInfo.getShip();
		if(ship == null) {
			System.out.println("[turnToNearestCorner()] ship == null");
			return;
		}
		
		OpLocation ls = ship.getLocation();
		Vector2D v = new Vector2D();
		Vector2D dir = new Vector2D();
		float min = 10000;

		for(int i=0; i<4; i++) {
			switch(i) {
			case 0:
				v.x = 0    - ls.x;
				v.y = 768  - ls.y;
				break;
			case 1:
				v.x = 1024 - ls.x;
				v.y = 768  - ls.y;
				break;
			case 2:
				v.x = 0    - ls.x;
				v.y = 0    - ls.y;
				break;
			case 3:
				v.x = 1024 - ls.x;
				v.y = 0    - ls.y;
				break;
			}
			float f = v.getLength();
			if(f < min) {
				min = f;
				dir.x = v.x;
				dir.y = v.y;
			}
		}

		float s = ship.getVelocity().getLength();
		float maxS = (min - 250) / 400.0f;
		
		Vector2D x = Ship.getNearestAngle(dir, Ship.RANGE_360);
		int ticks = Ship.getTurnTicks(x);
		if(ticks > 0) {
			keyCtrl.pressKey(KeyControl.KEY_TURN_LEFT, 0, 1);
		} else if(ticks < 0) {
			keyCtrl.pressKey(KeyControl.KEY_TURN_RIGHT, 0, 1);
		} else if(min > 200 && s < maxS) {
			keyCtrl.pressKey(KeyControl.KEY_ACCELERATE, 0, 1);
		}
	}
	
	
	private void flyToCenter(boolean steer) {
		Ship ship = objInfo.getShip();
		if(ship == null) {
			System.out.println("[flyToCenter()] ship == null");
			return;
		}
		
		Vector2D ps = new Vector2D(ship.getLocation().x, ship.getLocation().y);
		Vector2D v = ship.getVelocity();
		float s = v.getLength();
		
		// Richtung und Entfernung zur Mitte ermitteln
		Vector2D a = new Vector2D(512-ps.x, 384-ps.y);
		Vector2D b = Ship.getNearestAngle(a, Ship.RANGE_360);
		float dist = a.getLength();
		
		// In diese Richtung drehen
		int ticks = Ship.getTurnTicks(b);
		if(Math.abs(ticks) <= 1 && dist > 150 && s < 0.8f) {
			// In Richtung Mitte beschleunigen
			keyCtrl.pressKey(KeyControl.KEY_ACCELERATE, 0, 1);
		} else if(steer) {
			// In Richtung Mitte drehen
			if(ticks > 0) {
				keyCtrl.pressKey(KeyControl.KEY_TURN_LEFT, 0, 1);
			} else {
				keyCtrl.pressKey(KeyControl.KEY_TURN_RIGHT, 0, 1);
			}
		}
	}
	
	
	private void updateSolutions() {
		int latency = objInfo.getLatency();
		Ship s = objInfo.getShip();
		if(s != null) {
			Vector<AsteroidObject> dobjs = objInfo.getDestroyableObjects();
			for(int i=0; i<dobjs.size(); i++) {
				AsteroidObject o = dobjs.get(i);
				o.updateTargetSolution(s, latency);
			}
		}
	}
	
	
	/*private int ticks = 0;
	private void test(Ship ship) {
		long time = ticks++;

		keyCtrl.pressKey(KeyControl.KEY_TURN_LEFT, 0, 2);

		if(time % 30 == 15) {
			Shot s = objInfo.getNearestShipShot();
			System.out.println(" --> " + s.getVelocity());
		} else if(time % 30 == 0) {
			keyCtrl.pressKey(KeyControl.KEY_SHOT, 0, 1);
			System.out.print("Schussrichtung: " + ship.getCurrentShotDirection());
		}
	}*/
	
	
	private synchronized void waitForFrameData() {
		processing = false;
		try {
			wait();
		} catch(InterruptedException e) {
			e.printStackTrace();
		}
		processing = true;
	}
	
	
	public synchronized void requestStop() {
		stopRequested = true;
		notify();
	}
	
	
	public TargetSolution getTargetSolution() {
		if(target != null) {
			return targetAc.getLastSolution();
		} else {
			return null;
		}
	}


	public int getDroppedFrames() {
		return droppedFrames;
	}


	public void mameFrameReceived(GameInfo objs) {
		if(processing) {
			// Die letzte Berechnung luft noch...
			droppedFrames++;
			Statistics.putFloat(Statistics.KEY_DROPPED_FRAMES, droppedFrames);
		} else {
			objInfo = objs;
			//targetAc.updateData(objs);
			// Berechnung starten
			synchronized(this) {
				notify();
			}
		}
	}
}
