package util;

public class InterceptCalculator {

	public static Vector2D calculateIntercept(Vector2D p1, Vector2D v1, Vector2D p2, Vector2D v2) {
		float a[][] = new float[2][3];
		a[0][0] = v1.x;	a[0][1] = v2.x;	a[0][2] = p2.x-p1.x;
		a[1][0] = v1.y;	a[1][1] = v2.y;	a[1][2] = p2.y-p1.y;
		
		if(gaussJordan(a)) {
			float t = a[0][2];
			Vector2D x = new Vector2D(v1.x, v1.y);
			x.multiply(t);
			x.add(p1);
			return x;
		} else {
			return null;
		}
	}
	
	
	public static void main(String args[]) {
		Vector2D p1 = new Vector2D(1, 3);
		Vector2D v1 = new Vector2D(2, 1);
		Vector2D p2 = new Vector2D(8, 2);
		Vector2D v2 = new Vector2D(1, -1);
		
		System.out.println(calculateIntercept(p1, v1, p2, v2));
	}
	
	
	/*private static void printMatrix(float[][] m) {
		for(int i=0; i<m.length; i++) {
			for(int j=0; j<m[i].length; j++) {
				System.out.printf("%6.2f", m[i][j]);
			}
			System.out.println();
		}
		System.out.println();
	}*/
	
	
	public static boolean gaussJordan(float[][] matrix) {
		if(matrix.length == 0 || matrix[0].length == 0) return false;
		if(matrix.length != matrix[0].length-1) return false;
		
		for(int rowPos=0; rowPos<matrix.length; rowPos++) {
			int colPos = nextCol(matrix, rowPos);
			normRow(matrix, colPos, rowPos);
			zeroValues(matrix, colPos, rowPos);
		}
		
		for(int i=0; i<matrix.length; i++) {
			boolean nonZero = false;
			for(int j=0; j<matrix[i].length-1; j++) {
				if(matrix[i][j] != 0) {
					nonZero = true;
					break;
				}
			}
			if(!nonZero) return false;
		}
		return true;
	}
	
	
	private static int nextCol(float[][] matrix, int rowPos) {
		int colPos = 0;
		boolean colSelected = false;
		
		while(!colSelected) {
			for(int i=rowPos; i<matrix.length; i++) {
				if(matrix[i][colPos] != 0) {
					colSelected = true;
					if(i != rowPos) swapRows(matrix, rowPos, i);
					break;
				}
			}
			if(!colSelected) colPos++;
		}
		return colPos;
	}
	
	
	private static void swapRows(float[][] matrix, int row1, int row2) {
		float[] temp = matrix[row1];
		matrix[row1] = matrix[row2];
		matrix[row2] = temp;
	}
	
	
	private static void normRow(float[][] matrix, int colPos, int rowPos) {
		float fac = matrix[rowPos][colPos];
		for(int i=colPos; i<matrix[rowPos].length; i++) {
			matrix[rowPos][i] /= fac;
		}
	}
	
	
	private static void zeroValues(float[][] matrix, int colPos, int rowPos) {
		for(int i=0; i<matrix.length; i++) {
			if(i != rowPos) {
				float fac = matrix[i][colPos];
				for(int j=colPos; j<matrix[i].length; j++) {
					matrix[i][j] -= matrix[rowPos][j] * fac;
				}
			}
		}
	}
}
