package util;


public class Statistics {

	public static final int KEY_TIME 			= 0;
	public static final int KEY_SCORE 			= 1;
	public static final int KEY_SCORE_PER_MIN	= 2;
	public static final int KEY_LIFES 			= 3;
	public static final int KEY_DEATHS 			= 4;
	public static final int KEY_KILLS 			= 5;
	public static final int KEY_ALIVE_SHOTS		= 6;
	public static final int KEY_ASTEROIDS		= 7;
	public static final int KEY_SHOTS 			= 8;
	public static final int KEY_WAVE			= 9;
	public static final int KEY_HIT_RATE 		= 10;
	public static final int KEY_GAME_MODE		= 11;
	public static final int KEY_FPS				= 12;
	public static final int KEY_DROPPED_FRAMES 	= 13;
	public static final int KEY_LOST_PACKETS	= 14;
	public static final int KEY_HYPERJUMPS		= 15;
	public static final int KEY_LATENCY			= 16;
	public static final int KEY_SYNC_LOST_CNT	= 17;
	public static final int KEY_LOOP_CNT		= 18;
	public static final int KEY_METHOD_CNT		= 19;
	

	public static Object[] stats = new Object[20];
	static {
		reset();
	}
	
	
	public static void put(int key, Object value) {
		stats[key] = value;
	}
	
	
	public static void putFloat(int key, float value) {
		stats[key] = value;
	}
	
	
	public static Object get(int key) {
		return stats[key];
	}
	
	
	public static float getFloat(int key) {
		float f = 0;
		try {
			Float fl = (Float)stats[key];
			if(fl != null) f = fl;
		} catch(ClassCastException e) {
			System.out.println(e + "\nkey=" + key);
		}
		return f;
	}
	
	
	public static String getFormattedValue(int key) {
		return getFormattedValue(key, get(key));
	}
	
	
	public static String getFormattedValue(int key, Object val) {
		String value = "";
		
		switch(key) {
		case Statistics.KEY_TIME:
			int s = (int)((Float)val/60);
			value = String.format("%02d:%02d", s/60, s%60);
			break;
		case Statistics.KEY_SCORE:
			value = String.format("%.0f", val);
			break;
		case Statistics.KEY_SCORE_PER_MIN:
			value = String.format("%.0f", val);
			break;
		case Statistics.KEY_WAVE:
			value = String.format("%.0f", val);
			break;
		case Statistics.KEY_LIFES:
			value = String.format("%.0f", val);
			break;
		case Statistics.KEY_DEATHS:
			value = String.format("%.0f", val);
			break;
		case Statistics.KEY_HYPERJUMPS:
			value = String.format("%.0f", val);
			break;
		case Statistics.KEY_KILLS:
			value = String.format("%.0f", val);
			break;
		case Statistics.KEY_SHOTS:
			value = String.format("%.0f", val);
			break;
		case Statistics.KEY_ALIVE_SHOTS:
			value = String.format("%.0f", val);
			break;
		case Statistics.KEY_ASTEROIDS:
			value = String.format("%.0f", val);
			break;
		case Statistics.KEY_HIT_RATE:
			value = String.format("%.1f%%", val);
			break;
		case Statistics.KEY_GAME_MODE:
			value = "" + val;
			break;
		case Statistics.KEY_FPS:
			value = String.format("%.1f", val);
			break;
		case Statistics.KEY_DROPPED_FRAMES:
			value = String.format("%.0f", val);
			break;
		case Statistics.KEY_LOST_PACKETS:
			value = String.format("%.0f", val);
			break;
		case Statistics.KEY_LATENCY:
			value = String.format("%.0f", val);
			break;
		default:
			value = String.format("%.0f", val);
			break;
		}
		return value;
	}
	
	
	public static void reset() {
		putFloat(KEY_TIME, 0);
		putFloat(KEY_SCORE, 0);
		putFloat(KEY_SCORE_PER_MIN, 0);
		putFloat(KEY_LIFES, 0);
		putFloat(KEY_DEATHS, 0);
		putFloat(KEY_KILLS, 0);
		putFloat(KEY_ALIVE_SHOTS, 0);
		putFloat(KEY_ASTEROIDS, 0);
		putFloat(KEY_SHOTS, 0);
		putFloat(KEY_WAVE, 0);
		putFloat(KEY_HIT_RATE, 0);
		put(KEY_GAME_MODE, "Demo");
		putFloat(KEY_LATENCY, 0);
		putFloat(KEY_FPS, 0);
		putFloat(KEY_DROPPED_FRAMES, 0);
		putFloat(KEY_LOST_PACKETS, 0);
		putFloat(KEY_HYPERJUMPS, 0);
		putFloat(KEY_SYNC_LOST_CNT, 0);
		putFloat(KEY_METHOD_CNT, 0);
		putFloat(KEY_LOOP_CNT, 0);
	}
}
