package core.asteroid;

import java.awt.Color;
import java.util.ArrayList;

import util.IntAvgBuffer;

import core.opCodes.OpLocation;
import core.opCodes.OpVector;

public class Ufo extends AsteroidObject {
	
	public static final int SIZE_LARGE	= 1;
	public static final int SIZE_SMALL	= 2;
	
	
	private int size;
	

	public Ufo(OpLocation location, ArrayList<OpVector> vectors) {
		super(location, vectors);
		
		vxb = new IntAvgBuffer(1);
		vyb = new IntAvgBuffer(1);
		
		if(hitRadius < 20) size = SIZE_SMALL;
		else size = SIZE_LARGE;
	}
	
	
	@Override
	public boolean isMatching(AsteroidObject obj, int frameDif) {
		// Es gibt immer nur ein Ufo...
		if(obj instanceof Ufo) {
			return true;
		} else {
			return false;
		}
	}
	
	
	public String getObjectName() {
		return "Ufo";
	}


	public Color getDefaultColor() {
		return Color.LIGHT_GRAY;
		//return new Color(192, 96, 0);
	}
	
	
	public boolean isDestroyable() {
		return true;
	}
	
	
	public boolean hasCollision() {
		return true;
	}
	
	
	public int getSize() {
		return size;
	}
}
