package core.bot;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;

import util.Vector2D;

import core.GameInfo;
import core.KeyControl;
import core.MameClient;
import core.asteroid.Asteroid;
import core.asteroid.AsteroidObject;
import core.asteroid.Ship;
import core.asteroid.Ufo;

public class TargetAcquisition extends Thread {
	
	private ArrayList<TargetSolution> targets;
	
	private KeyControl keyCtrl;
	private TargetSolution lastSolution;
	
	
	public TargetAcquisition(MameClient client) {
		keyCtrl = client.getKeyControl();
		targets = new ArrayList<TargetSolution>(27);
	}
	

	public TargetSolution getBestTarget(GameInfo objs) {
		Vector<AsteroidObject> objects = objs.getDestroyableObjects();
		Ship ship = objs.getShip();
		if(ship == null) return null;
		
		targets.clear();
		int targetCnt = objects.size();
		
		for(int i=0; i<objects.size(); i++) {
			AsteroidObject o;
			try {
				o = objects.get(i);
			} catch(ArrayIndexOutOfBoundsException e) {
				// bekackte Thread Programmierung...
				break;
			}
			
			TargetSolution s = o.getTargetSolution();
			
			if(s == null || !s.legal) continue;
			
			int time = Math.abs(s.turnTicks) + s.shotDelay;
			int destroyTime = s.destroyTime;
			
			int nextShotTime = objs.getNextShotAvailableTime();
			s.score = 0;
			if(time >= nextShotTime) {
				// Nur Ziele whlen bei denen man nicht auf freien Schuss Slot warten muss
				s.score = 100 - (int)Math.sqrt(destroyTime * time);
			}
			
			// Wie nah ist das nchste Ziel zum Treffzeitpunkt?
			s.score += 50 - calcDistOnHit(objs, s) / 10;
			
			/*if(o instanceof Asteroid) {
				Asteroid a = (Asteroid)o;
				int curShotCnt = objs.getCurrentShotCount();
				if(a.getSize() != Asteroid.SIZE_SMALL && curShotCnt > 1) {
					// bei mittleren und groen Asteroiden sollten mind. 3 Schsse verfgbar sein
					s.score -= 50;
				}
			}*/
			
			if(o.getCollisionTime() > 0 && o.getCollisionTime() < 125) {
				s.score += 200 - o.getCollisionTime();
			}
			
			if(o instanceof Ufo && targetCnt > 3) {
				Ufo u = (Ufo)o;
				// Schei auf die groen Ufos...
				if(u.getSize() == Ufo.SIZE_SMALL) {
					s.score += 200;
				}
			}
			
			if(o.getHitTime() > 0) {
				s.score = 0;
			}
			
			if(s.shotTime > 69) {
				s.score = 0;
			}
			
			if(s.legal) {
				targets.add(s);
			}
		}

		if(targets.size() > 0) {
			Collections.sort(targets);
			return targets.get(0);
		} else {
			return null;
		}
	}
	
	
	private float calcDistOnHit(GameInfo objs, TargetSolution sol) {
		AsteroidObject t = sol.target;
		Vector<AsteroidObject> objects = objs.getDestroyableObjects();
		float minDist = 0;
		float avgDist = 0;
		
		int time = Math.abs(sol.turnTicks) + sol.shotDelay;
		
		Vector2D vt = t.getVelocity();
		float tx = t.getLocation().x + vt.x * time;
		float ty = t.getLocation().y + vt.y * time;
		
		int n=0;
		for(int i=0; i<objects.size(); i++) {
			AsteroidObject o;
			try {
				o = objects.get(i);
			} catch(ArrayIndexOutOfBoundsException e) {
				// bekackte Thread Programmierung...
				break;
			}
			
			if(t == o) continue;

			Vector2D vo = t.getVelocity();
			float ox = o.getLocation().x + vo.x * time;
			float oy = o.getLocation().y + vo.y * time;
			
			float dx = ox - tx;
			float dy = oy - ty;
			
			if(dx > 512) dx = 1024 - dx;
			if(dx < -512) dx = dx + 1024;
			if(dy > 384) dy = 768 - dy;
			if(dy < -384) dy = dy + 768;
			
			float dist = (float)Math.sqrt(dx * dx + dy * dy);
			if(dist < minDist) minDist = dist;
			avgDist += dist;
			n++;
		}
		
		if(n > 0) avgDist /= n;
		else avgDist = 0;
		
		return avgDist;
	}
	
	
	private int lastShot = 3;
	private int shotCnt = 0;
	private int delay = 0;
	public TargetSolution fliegenUndToeten(TargetSolution targetSol, GameInfo objs) {
		Ship ship = objs.getShip();
		TargetSolution nextTarget = targetSol;
		
		if(ship == null || targetSol == null || !targetSol.legal) {
			if(!targetSol.legal) {
				//System.out.println("[fliegenUndToeten()] targetSol not legal");
				// anderes Ziel nehmen
				nextTarget = null;
			}
			return nextTarget;
		}
		
		lastShot++;
		delay--;

		int curShotCnt = objs.getCurrentShotCount();
		
		// Irgend ein Ziel auf dem Drehweg das man mitnehmen kann?
		// Ein Schuss frs eigentlich Ziel muss aber brig bleiben
		if(curShotCnt < 3 && lastShot > 1) {
			Vector<AsteroidObject> targets = objs.getDestroyableObjects();
			for(int i=0; i<targets.size(); i++) {
				AsteroidObject a;
				try {
					a = targets.get(i);
				} catch(ArrayIndexOutOfBoundsException e) {
					// bekackte Thread Programmierung...
					break;
				}
				TargetSolution s = a.getTargetSolution();
				if(s == null || !s.legal ||
						s.target.getHitTime() > 0 ||
						s == targetSol)
					continue;
				
				if(s.turnTicks == 0 && s.shotDelay == 0) {
					lastShot = 0;
					keyCtrl.pressKey(KeyControl.KEY_SHOT, 0, 1);
					s.score = 0;
					s.target.setHitPreliminary(true);
				}
			}
		}
		
		// Angreifen
		if(targetSol.turnTicks == 0) {
			if(curShotCnt < 4 && lastShot > 1) {
				Asteroid a = null;
				if(targetSol.target instanceof Asteroid) {
					a = (Asteroid)targetSol.target;
				}
				
				keyCtrl.pressKey(KeyControl.KEY_SHOT, targetSol.shotDelay, 1);
				delay = targetSol.shotDelay;
				targetSol.score = 0;
				shotCnt++;
				lastShot = 0;
				
				boolean newTarget = true;
				if(a != null) {
					if(a.getSize() != Asteroid.SIZE_SMALL && curShotCnt < 3) {
						if(a.getSize() == Asteroid.SIZE_LARGE && shotCnt < 4) {
							newTarget = false;
						} else if(a.getSize() == Asteroid.SIZE_MEDIUM && shotCnt < 3) {
							newTarget = false;
						}
					}
				}
				
				// Neues Ziel suchen
				if(newTarget) {
					shotCnt = 0;
					targetSol.target.setHitPreliminary(true);
					nextTarget = getBestTarget(objs);
					if(nextTarget == null) return null;
				}
			}
		}

		if(targetSol.legal && delay <= 0) {
			if(targetSol.turnTicks > 0) {
				keyCtrl.pressKey(KeyControl.KEY_TURN_LEFT, 0, 1);
			} else if(targetSol.turnTicks < 0) {
				keyCtrl.pressKey(KeyControl.KEY_TURN_RIGHT, 0, 1);
			}
		}
		
		return nextTarget;
	}
	
	
	public TargetSolution getLastSolution() {
		return lastSolution;
	}
	
	
	/*public TargetSolution calcSolution(Ship ship, AsteroidObject target) {
		TargetSolution solution = null;

		Vector2D ls = new Vector2D(ship.getLocation().x, ship.getLocation().y);
		Vector2D lx = new Vector2D(target.getLocation().x, target.getLocation().y);
		Vector2D vx = target.getVelocity();
		
		// Direkter Schusswinkel
		Vector2D so = new Vector2D(lx.x-ls.x, lx.y-ls.y);
		// Bestmglicher erreichbarer Schusswinkel
		int sbi = ship.getNearestAngleIndex(so, Ship.RANGE_360);
		int sbiDir = 1;
		
		for(int i=0; i<100; i++) {
			Vector2D sb = ship.getAngleByIndex(sbi);
			// Bentigte Zeit um den Schusswinkel zu erreichen
			int turnTicks = ship.getTurnTicks(sb);
			int timeA = Math.abs(turnTicks)*2;
			
			// Schnittpunkt Schussrichtung - Ziellaufbahn
			Vector2D x = InterceptCalculator.calculateIntercept(ls, sb, lx, vx);
			if(x != null) {
				// Strecke Ziel -> Schnittpunkt ermitteln
				Vector2D sx = new Vector2D(-lx.x, -lx.y);
				sx.add(x);
				// Strecke Schiff -> Schnittpunkt ermitteln
				Vector2D ss = new Vector2D(-ls.x, -ls.y);
				ss.add(x);
				
				// Schnittpunkt auf der richtigen Seite?
				if(Math.signum(sx.x) != Math.signum(vx.x) ||
						Math.signum(sx.y) != Math.signum(vx.y) ||
						Math.signum(ss.x) != Math.signum(sb.x) ||
						Math.signum(ss.y) != Math.signum(sb.y)) {
					// Schnittpunkt hinter dem Ziel - in die andere Richtung drehen
					sbiDir = -1;
				} else {
					// Zeit, die das Ziel braucht um Punkt zu erreichen
					int timeT = Math.round(sx.getLength() / vx.getLength());
					// Zeit, die der Schuss braucht um Punkt zu erreichen
					int timeS = Math.round((ss.getLength()-20) / sb.getLength());
					
					// Ziel an diesem Punkt erreichbar?
					int time = timeT - (timeS + timeA);
					if(time > 3 && time < 60) {
						// Die Lsung ist brauchbar
						solution = new TargetSolution();
						solution.angle = sb;
						solution.target = target;
						solution.turnTicks = turnTicks;
						solution.shotDelay = time;
						solution.destroyTime = timeS + timeA;
						solution.intercept = x;
						lastSolution = solution;
						break;
					}
				}
			} else {
				System.out.println("Kein Schnittpunkt gefunden!");
			}
			// Nchsten mglichen Schusswinkel berechnen
			sbi += sbiDir;
			if(sbi >= Ship.ANGLE_COUNT) sbi = 0;
			if(sbi < 0) sbi += Ship.ANGLE_COUNT;
		}
	}*/
}
