package util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;

public class ShapeDirection implements Comparable<ShapeDirection>, Serializable {

	private static final long serialVersionUID = 1L;
	
	
	private int shapeHash;
	private ArrayList<Vector2D> dirs;
	
	
	public ShapeDirection(int shape) {
		this.shapeHash = shape;
		dirs = new ArrayList<Vector2D>();
	}
	
	
	public void addDirection(Vector2D dir) {
		float dif = 100;
		for(int i=0; i<dirs.size(); i++) {
			float d = Math.abs(dirs.get(i).calcDifAngle(dir));
			if(d < dif) dif = d;
		}
		if(dif > 0.1f) {
			dirs.add(dir);
			Collections.sort(dirs);
			System.out.println(dirs.size() + ": " + dir);
		}
	}
	
	
	public int getShapeHash() {
		return shapeHash;
	}
	
	
	public float getAverageAngle() {
		float f = 0;
		for(int i=0; i<dirs.size(); i++) {
			f += dirs.get(i).getDeg();
		}
		f /= dirs.size();
		return f;
	}
	
	
	private static int n=0;
	public String toString() {
		StringBuffer buf = new StringBuffer();
		buf.append(String.format("0x%08X", shapeHash));
		
		for(int i=0; i<dirs.size(); i++) {
			if(i != 0) buf.append("          ");
			buf.append(String.format("  [%3d] %s\n", n++, dirs.get(i)));
		}
		
		return buf.toString();
	}


	public int compareTo(ShapeDirection o) {
		if(getAverageAngle() > o.getAverageAngle())
			return 1;
		else
			return 0;
	}


	public ArrayList<Vector2D> getDirections() {
		return dirs;
	}
}
