#ifndef _VECTOR2D_H_
#define _VECTOR2D_H_


template <class T> class Vector2D {
public:
	T x, y;

	Vector2D<T>() {x=y=0;}
	Vector2D<T>(T X, T Y) {x=X; y=Y;}
	Vector2D<T>(const Vector2D<T>& rhs) {x=rhs.x; y=rhs.y;}
	Vector2D<T>& operator =(const Vector2D<T>& rhs) {
		x=rhs.x; y=rhs.y; return *this;
	}

	Vector2D operator *(T s) const {
		return Vector2D<T>(x*s, y*s);
	}


	Vector2D operator /(T s) const {
		return Vector2D<T>(x/s, y/s);
	}
	
	Vector2D operator +(const Vector2D<T>& rhs) const {
		return Vector2D<T>(x+rhs.x, y+rhs.y);
	}

	Vector2D operator -(const Vector2D<T>& rhs) const {
		return Vector2D<T>(x-rhs.x, y-rhs.y);
	}

	T operator *(const Vector2D<T>& rhs) const {
		return x*rhs.x + y*rhs.y;
	}

	T operator %(const Vector2D<T>& rhs) {
		return x * rhs.y - y * rhs.x;
	}

	T square() const {
		return *this * *this;
	}

	T abs() const {
		return sqrt(square());
	}

	void normalize() {
		T s = abs();
		x/=s; y/=s;
	}

	Vector2D<T> normal() const {
		T s = abs();
		return Vector2D<T>(x/s, y/s);
	}

	Vector2D<T> asteroids_norm() const {
		T dx = x;
		T dy = y;
		while (dx < -512) dx += 1024;
		while (dx > 511) dx -= 1024;
		while (dy < -384) dy += 768;
		while (dy > 383) dy -= 768;
		return Vector2D<T>(dx, dy);
	}


	Vector2D<T> normalized() const {
		T s = abs();
		return Vector2D<T>(x/s, y/s);
	}
	T sin(const Vector2D<T>& lhs, const Vector2D<T>& rhs) {
		Vector2D<T> lhs_n( lhs.normalized() );
		Vector2D<T> rhs_n( rhs.normalized() );
		return lhs_n % rhs_n;
	}

	T static cos(const Vector2D<T>& lhs, const Vector2D<T>& rhs) {
		Vector2D<T> lhs_n( lhs.normalized() );
		Vector2D<T> rhs_n( rhs.normalized() );
		return lhs_n * rhs_n;
	}

	

}; // end of Vector2D<T>


template <class T> Vector2D<T> operator *(T s, const Vector2D<T>& v) {
	return Vector2D<T>(v.x*s, v.y*s);
}


typedef Vector2D<double> Vector;

#endif