/*
 * Decompiled with CFR 0.152.
 */
package Asteroid;

public class FramePacket {
    public static int LENGTH = 1026;
    final byte[] buffer = new byte[1024];
    byte frameno;
    byte ping;
    final char[] vRam = new char[512];

    FramePacket() {
    }

    public void setFromBuffer(byte[] ba) {
        int idx = 0;
        while (idx < 1024) {
            this.buffer[idx] = ba[idx];
            ++idx;
        }
        this.frameno = ba[1024];
        this.ping = ba[1025];
        int i = 0;
        while (i < 512) {
            this.vRam[i] = (char)(this.buffer[2 * i] & 0xFF | this.buffer[2 * i + 1] << 8);
            ++i;
        }
    }

    public char[] getVRam() {
        return this.vRam;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int dx = 0;
        int dy = 0;
        int sf = 0;
        int vx = 0;
        int vy = 0;
        int vz = 0;
        int vs = 0;
        int pc = 0;
        while (pc < 511) {
            int op = this.vRam[pc] >> 12;
            switch (op) {
                case 10: {
                    vy = this.vRam[pc] & 0x3FF;
                    vx = this.vRam[pc + 1] & 0x3FF;
                    vs = this.vRam[pc + 1] >> 12;
                    sb.append("LABS (").append(vy).append(", ").append(vx).append("), s").append(vs).append('\n');
                    break;
                }
                case 11: {
                    sb.append("HALT").append('\n');
                    break;
                }
                case 12: {
                    sb.append("JSRL ").append("$").append(Integer.toHexString(this.vRam[pc] & 0xFFF)).append('\n');
                    break;
                }
                case 13: {
                    sb.append("RTSL").append('\n');
                    break;
                }
                case 14: {
                    sb.append("JMPL ").append("$").append(Integer.toHexString(this.vRam[pc] & 0xFFF)).append('\n');
                    break;
                }
                case 15: {
                    dy = this.vRam[pc] & 0x300;
                    if ((this.vRam[pc] & 0x400) != 0) {
                        dy = -dy;
                    }
                    dx = (this.vRam[pc] & 3) << 8;
                    if ((this.vRam[pc] & 4) != 0) {
                        dx = -dx;
                    }
                    sf = ((this.vRam[pc] & 8) >> 2 | (this.vRam[pc] & 0x800) >> 11) + 2;
                    vz = (this.vRam[pc] & 0xF0) >> 4;
                    sb.append("SVEC (").append(dy).append(", ").append(dx).append("), z").append(vz).append(", sf").append(sf).append('\n');
                    break;
                }
                default: {
                    if (op < 10) {
                        dy = this.vRam[pc] & 0x3FF;
                        if ((this.vRam[pc] & 0x400) != 0) {
                            dy = -dy;
                        }
                        dx = this.vRam[pc + 1] & 0x3FF;
                        if ((this.vRam[pc + 1] & 0x400) != 0) {
                            dx = -dx;
                        }
                        sf = op;
                        vz = this.vRam[pc + 1] >> 12;
                        sb.append("VCTR (").append(dy).append(", ").append(dx).append("), z").append(vz).append(", sf").append(sf).append('\n');
                        break;
                    }
                    sb.append("???").append('\n');
                }
            }
            if (op <= 10) {
                ++pc;
            }
            ++pc;
        }
        return sb.toString();
    }
}

