/*
 * Decompiled with CFR 0.152.
 */
package Asteroid;

import Asteroid.FramepaketDisplay;
import Asteroid.VecObject;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

public class Shot
extends VecObject {
    boolean willHit = false;

    Shot(int x, int y) {
        super.set(x, y);
    }

    void drawOn(Graphics g) {
        int rx = this.x + this.shipx;
        int ry = this.y + this.shipy;
        if (rx < 0) {
            rx += 1024;
        }
        if (ry < 0) {
            ry += 768;
        }
        if (rx > 1023) {
            rx -= 1024;
        }
        if (ry > 767) {
            ry -= 768;
        }
        if (this.willHit) {
            g.setColor(Color.GREEN);
        } else {
            g.setColor(Color.ORANGE);
        }
        g.drawOval(rx / FramepaketDisplay.SCALE, FramepaketDisplay.SIZEY - ry / FramepaketDisplay.SCALE, 3, 3);
        if (this.willKollide) {
            g.setColor(Color.red);
        } else {
            g.setColor(Color.gray);
        }
        if (this.oid > 0) {
            g.drawLine(rx / FramepaketDisplay.SCALE, FramepaketDisplay.SIZEY - ry / FramepaketDisplay.SCALE, (rx + this.dx * 30) / FramepaketDisplay.SCALE, FramepaketDisplay.SIZEY - (ry + this.dy * 30) / FramepaketDisplay.SCALE);
            if (this.willKollide) {
                g.setColor(Color.red);
            } else {
                g.setColor(Color.gray);
            }
            if (FramepaketDisplay.zeigeTexte) {
                g.drawString(this.getIdString(), rx / FramepaketDisplay.SCALE, FramepaketDisplay.SIZEY - ry / FramepaketDisplay.SCALE);
            }
        }
    }

    @Override
    public int willKollideWithInFrames(Rectangle r) {
        int distY;
        if (this.oid == 0) {
            return 0;
        }
        if (this.dx == 0 && this.dy == 0) {
            return 0;
        }
        int xc = r.x + r.width / 2;
        int yc = r.y + r.height / 2;
        if (this.dx > 0 && this.x >= xc) {
            return 0;
        }
        if (this.dx < 0 && this.x <= xc) {
            return 0;
        }
        if (this.dy > 0 && this.y >= yc) {
            return 0;
        }
        if (this.dy < 0 && this.y <= yc) {
            return 0;
        }
        int distX = Math.abs(this.x - xc);
        if (distX * distX + (distY = Math.abs(this.y - yc)) * distY < 625) {
            return 0;
        }
        int tmp = super.willKollideWithInFrames(r);
        if (tmp > 0) {
            int ldx = Math.abs(this.dx / this.q);
            int ldy = Math.abs(this.dy / this.q);
            if (ldx == 0) {
                return distY / ldy;
            }
            if (ldy == 0) {
                return distX / ldx;
            }
            return Math.min(distY / ldy, distX / ldx);
        }
        return 0;
    }
}

