package Asteroid;

public class FramePacket {
	public static int LENGTH = 1026;
	final byte[] buffer;
	byte frameno;  // wird bei jedem Frame inkrementiert
	byte ping;     // Der Server schickt das letzte empfangene ping-Byte zurck
	final char[] vRam;
	FramePacket()
	{
		buffer = new byte[1024];
		vRam = new char[512];
	}
	
	public void setFromBuffer(byte[] ba)
	{
		for (int idx=0; idx < 1024; idx ++)
		{
			buffer[idx] = ba[idx];
		}
		frameno = ba[1024];
		ping = ba[1025];

		/* Vektor-RAM in 16-Bit-Worte konvertieren. War in der ersten Version mal ein sportlicher
		Typecast: unsigned short *vector_ram = (unsigned short*)packet.vectorram;
		Das klappt aber nur auf Little-Endian-Systemen, daher besser portabel: */
		for (int i=0; i<512; ++i)
			vRam[i] = (char)( buffer[2*i] & 255  | buffer[2*i+1] << 8);
		
	}
	
	
	public char[] getVRam()
	{
		return vRam;
	}
	
	
	public String toString()
	{
		StringBuilder sb=new StringBuilder();
		int dx = 0, dy=0, sf=0, vx=0, vy=0, vz=0, vs=0;
		int pc = 0;
		while (pc < 511)
		{
			int op = vRam[pc] >> 12;
			switch (op)
			{
			case 0xa: // LABS
				vy = vRam[pc] & 0x3ff;
				vx = vRam[pc+1] & 0x3ff;
				vs = vRam[pc+1] >> 12;
				sb	.append("LABS (")
					.append(vy)
					.append(", ")
					.append(vx)
					.append("), s")
					.append(vs)
					.append('\n');
			break;
			case 0xb: // HALT
				sb	.append("HALT")
				    .append('\n');
				break;
			case 0xc: // JSRL
				sb	.append("JSRL ")
					.append("$")
					.append(Integer.toHexString(vRam[pc] & 0xfff))
					.append('\n');
				break;
			case 0xd: // RTSL
				sb	.append("RTSL")
			    .append('\n');
				break;
			case 0xe: // JMPL
				sb	.append("JMPL ")
				.append("$")
				.append(Integer.toHexString(vRam[pc] & 0xfff))
				.append('\n');
				break;
			case 0xf: // SVEC

				dy = vRam[pc] & 0x300;
				if ((vRam[pc] & 0x400) != 0)
					dy = -dy;
				dx = (vRam[pc] & 3) << 8;
				if ((vRam[pc] & 4) != 0)
					dx = -dx;
				sf = (((vRam[pc] & 8) >> 2) | ((vRam[pc] & 0x800) >> 11)) + 2;
				vz = (vRam[pc] & 0xf0) >> 4;
				sb	.append("SVEC (")
				.append(dy)
				.append(", ")
				.append(dx)
				.append("), z")
				.append(vz)
				.append(", sf")
				.append(sf)
				.append('\n');
				break;
			default:
				if (op<10) 
				{
				dy = vRam[pc] & 0x3ff;
				if ((vRam[pc] & 0x400) != 0)
					dy = -dy;
				dx = vRam[pc+1] & 0x3ff;
				if ((vRam[pc+1] & 0x400) != 0)
					dx = -dx;
				sf = op;
				vz = vRam[pc+1] >> 12;
				sb	.append("VCTR (")
				.append(dy)
				.append(", ")
				.append(dx)
				.append("), z")
				.append(vz)
				.append(", sf")
				.append(sf)
				.append('\n');
				} else
				{
					sb	
					.append("???")
					.append('\n');
				}
				break;
			}
			if (op <= 0xa)
				++pc;
			//if (op != 0xe) // JMPL
				++pc;
		}   
		return sb.toString();
	}
}
