package Asteroid;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

public class Shot extends VecObject {
	
	boolean willHit = false;
	
	Shot(int x, int y)
	{
		super.set(x, y);
	}

	
	
	
	void drawOn(Graphics g)
	{
		int rx,ry;
		
		rx = x+shipx;
		ry = y+shipy;
		
		if (rx<0) rx += 1024;
		if (ry<0) ry += 768;
		if (rx>1023) rx -= 1024;
		if (ry>767) ry -= 768;
				
		if (willHit)
		{
			g.setColor( Color.GREEN );
		} else
		{
		g.setColor(Color.ORANGE);
		}
		g.drawOval(	(rx / FramepaketDisplay.SCALE),
					FramepaketDisplay.SIZEY - (ry / FramepaketDisplay.SCALE),
					3 ,
					3 );
		if (willKollide)
		{
			g.setColor(Color.red);
		}
		else
		{
		g.setColor( Color.gray);
		}

		if (oid > 0)
		{
		g.drawLine(rx / FramepaketDisplay.SCALE, FramepaketDisplay.SIZEY - (ry / FramepaketDisplay.SCALE),
				(rx + (dx * 30)) / FramepaketDisplay.SCALE , FramepaketDisplay.SIZEY - ((ry + (dy*30)) / FramepaketDisplay.SCALE));
		if (willKollide)
		{
			g.setColor(Color.red);
		}
		else
		{
		g.setColor( Color.gray);
		}
		if (FramepaketDisplay.zeigeTexte)
			g.drawString( getIdString(), (rx / FramepaketDisplay.SCALE),	FramepaketDisplay.SIZEY - (ry / FramepaketDisplay.SCALE));
		};
		
		
	}

	public int willKollideWithInFrames(Rectangle r)
	{
		if (oid==0) return 0; // Ich weiss noch nix
		if (dx==0 && dy == 0) return 0; // to do:  bogus???
		
		int xc = r.x+(r.width/2);
		int yc = r.y+(r.height/2);
		
		if (dx>0 && x >= xc)
			return 0;
		if (dx<0 && x <= xc)
			return 0;
		if (dy>0 && y >= yc)
			return 0;
		if (dy<0 && y <= yc)
			return 0;
		
		int distX = Math.abs(x-xc);
		int distY = Math.abs(y-yc);
		if ((distX * distX) + (distY*distY) < 625)  // zu nah dran, wahrscheinlich unser 
			return 0;
		
		int tmp = super.willKollideWithInFrames(r);
		if (tmp > 0)
		{
			int ldx = Math.abs(dx / q);
			int ldy = Math.abs(dy / q);
			
			if (ldx == 0)
				return distY / ldy;
			if (ldy == 0)
				return distX / ldx;
			return Math.min(distY / ldy , distX / ldx);
			
		}
		return 0;
	}
	
}


