﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Net;
using System.Net.Sockets;
using System.Text;
using System.Threading;
using System.Windows.Forms;

using Thomas_Erdoesi.Game_Interface;

namespace Thomas_Erdoesi.Forms
{
    public partial class MainForm : Form
    {
        public MainForm()
        {
            InitializeComponent();
        }

        private void MainForm_Load(object sender, EventArgs e)
        {
            String[] args = Environment.GetCommandLineArgs();

            if (args.Length == 2)
            {
                Host.Text = args[1];
            }

        }

        private void Connect_Click(object sender, EventArgs e)
        {
            OnScreenDisplay OSD = new OnScreenDisplay();

            if ((Control.ModifierKeys & Keys.Shift) != 0) OSD.TopMost = false;

            try
            {
                IPAddress server_ip;

                if (!IPAddress.TryParse(Host.Text, out server_ip))
                    server_ip = (from IP in Dns.GetHostAddresses(Host.Text)
                                 where IP.AddressFamily == AddressFamily.InterNetwork
                                 select IP).ElementAt(0);

                Hide();

                OSD.Show();

                Application.DoEvents();

                CommunicationHandler CommHandler = new CommunicationHandler(server_ip);

                CommHandler.ConnectionLabel = OSD.ConnetectedTo;
                CommHandler.FramesLostLabel = OSD.FramesLost;
                CommHandler.KeysLostLabel = OSD.KeysLost;
                CommHandler.ScoreLabel = OSD.Score;
                CommHandler.Run();

                OSD.Score.ForeColor = Color.Green;
                Application.DoEvents();

                Thread.Sleep(5000);
                OSD.Close();

                Show();
                Activate();
            }
            catch (Exception ex)
            {
                OSD.Score.ForeColor = Color.Red;
                Application.DoEvents();

                Thread.Sleep(5000);
                OSD.Close();

                Show();
                Activate();

                MessageBox.Show(ex.Message, Text, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
            }
        }

        private void ExitProgram_Click(object sender, EventArgs e)
        {
            Close();
        }
    }
}
