﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Diagnostics;
using System.Data;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Net;
using System.Text;
using System.Threading;
using System.Windows.Forms;

using Thomas_Erdoesi.Game_Analyzer;
using Thomas_Erdoesi.Game_Interface;
using Thomas_Erdoesi.Properties;

namespace Thomas_Erdoesi.Forms
{
    public partial class TestForm : Form
    {
        private Process MameProcess;

        private bool StopRequested = false;

        public TestForm()
        {
            InitializeComponent();
        }

        private void TestForm_Load(object sender, EventArgs e)
        {
            SettingsGrid.SelectedObject = Settings.Default;
        }

        private void Start_Click(object sender, EventArgs e)
        {
            int RunCounter = 0;
            int TotalScore = 0;

            FileInfo MameFile = new FileInfo(MamePath.Text);

            if (!MameFile.Exists)
            {
                MessageBox.Show("Die Datei '" + MameFile.FullName + "' existiert nicht.");
                return;
            }

            if (MameFile.Extension.ToLower() != ".exe")
            {
                MessageBox.Show("Die Datei '" + MameFile.Name + "' ist nicht ausführbar.");
                return;
            }

            Start.Enabled = false;
            Stop.Enabled = true;

            StopRequested = false;

            while (!StopRequested)
            {
                try
                {
                    GameStatus Status = new GameStatus();

                    MameProcess = new Process();
                    MameProcess.StartInfo.FileName = MameFile.FullName;
                    MameProcess.StartInfo.Arguments = MameParams.Text;
                    MameProcess.StartInfo.WorkingDirectory = MameFile.DirectoryName;

                    //MameProcess.StartInfo.CreateNoWindow = !MameVisible.Checked;
                    //MameProcess.StartInfo.UseShellExecute = false;

                    if (!MameVisible.Checked) MameProcess.StartInfo.WindowStyle = ProcessWindowStyle.Hidden;

                    MameProcess.Start();

                    Thread.Sleep(3000);

                    CommunicationHandler CommHandler = new CommunicationHandler(IPAddress.Loopback);

                    CommHandler.ConnectionLabel = ConnetectedTo;
                    CommHandler.FramesLostLabel = FramesLost;
                    CommHandler.KeysLostLabel = KeysLost;
                    CommHandler.ScoreLabel = Score;
                    CommHandler.Run(Status);
                    
                    TotalScore += int.Parse(Score.Text);

                    TestRuns.Text = (++RunCounter).ToString();
                    AvgScore.Text = (TotalScore / RunCounter).ToString();
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.Message + "\r\n\r\n" + ex.StackTrace, Text , MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                    break;
                }
                finally
                {
                    if (!MameProcess.HasExited) MameProcess.Kill();
                }
            }

            Start.Enabled = true;
            Stop.Enabled = false;
        }

        private void Stop_Click(object sender, EventArgs e)
        {
            Stop.Enabled = false;
            StopRequested = true;
        }

        private void Browse_Click(object sender, EventArgs e)
        {
            FileInfo MameFile = new FileInfo(MamePath.Text);
            OpenFileDialog FileBrowser = new OpenFileDialog();

            FileBrowser.InitialDirectory = MameFile.DirectoryName;
            FileBrowser.FileName = MameFile.Name;

            FileBrowser.CheckFileExists = true;
            FileBrowser.CheckPathExists = true;
            FileBrowser.DefaultExt = ".exe";
            FileBrowser.Filter = "Ausführbare Dateien (*.exe)|*.exe|Alle Dateien (*.*)|*.*";

            if (FileBrowser.ShowDialog() == DialogResult.OK)
                MamePath.Text = FileBrowser.FileName;
        }

        private void TestForm_FormClosed(object sender, FormClosedEventArgs e)
        {
            if (MameProcess != null)
                if (!MameProcess.HasExited) MameProcess.Kill();
        }
    }
}
