/*
 * Decompiled with CFR 0.152.
 */
package de.oflebbe.asteroids;

import de.oflebbe.asteroids.Keys;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DatagramChannelCommunicator {
    private DatagramChannel channel;
    private byte[] signature;
    private InetSocketAddress remote;
    private Selector sel;

    public DatagramChannelCommunicator(String endpoint) {
        try {
            this.signature = "ctmame".getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(DatagramChannelCommunicator.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            this.remote = new InetSocketAddress("127.0.0.1", 1979);
            this.channel = DatagramChannel.open();
            this.channel.configureBlocking(false);
            this.channel.connect(this.remote);
            this.sel = Selector.open();
            this.channel.register(this.sel, this.channel.validOps());
        }
        catch (IOException ex) {
            Logger.getLogger(DatagramChannelCommunicator.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void send(Keys k) throws IOException {
        ByteBuffer sendBuffer = ByteBuffer.allocate(8);
        sendBuffer.put(this.signature);
        byte key = 64;
        sendBuffer.put(key);
        sendBuffer.put((byte)1);
        sendBuffer.flip();
        this.channel.send(sendBuffer, this.remote);
    }

    public void receive(ByteBuffer b) throws IOException {
        b.clear();
        this.sel.selectNow();
        Iterator<SelectionKey> it = this.sel.selectedKeys().iterator();
        while (it.hasNext()) {
            SelectionKey selKey = it.next();
            it.remove();
            if (!selKey.isValid() || !selKey.isReadable()) continue;
            this.channel.receive(b);
            b.flip();
        }
    }
}

