/*
 * Decompiled with CFR 0.152.
 */
package de.oflebbe.asteroids;

import de.oflebbe.asteroids.DatagramChannelCommunicator;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DatagramSocketCommunicator {
    private byte[] sendBuffer = new byte[8];
    private byte[] recBuffer;
    private InetSocketAddress remote;
    private DatagramSocket sockel;
    private DatagramPacket packet = null;
    byte ping = 1;
    int lastFrame = 0;

    public DatagramSocketCommunicator(String remoteHost) throws SocketException {
        try {
            byte[] signature = "ctmame".getBytes("US-ASCII");
            System.arraycopy(signature, 0, this.sendBuffer, 0, signature.length);
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(DatagramChannelCommunicator.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.remote = new InetSocketAddress(remoteHost, 1979);
        this.sockel = new DatagramSocket();
        this.sockel.setSoTimeout(1000);
    }

    public void send(byte code) throws IOException {
        if (this.packet == null) {
            this.packet = new DatagramPacket(this.sendBuffer, this.sendBuffer.length, this.remote);
        }
        this.sendBuffer[6] = code;
        this.sendBuffer[7] = this.ping = (byte)(this.ping + 1);
        this.packet.setData(this.sendBuffer);
        this.sockel.send(this.packet);
    }

    public void receive(byte[] b) throws IOException {
        byte gotPing;
        DatagramPacket recPacket = new DatagramPacket(b, b.length);
        this.sockel.receive(recPacket);
        int nextFrame = (this.lastFrame + 1 + 128) % 256 - 128;
        if (nextFrame != b[1024]) {
            System.err.printf("expected frame %d found %d, old %d\n", nextFrame, b[1024], this.lastFrame);
        }
        if (this.ping != (gotPing = b[1025])) {
            System.err.printf("expected ping %d found %d\n", this.ping, (int)gotPing);
        }
        this.lastFrame = b[1024];
    }
}

