/*
 * Decompiled with CFR 0.152.
 */
package de.oflebbe.asteroids;

import de.oflebbe.asteroids.Asteroid;
import de.oflebbe.asteroids.Saucer;
import de.oflebbe.asteroids.Ship;
import de.oflebbe.asteroids.Shot;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Screen {
    byte[] screenData;
    private ArrayList<Asteroid> asteroids;
    private ArrayList<Shot> shots;
    private Saucer saucer;
    private Ship ship;

    public Screen(byte[] screenData) {
        this.screenData = screenData;
        this.asteroids = new ArrayList(8);
        this.shots = new ArrayList(10);
        this.ship = null;
        this.interpret();
    }

    private final int getShort(int pc) {
        return (this.screenData[pc * 2 + 1] & 0xFF) << 8 | this.screenData[pc * 2] & 0xFF;
    }

    private void interpret() {
        try {
            int pc = 1;
            int vx = 0;
            int vy = 0;
            int vs = 0;
            int vz = 0;
            int shipDetect = 0;
            int v1x = 0;
            int v1y = 0;
            while (true) {
                int op = this.getShort(pc) >>> 12;
                switch (op) {
                    case 10: {
                        vy = this.getShort(pc) & 0x3FF;
                        vx = this.getShort(pc + 1) & 0x3FF;
                        vs = this.getShort(pc + 1) >>> 12;
                        if (vs <= 5) break;
                        vs -= 16;
                        break;
                    }
                    case 11: {
                        return;
                    }
                    case 12: {
                        int instr = this.getShort(pc) & 0xFFF;
                        switch (instr) {
                            case 2291: 
                            case 2303: 
                            case 2317: 
                            case 2330: {
                                this.asteroids.add(new Asteroid(vx, vy, 20 << vs + 2, instr));
                                break;
                            }
                            case 2345: {
                                this.saucer = new Saucer(vx, vy, vs);
                            }
                        }
                        break;
                    }
                    case 13: 
                    case 14: {
                        return;
                    }
                    case 15: {
                        break;
                    }
                    default: {
                        int inst = this.getShort(pc);
                        int dy = inst & 0x3FF;
                        if ((inst & 0x400) != 0) {
                            dy = -dy;
                        }
                        inst = this.getShort(pc + 1);
                        int dx = inst & 0x3FF;
                        if ((inst & 0x400) != 0) {
                            dx = -dx;
                        }
                        vz = inst >> 12;
                        if (dx == 0 && dy == 0 && vz == 15) {
                            this.getShots().add(new Shot(vx, vy));
                        }
                        if (op == 6 && vz == 12 && dx != 0 && dy != 0) {
                            switch (shipDetect) {
                                case 0: {
                                    v1x = dx;
                                    v1y = dy;
                                    ++shipDetect;
                                    break;
                                }
                                case 1: {
                                    this.ship = new Ship(vx, vy, v1x - dx, v1y - dy);
                                    ++shipDetect;
                                }
                            }
                            break;
                        }
                        if (shipDetect != true) break;
                        shipDetect = 0;
                    }
                }
                if (op <= 10) {
                    ++pc;
                }
                if (op == 14) continue;
                ++pc;
            }
        }
        catch (Exception e) {
            System.out.println("Exception!!");
            return;
        }
    }

    public ArrayList<Asteroid> getAsteroids() {
        return this.asteroids;
    }

    public ArrayList<Shot> getShots() {
        return this.shots;
    }

    public Ship getShip() {
        return this.ship;
    }

    public Saucer getSaucer() {
        return this.saucer;
    }

    public void save(PrintWriter p) throws IOException {
        p.println("---------------------------------");
        p.printf("# of Asteroids: %d\n", this.asteroids.size());
        for (Asteroid ast : this.asteroids) {
            p.printf(" %d %d, %f %f, %d\n", ast.getX(), ast.getY(), ast.getVx(), ast.getVy(), ast.getSize());
        }
        p.printf("# of Shots: %d\n", this.shots.size());
        for (Shot sho : this.shots) {
            p.printf(" %d %d, %f %f", sho.getX(), sho.getY(), sho.getVx(), sho.getVy());
            if (sho.isUfoShot()) {
                p.println("UFO");
                continue;
            }
            p.println();
        }
        if (this.saucer != null) {
            p.println("Saucer");
            p.printf("%d %d, %f %f\n", this.saucer.getX(), this.saucer.getY(), this.saucer.getVx(), this.saucer.getVy());
        }
        if (this.ship != null) {
            p.println("Ship");
            p.printf("%d %d, %f %f\n", this.ship.getX(), this.ship.getY(), this.ship.getVx(), this.ship.getVy());
        }
    }
}

