/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package de.oflebbe.asteroids;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author olaf
 */
public class DatagramChannelCommunicator {
    private DatagramChannel channel;
    private byte[] signature;
    private InetSocketAddress remote;
    private Selector sel;
    
    
    public DatagramChannelCommunicator(String endpoint) {
        try {
            signature = "ctmame".getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(DatagramChannelCommunicator.class.getName()).log(Level.SEVERE, null, ex);
        }
        
        try {
            //remote = new InetSocketAddress( endpoint, 1979);
            remote = new InetSocketAddress( "127.0.0.1", 1979);
            
            channel = DatagramChannel.open();
            channel.configureBlocking(false);
            channel.connect( remote);
           // channel.socket().bind( new InetSocketAddress(0));
            
            sel = Selector.open();
            channel.register(sel, channel.validOps());
            
        } catch (IOException ex) {
            Logger.getLogger(DatagramChannelCommunicator.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
    
    public void send( Keys k) throws IOException {
        ByteBuffer sendBuffer = ByteBuffer.allocate( 8);
        
        sendBuffer.put(signature);
        byte key = 0x40;
        sendBuffer.put(key);
        sendBuffer.put((byte) 1);
        sendBuffer.flip();
        channel.send( sendBuffer, remote);
    }
      
    public void receive( ByteBuffer b) throws IOException{
        b.clear();
             sel.selectNow();
            Iterator it = sel.selectedKeys().iterator();
            while (it.hasNext()) {
                SelectionKey selKey = (SelectionKey)it.next();
                it.remove();
                if (selKey.isValid() && selKey.isReadable()) {   
                    channel.receive(b);
                    b.flip();
                   // System.out.println("received");
                }
            }
 
    }
    

}
