/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package de.oflebbe.asteroids;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.util.logging.Level;
import java.util.logging.Logger;


/**
 *
 * @author olaf
 */
public class DatagramSocketCommunicator {
    private byte[] sendBuffer;
    private byte[] recBuffer;
    private InetSocketAddress remote;
    private DatagramSocket sockel;
    private DatagramPacket packet = null;
        

    public DatagramSocketCommunicator(String remoteHost) throws SocketException {
        sendBuffer = new byte[8];
        try {
            byte[] signature = "ctmame".getBytes("US-ASCII");
            System.arraycopy(signature, 0, sendBuffer, 0, signature.length);
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(DatagramChannelCommunicator.class.getName()).log(Level.SEVERE, null, ex);
        }
            
         remote = new InetSocketAddress( remoteHost, 1979);
         sockel = new DatagramSocket();
         sockel.setSoTimeout(1000);
    }

     byte ping = 1;
     public void send( byte code) throws IOException {
        if (packet == null) {
            packet = new DatagramPacket(sendBuffer, sendBuffer.length, remote);
        }
        
        sendBuffer[6] = code;
        sendBuffer[7] = ++ping;
        packet.setData( sendBuffer);
        
        sockel.send( packet);
    }
    
    int lastFrame = 0;
    public void receive( byte[] b) throws IOException{
       DatagramPacket recPacket = new DatagramPacket(b, b.length);
       
       sockel.receive( recPacket);
       int nextFrame = (((lastFrame +1) +128) % 256)-128;
       //System.out.println("hh0");
       if (nextFrame != b[1024] ) {
           System.err.printf("expected frame %d found %d, old %d\n", nextFrame, b[1024], lastFrame);
       }
       int gotPing = b[1025];
       if  (ping  != gotPing) {
           System.err.printf("expected ping %d found %d\n", ping, gotPing);
       }
       
       
       lastFrame = b[1024];
    }
}
