/*
 * Decompiled with CFR 0.152.
 */
package de.heise.asteroid.comm;

import de.heise.asteroid.comm.FramePacket;
import de.heise.asteroid.comm.FramePacketProvider;
import de.heise.asteroid.comm.KeyPacket;
import de.heise.asteroid.comm.ServerConnection;
import de.heise.asteroid.util.WorkerRunnable;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Communicator
implements WorkerRunnable,
FramePacketProvider {
    private ServerConnection srvConn;
    private List<FramePacket> fpQueue;
    private List<KeyPacket> kpQueue;
    private int expFrameNo;
    private int realFrameNo;
    private byte keys;
    private byte ping;
    private int latency;
    private byte[] keyHistory;

    public Communicator(ServerConnection conn) {
        this.srvConn = conn;
        this.fpQueue = null;
        this.kpQueue = null;
        this.keyHistory = new byte[256];
    }

    public void setQueues(List<FramePacket> fpq, List<KeyPacket> kpq) {
        this.fpQueue = fpq;
        this.kpQueue = kpq;
    }

    @Override
    public void workerInitialize() {
        System.out.println("Communicator started.");
        this.ping = 0;
        this.keys = (byte)64;
        this.expFrameNo = -2;
        this.latency = 0;
        KeyPacket kp = this.srvConn.getKeyPacket();
        kp.setKeys(this.keys);
        kp.setPing(this.ping);
        this.keyHistory[0] = this.keys;
        this.srvConn.send(kp);
    }

    @Override
    public boolean workerMainLoop() {
        FramePacket fp = this.receiveFramePacket();
        if (fp != null) {
            this.enqueueFramePacket(fp);
            this.transmitKeyPacket();
            return true;
        }
        return false;
    }

    @Override
    public void workerFinalize() {
        System.out.printf("Communicator stopped after %d frames.\n", this.srvConn.getPacketsRcvd());
        System.out.printf("Max. packets used: %d (F) / %d (K)\n", this.srvConn.getFramePacketCount(), this.srvConn.getKeyPacketCount());
        System.out.printf("Packets transferred: %d (F) / %d (K)\n", this.srvConn.getPacketsRcvd(), this.srvConn.getPacketsSent());
    }

    @Override
    public FramePacket receiveFramePacket() {
        FramePacket fp = null;
        try {
            fp = this.srvConn.receive();
        }
        catch (IOException e) {
            System.err.println("Failed to receive a packet, giving up (" + e.getMessage() + ").");
        }
        if (fp != null) {
            this.checkLatency(fp);
            ++this.expFrameNo;
            this.expFrameNo = this.realFrameNo = this.getRealFrameNo(fp);
        }
        return fp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueFramePacket(FramePacket fp) {
        if (this.fpQueue != null) {
            List<FramePacket> list = this.fpQueue;
            synchronized (list) {
                this.fpQueue.add(fp);
                this.fpQueue.notify();
            }
        } else {
            this.srvConn.disposeFramePacket(fp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyPacket dequeueKeyPacket() {
        KeyPacket kp = null;
        if (this.kpQueue != null) {
            List<KeyPacket> list = this.kpQueue;
            synchronized (list) {
                if (!this.kpQueue.isEmpty() && this.realFrameNo + this.latency >= this.kpQueue.get(0).getTargetFameNo()) {
                    kp = this.kpQueue.remove(0);
                    this.keys = kp.getKeys();
                }
            }
        }
        return kp;
    }

    public void transmitKeyPacket() {
        KeyPacket kp = this.dequeueKeyPacket();
        if (kp == null) {
            kp = this.srvConn.getKeyPacket();
            this.keys = (byte)(this.keys & 0xFFFFFFFC);
            kp.setKeys(this.keys);
        }
        this.ping = (byte)(this.ping + 1);
        kp.setPing(this.ping);
        this.keyHistory[this.ping & 0xFF] = this.keys;
        this.srvConn.send(kp);
    }

    private int getRealFrameNo(FramePacket fp) {
        int fpFrameNo = fp.getFrameNo() & 0xFF;
        if (this.expFrameNo < 0) {
            this.expFrameNo = fpFrameNo;
        } else if ((this.expFrameNo & 0xFF) == fpFrameNo) {
            fpFrameNo = this.expFrameNo;
        } else {
            int offset = fp.getFrameNo() - (this.expFrameNo & 0xFF);
            if (offset < -128) {
                offset += 256;
            } else if (offset > 127) {
                offset -= 256;
            }
            fpFrameNo = this.expFrameNo + offset;
            System.out.printf("Expected frame number %d but received %d\n", this.expFrameNo, fpFrameNo);
        }
        fp.setRealFrameNo(fpFrameNo);
        return fpFrameNo;
    }

    private void checkLatency(FramePacket fp) {
        byte fpPing = fp.getPing();
        fp.setKeys(this.keyHistory[fpPing & 0xFF]);
        int lat = this.ping - fpPing;
        if (lat < -128) {
            lat += 256;
        } else if (lat > 127) {
            lat -= 256;
        }
        if (lat != this.latency) {
            this.latency = lat;
        }
    }

    public int getLatency() {
        return this.latency;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPendingFrames() {
        if (this.fpQueue != null) {
            List<FramePacket> list = this.fpQueue;
            synchronized (list) {
                return this.fpQueue.size();
            }
        }
        return -1;
    }

    public void recycle(FramePacket fp) {
        this.srvConn.disposeFramePacket(fp);
    }

    public KeyPacket getKeyPacket() {
        return this.srvConn.getKeyPacket();
    }

    public void disposeKeyPacket(KeyPacket kp) {
        this.srvConn.disposeKeyPacket(kp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushKeyQueue() {
        if (this.kpQueue != null) {
            List<KeyPacket> list = this.kpQueue;
            synchronized (list) {
                while (!this.kpQueue.isEmpty()) {
                    this.srvConn.disposeKeyPacket(this.kpQueue.remove(0));
                }
                this.keys = (byte)64;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpKeyQueue() {
        List<KeyPacket> list = this.kpQueue;
        synchronized (list) {
            System.out.printf("Key queue has %d elements", this.kpQueue.size());
            for (KeyPacket kp : this.kpQueue) {
                System.out.printf("%5d: %02x", kp.getTargetFameNo(), kp.getKeys());
            }
        }
    }
}

