/*
 * Decompiled with CFR 0.152.
 */
package de.heise.asteroid.engine;

import de.heise.asteroid.Position;
import de.heise.asteroid.comm.FramePacket;
import de.heise.asteroid.engine.AsteroidSequenceTracker;
import de.heise.asteroid.engine.GameStatus;
import de.heise.asteroid.engine.SaucerTracker;
import de.heise.asteroid.engine.ShipTracker;
import de.heise.asteroid.model.Asteroid;
import de.heise.asteroid.model.Shot;
import java.util.LinkedList;
import java.util.List;

public class FrameInterpreter {
    List<Asteroid> asteroids;
    List<Shot> shots;
    int state;
    int lifeCount;
    GameStatus status;
    AsteroidSequenceTracker astTracker;
    SaucerTracker ufoTracker;
    ShipTracker shipTracker;

    public FrameInterpreter(GameStatus stat) {
        this.status = stat;
        this.asteroids = new LinkedList<Asteroid>();
        this.shots = new LinkedList<Shot>();
        this.state = 0;
        this.lifeCount = 0;
        this.astTracker = new AsteroidSequenceTracker();
        this.ufoTracker = new SaucerTracker();
        this.shipTracker = new ShipTracker();
    }

    public void transitState(int s) {
        this.state = s;
        this.astTracker.reset();
        this.ufoTracker.reset();
        this.shipTracker.reset();
    }

    public void interpretFrame(FramePacket fp) {
        int frameNo = fp.getRealFrameNo();
        if (!this.astTracker.isInSync()) {
            System.out.println("!!!!!!!!!! RESYNCHRONIZING !!!!!!!!!!");
            this.astTracker.reset();
        }
        this.astTracker.start(frameNo);
        this.ufoTracker.start(frameNo);
        this.shipTracker.start(frameNo);
        this.status.clear();
        if (this.state != 3) {
            return;
        }
        int dx = 0;
        int dy = 0;
        int px = 0;
        int py = 0;
        int brightness = 0;
        int scale = 0;
        this.shots.clear();
        this.lifeCount = 0;
        int initialJump = fp.getRamAt(0);
        if (initialJump != 57345 && initialJump != 57857) {
            System.err.println(String.format("Bad instruction in vector RAM[0]: %04x", initialJump));
            return;
        }
        this.shipTracker.setThrustEnable(initialJump == 57345);
        int pc = 1;
        block12: while (true) {
            int currentWord = fp.getRamAt(pc++);
            int op = currentWord >> 12;
            switch (op) {
                case 10: {
                    int nextWord = fp.getRamAt(pc++);
                    py = currentWord & 0x3FF;
                    px = nextWord & 0x3FF;
                    scale = nextWord >> 12;
                    continue block12;
                }
                case 11: {
                    this.status.clear();
                    this.astTracker.cleanup();
                    this.astTracker.getAsteroids(this.asteroids, false);
                    this.status.addAsteroids(this.asteroids);
                    this.status.addShots(this.shots);
                    this.ufoTracker.cleanup();
                    this.status.setSaucer(this.ufoTracker.getSaucer());
                    this.shipTracker.cleanup();
                    this.status.setShip(this.shipTracker.getShip());
                    this.status.setLifeCount(this.lifeCount);
                    return;
                }
                case 12: {
                    int addr = currentWord & 0xFFF;
                    if (addr >= 2176 && addr <= 2345) {
                        int t = FrameInterpreter.getTargetTypeByAddr(addr);
                        if (this.ufoTracker.trackTarget(px, py, t, scale)) continue block12;
                        this.astTracker.trackTarget(px, py, t, scale);
                        continue block12;
                    }
                    if (addr >= 2680 && addr <= 2915) continue block12;
                    switch (addr) {
                        case 2130: {
                            continue block12;
                        }
                        case 2669: {
                            ++this.lifeCount;
                            continue block12;
                        }
                    }
                    System.err.println(String.format("Unknown vector subroutine %04x", addr));
                    continue block12;
                }
                case 13: {
                    System.err.println(String.format("Unexpected RTSL instruction in vector RAM[%03x]", pc - 1));
                    return;
                }
                case 14: {
                    System.err.println(String.format("Unexpected JMPL instruction in vector RAM[%03x]", pc - 1));
                    return;
                }
                case 15: {
                    continue block12;
                }
            }
            int nextWord = fp.getRamAt(pc++);
            dy = currentWord & 0x3FF;
            dx = nextWord & 0x3FF;
            if ((currentWord & 0x400) != 0) {
                dy = -dy;
            }
            if ((nextWord & 0x400) != 0) {
                dx = -dx;
            }
            brightness = nextWord >> 12;
            if (dx == 0 && dy == 0 && brightness == 15) {
                Shot shot = new Shot(new Position(px << 3, py << 3));
                this.shots.add(shot);
                continue;
            }
            if (op != 6 || brightness != 12 || dx == 0 || dy == 0) continue;
            this.shipTracker.trackShip(px, py, dx, dy, fp.getKeys() & 0x3F);
        }
    }

    private static int getTargetTypeByAddr(int addr) {
        switch (addr) {
            case 2176: {
                return 7;
            }
            case 2198: {
                return 6;
            }
            case 2229: {
                return 5;
            }
            case 2256: {
                return 4;
            }
            case 2291: {
                return 0;
            }
            case 2303: {
                return 1;
            }
            case 2317: {
                return 2;
            }
            case 2330: {
                return 3;
            }
            case 2345: {
                return 8;
            }
        }
        System.out.printf("Invalid address 0x%03x for a target", addr);
        return -1;
    }
}

