/*
 * Decompiled with CFR 0.152.
 */
package de.heise.asteroid.engine;

import de.heise.asteroid.Position;
import de.heise.asteroid.ScreenVector;
import de.heise.asteroid.engine.Explosion;
import de.heise.asteroid.engine.GameStatus;
import de.heise.asteroid.model.Saucer;
import de.heise.asteroid.util.SimpleMath;

public class SaucerTracker {
    private Saucer saucer;
    private Explosion explosion;
    private boolean saucerDetected;
    private int px;
    private int py;
    private int vx;
    private int vy;
    private Position pos;
    private ScreenVector speed;
    private int curFrame;
    private int baseFrame;

    public SaucerTracker() {
        this.reset();
    }

    public void reset() {
        this.saucer = null;
        this.start(0);
    }

    public void start(int frameNo) {
        this.curFrame = frameNo;
        this.saucerDetected = false;
        if (this.explosion != null && this.explosion.getFramesRemaining(this.curFrame) <= 0) {
            this.saucer = null;
            this.explosion = null;
        }
    }

    public boolean trackTarget(int sx, int sy, int type, int size) {
        if (type == 8) {
            this.saucerDetected = true;
            if (this.saucer == null) {
                this.px = sx << 3;
                this.py = sy << 3;
                this.vx = sx < 512 ? 16 : -16;
                this.vy = 0;
                this.pos = null;
                this.speed = new ScreenVector(this.vx, this.vy);
                this.saucer = new Saucer(this.getPos(), size == 15 ? Saucer.Size.BIG : Saucer.Size.SMALL, this.speed);
            } else {
                this.updatePosition(sx, sy);
                this.saucer.update(this.getPos(), this.speed);
            }
            this.baseFrame = this.curFrame;
            return true;
        }
        if (this.saucer != null && !this.saucerDetected && GameStatus.isExplosionType(type)) {
            if (this.explosion != null) {
                return this.explosion.match(this.curFrame, sx, sy, type, size);
            }
            int dx = SimpleMath.normalize(sx - (this.px >> 3), -512, 512);
            int dy = SimpleMath.normalize(sy - (this.py >> 3), -384, 384);
            if (dx == 0 && dy == 0) {
                this.startExplosion(sx, sy, type, size);
                return true;
            }
        }
        return false;
    }

    public Position getPos() {
        if (this.pos == null) {
            this.pos = new Position(this.px, this.py);
        }
        return this.pos;
    }

    public ScreenVector getSpeed() {
        return this.speed;
    }

    public Saucer getSaucer() {
        return this.explosion == null ? this.saucer : null;
    }

    private void updatePosition(int sx, int sy) {
        int x = SimpleMath.normalize(this.px + this.vx * (this.curFrame - this.baseFrame), 0, 8192);
        int y = SimpleMath.normalize(this.py + this.vy * (this.curFrame - this.baseFrame), 1024, 7168);
        int dx = SimpleMath.normalize(sx - (x >> 3), -512, 512);
        int dy = SimpleMath.normalize(sy - (y >> 3), -384, 384);
        if (dx == 0) {
            this.px = x;
        } else {
            System.out.println("Saucer seems to hop");
            this.px = sx << 3;
        }
        if (dy == 0) {
            this.py = y;
        } else {
            this.vy += dy < 0 ? -16 : 16;
            this.py = sy << 3;
            this.speed = new ScreenVector(this.vx, this.vy);
        }
        this.pos = null;
    }

    private void startExplosion(int sx, int sy, int t, int s) {
        this.vx = 0;
        this.vy = 0;
        this.speed = ScreenVector.NULL_VECTOR;
        this.explosion = new Explosion(this.curFrame, sx, sy, t, s);
        this.saucer.setExploding(true);
    }

    public void cleanup() {
        if (!this.saucerDetected && this.saucer != null && this.explosion == null) {
            this.saucer = null;
        }
    }
}

