/*
 * Decompiled with CFR 0.152.
 */
package de.heise.asteroid.engine;

import de.heise.asteroid.Position;
import de.heise.asteroid.ScreenVector;
import de.heise.asteroid.engine.AngleTracker;
import de.heise.asteroid.model.Ship;
import java.util.BitSet;

public class ShipTracker {
    private static final int[] rawCoords;
    private static int[] coordX;
    private static int[] coordY;
    private static BitSet[] angleSets;
    private static int[] screenAngles;
    private static final int DELAY = 3;
    private static final int MAX_SPEED = 16383;
    private Ship ship;
    private int curFrame;
    private int px;
    private int py;
    private int vx;
    private int vy;
    private boolean visible;
    private Position pos;
    private ScreenVector speed;
    private int shipDetected;
    private int xTmp;
    private int yTmp;
    private int[] keyBuf;
    private int keyIndex = 0;
    private boolean thrustEnable;
    private AngleTracker angleTracker = new AngleTracker();

    static {
        int[] nArray = new int[17];
        nArray[1] = 152;
        nArray[2] = 296;
        nArray[3] = 440;
        nArray[4] = 584;
        nArray[5] = 720;
        nArray[6] = 856;
        nArray[7] = 976;
        nArray[8] = 1088;
        nArray[9] = 1192;
        nArray[10] = 1280;
        nArray[11] = 1360;
        nArray[12] = 1416;
        nArray[13] = 1472;
        nArray[14] = 1504;
        nArray[15] = 1528;
        nArray[16] = 1536;
        rawCoords = nArray;
        coordX = new int[64];
        coordY = new int[64];
        angleSets = new BitSet[64];
        screenAngles = new int[256];
        System.out.print("Building ship angle tables... ");
        int i = 0;
        while (i < 16) {
            ShipTracker.coordX[i] = rawCoords[16 - i];
            ShipTracker.coordY[i] = rawCoords[i];
            ShipTracker.coordX[i + 16] = -rawCoords[i];
            ShipTracker.coordY[i + 16] = rawCoords[16 - i];
            ShipTracker.coordX[i + 32] = -rawCoords[16 - i];
            ShipTracker.coordY[i + 32] = -rawCoords[i];
            ShipTracker.coordX[i + 48] = rawCoords[i];
            ShipTracker.coordY[i + 48] = -rawCoords[16 - i];
            ++i;
        }
        int sa = 0;
        while (sa < 64) {
            ShipTracker.angleSets[sa] = new BitSet(256);
            ++sa;
        }
        angleSets[0].set(0, 4);
        angleSets[0].set(253, 256);
        angleSets[16].set(64);
        angleSets[32].set(125, 132);
        angleSets[48].set(192);
        int a = 1;
        int i2 = 4;
        while (a < 16) {
            angleSets[a].set(i2, 4 + i2);
            angleSets[a + 16].set(61 + i2, 65 + i2);
            angleSets[a + 32].set(128 + i2, 132 + i2);
            angleSets[a + 48].set(189 + i2, 193 + i2);
            ++a;
            i2 += 4;
        }
        sa = 0;
        while (sa < 64) {
            BitSet set = angleSets[sa];
            int a2 = set.nextSetBit(0);
            while (a2 >= 0) {
                ShipTracker.screenAngles[a2] = sa;
                ++a2;
                a2 = set.nextSetBit(a2);
            }
            ++sa;
        }
        System.out.println("done.");
    }

    public ShipTracker() {
        this.keyBuf = new int[3];
        this.reset();
    }

    public void reset() {
        this.ship = null;
        this.pos = null;
        this.start(0);
    }

    public void start(int frameNo) {
        this.curFrame = frameNo;
        this.shipDetected = 0;
        this.visible = false;
    }

    public void cleanup() {
        if (!this.visible) {
            int i = 0;
            while (i < 3) {
                this.keyBuf[i] = 0;
                ++i;
            }
            this.keyIndex = 0;
            this.vx &= 0xFF;
            this.vy &= 0xFF;
        }
    }

    public Ship getShip() {
        return this.visible ? this.ship : null;
    }

    public void trackShip(int sx, int sy, int dx, int dy, int keys) {
        this.keyBuf[this.keyIndex++] = keys;
        this.keyIndex %= 3;
        switch (this.shipDetected) {
            case 0: {
                this.xTmp = dx;
                this.yTmp = dy;
                ++this.shipDetected;
                break;
            }
            case 1: {
                ++this.shipDetected;
                if (this.ship == null) {
                    this.px = sx << 3;
                    this.py = sy << 3;
                    this.vx = 0;
                    this.vy = 0;
                    this.pos = null;
                    this.speed = null;
                    this.angleTracker.initializeAngle(this.xTmp - dx, this.yTmp - dy);
                    this.ship = new Ship(this.getPos(), this.angleTracker.getDir(), this.angleTracker.getAngle());
                } else {
                    this.angleTracker.updateAngle(this.xTmp - dx, this.yTmp - dy, this.keyBuf[this.keyIndex]);
                    this.updateSpeed(sx, sy, this.angleTracker.getAngle(), this.keyBuf[this.keyIndex]);
                    this.updatePosition(sx, sy);
                }
                this.visible = true;
            }
        }
    }

    public Position getPos() {
        if (this.pos == null) {
            this.pos = new Position(this.px, this.py);
        }
        return this.pos;
    }

    public ScreenVector getSpeed() {
        if (this.speed == null) {
            this.speed = new ScreenVector(this.vx >> 5, this.vy >> 5);
        }
        return this.speed;
    }

    private void updatePosition(int sx, int sy) {
        this.px = sx << 3;
        this.py = sy << 3;
        this.pos = null;
        this.ship.update(this.getPos(), this.angleTracker.getDir(), this.angleTracker.getAngle(), this.getSpeed());
    }

    private void updateSpeed(int sx, int sy, int angle, int keys) {
        this.vx = (sx << 3) - this.px << 5;
        this.vy = (sy << 3) - this.py << 5;
        this.speed = null;
    }

    public void setThrustEnable(boolean enable) {
        this.thrustEnable = enable;
    }
}

