/*
 * Decompiled with CFR 0.152.
 */
package de.heise.asteroid.model;

import de.heise.asteroid.Position;
import de.heise.asteroid.ScreenVector;
import de.heise.asteroid.model.MovingObject;
import de.heise.asteroid.util.SimpleMath;

public class Ship
extends MovingObject {
    protected ScreenVector orientation;
    protected ScreenVector dir;
    protected int angle;

    public Ship(Position p, ScreenVector o, int a) {
        super(p);
        this.orientation = o;
        this.angle = a;
        this.dir = new ScreenVector(SimpleMath.astCos[this.angle], SimpleMath.astSin[this.angle]);
        this.speed = ScreenVector.NULL_VECTOR;
    }

    public int getAngle() {
        return this.angle;
    }

    public ScreenVector getOrientation() {
        return this.orientation;
    }

    public ScreenVector getDir() {
        return this.dir;
    }

    public void update(Position p, ScreenVector o, int a, ScreenVector sp) {
        this.pos = p;
        this.orientation = o;
        this.angle = a;
        this.dir = new ScreenVector(SimpleMath.astCos[this.angle], SimpleMath.astSin[this.angle]);
        this.speed = sp;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("ship:").append(super.toString()).append(';').append(this.orientation);
        return str.toString();
    }
}

