/*
 * Decompiled with CFR 0.152.
 */
package de.heise.asteroid.player;

import de.heise.asteroid.Position;
import de.heise.asteroid.ScreenVector;
import de.heise.asteroid.engine.Engine;
import de.heise.asteroid.model.Asteroid;
import de.heise.asteroid.model.Saucer;
import de.heise.asteroid.model.Ship;
import de.heise.asteroid.player.AbstractPlayer;
import de.heise.asteroid.util.SimpleMath;
import java.util.List;

public class ModifiedSamplePlayer
extends AbstractPlayer {
    private static final double maxSinPhi = 0.9;
    private static final Position centerPos = new Position(4096, 4096);
    private boolean hasFired = false;
    private boolean initialized = false;
    private Ship ship;

    public ModifiedSamplePlayer(Engine e) {
        super(e);
    }

    public void play() {
        this.ship = this.status.getShip();
        Saucer saucer = this.status.getSaucer();
        this.releaseKeys();
        if (this.ship == null) {
            this.initialized = false;
            this.sendKeys(this.curFrame);
        } else if (!this.initialized) {
            this.pressKey((byte)16);
            this.sendKeys(this.curFrame);
            this.releaseKeys();
            this.sendKeys(this.curFrame + 6);
            this.waitForFrame(this.curFrame + 8);
            this.initialized = true;
        } else {
            int danger;
            int d;
            int minSqDist = Integer.MAX_VALUE;
            ScreenVector targetDist = null;
            ScreenVector targetSpeed = null;
            ScreenVector targetDir = null;
            int targetRadius = 0;
            List<Asteroid> asteroids = this.status.getAsteroids();
            for (Asteroid ast : asteroids) {
                ScreenVector dir;
                if (ast.isExploding()) continue;
                ScreenVector distVector = this.ship.getDistanceTo(ast);
                distVector.normalize();
                int sqDist = distVector.sqAbs();
                if ((sqDist -= ast.getRadius() * ast.getRadius()) >= minSqDist || (dir = this.getTargetAngle(distVector, ast.getSpeed())) == null) continue;
                targetDir = dir;
                minSqDist = sqDist;
                targetDist = distVector;
                targetSpeed = ast.getSpeed();
                targetRadius = ast.getRadius();
            }
            if (saucer != null && !saucer.isExploding()) {
                ScreenVector dir;
                ScreenVector distVector = this.ship.getDistanceTo(saucer);
                distVector.normalize();
                int sqDist = distVector.sqAbs();
                if ((sqDist -= saucer.getSize().getDistanceCorrection()) >> 3 < minSqDist && (dir = this.getTargetAngle(distVector, saucer.getSpeed())) != null) {
                    targetDir = dir;
                    minSqDist = sqDist;
                    targetDist = distVector;
                    targetSpeed = saucer.getSpeed();
                    targetRadius = saucer.getRadius();
                }
            }
            if (targetDist != null && targetSpeed != null && targetDir != null) {
                this.turnOrFire(targetDir);
                if (minSqDist > 10000000) {
                    this.pressKey((byte)4);
                }
            } else if (asteroids.isEmpty() && (d = (int)Math.round((targetDir = this.ship.getPos().getDistanceTo(centerPos)).abs())) > 1800) {
                int crossCenter = this.getCrossProd(this.ship.getAngle(), targetDir);
                if (crossCenter > 0) {
                    this.pressKey((byte)16);
                } else if (crossCenter < 0) {
                    this.pressKey((byte)8);
                }
                if (Math.abs(crossCenter) < d * 10) {
                    this.pressKey((byte)4);
                }
            }
            if (minSqDist < (danger = targetRadius + 200) * danger) {
                this.pressKey((byte)1);
                this.releaseKey((byte)28);
            }
            this.sendKeys(this.curFrame);
        }
    }

    private void turnOrFire(ScreenVector targetDir) {
        int shipAngle = this.ship.getAngle();
        int crossLeft = this.getCrossProd(shipAngle + 3 & 0xFF, targetDir);
        if (crossLeft >= 0) {
            this.pressKey((byte)16);
            this.hasFired = false;
        } else {
            int crossRight = this.getCrossProd(shipAngle - 3 & 0xFF, targetDir);
            if (crossRight <= 0) {
                this.pressKey((byte)8);
                this.hasFired = false;
            } else if (this.hasFired) {
                this.hasFired = false;
            } else {
                this.pressKey((byte)2);
                this.hasFired = true;
            }
        }
    }

    private int getCrossProd(int angle, ScreenVector targetDir) {
        ScreenVector shipDir = new ScreenVector(SimpleMath.astCos[angle], SimpleMath.astSin[angle]);
        return shipDir.crossProduct2D(targetDir);
    }

    private ScreenVector getTargetAngle(ScreenVector targetDist, ScreenVector targetSpeed) {
        double dVb = 63.0 * targetDist.abs();
        double delta = Math.atan2(targetDist.getY(), targetDist.getX());
        double sinPhi = (double)targetSpeed.diff(this.ship.getSpeed()).crossProduct2D(targetDist) / dVb;
        if (sinPhi <= 0.9 && sinPhi >= -0.9) {
            double phi = Math.asin(sinPhi);
            double sigma = delta - phi;
            return new ScreenVector((int)(100.0 * Math.cos(sigma)), (int)(100.0 * Math.sin(sigma)));
        }
        return null;
    }

    public String getInitials() {
        return "MOE";
    }
}

