/*
 * Decompiled with CFR 0.152.
 */
package de.heise.asteroid.util;

import de.heise.asteroid.util.WorkerRunnable;

public class Worker
extends Thread
implements WorkerRunnable {
    private boolean term;
    private WorkerRunnable runnable;

    public Worker(String name) {
        super(name);
        this.runnable = this;
    }

    public Worker(String name, WorkerRunnable r) {
        super(name);
        this.runnable = r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        this.term = false;
        this.runnable.workerInitialize();
        while (!this.term) {
            try {
                if (this.runnable.workerMainLoop()) continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            break;
        }
        this.runnable.workerFinalize();
        Worker worker = this;
        synchronized (worker) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void terminate() {
        Worker worker = this;
        synchronized (worker) {
            System.out.println("About to terminate " + this.getName());
            this.term = true;
            if (this.isAlive()) {
                this.interrupt();
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.out.println(String.valueOf(this.getName()) + " terminated.");
            } else {
                System.out.println(String.valueOf(this.getName()) + " had already terminated.");
            }
        }
    }

    protected final boolean mustTerminate() {
        return this.term;
    }

    public void workerInitialize() {
    }

    public boolean workerMainLoop() {
        System.err.println("Worker " + this.getName() + ": nothing to do, will terminate immediateley");
        return false;
    }

    public void workerFinalize() {
    }
}

