/**
 * File:    Explosion.java
 * Package: de.heise.asteroid.engine
 * Created: 15.06.2008 21:10:00
 * Author:  Chr. Moellenberg
 *
 * Copyright (c) 2008 by Chr. Moellenberg
 */

package de.heise.asteroid.engine;


/**
 * @author Chr. Moellenberg
 *
 */
public class Explosion {
   private static int[] typeSequence = {
      GameStatus.EXPL_1, GameStatus.EXPL_3, GameStatus.EXPL_0, GameStatus.EXPL_2, GameStatus.EXPL_3, 
      GameStatus.EXPL_0, GameStatus.EXPL_1, GameStatus.EXPL_2, GameStatus.EXPL_3, GameStatus.EXPL_0, 
      GameStatus.EXPL_1, GameStatus.EXPL_2, GameStatus.EXPL_2, GameStatus.EXPL_3, GameStatus.EXPL_0, 
      GameStatus.EXPL_0, GameStatus.EXPL_1, GameStatus.EXPL_1, GameStatus.EXPL_2, GameStatus.EXPL_2,
      GameStatus.EXPL_3, GameStatus.EXPL_3, GameStatus.EXPL_0, GameStatus.EXPL_0, GameStatus.EXPL_0, 
      GameStatus.EXPL_1, GameStatus.EXPL_1, GameStatus.EXPL_1, GameStatus.EXPL_1, GameStatus.EXPL_2, 
      GameStatus.EXPL_2, GameStatus.EXPL_2, GameStatus.EXPL_2, GameStatus.EXPL_3, GameStatus.EXPL_3, 
      GameStatus.EXPL_3, GameStatus.EXPL_3
   };
   private static int[] scaleSequence = {
      11, 11, 12, 12, 12, 13, 13, 13, 13, 14, 14, 14, 14, 14, 15, 15, 15, 15, 15, 15,
      15, 15,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
   };
   private static int[] scaleIndex = { 22, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 2, 5, 9, 14 };

   private int index;
   private int curFrame;
   private int baseFrame;
   private int x;
   private int y;

   public Explosion(int frameNo, int sx, int sy, int t, int s) {
      baseFrame = frameNo;
      curFrame = frameNo;
      x = sx;
      y = sy;
      int index = getAnimationIndex(t, s);
      baseFrame = curFrame - index;
   }

   public boolean match(int frameNo, int sx, int sy, int t, int s) {
      curFrame = frameNo;
      int index = curFrame - baseFrame;
      if (sx != x || sy != y) {
         return false;
      }
      if (index < 0 || index > 36) {
         System.out.printf("Explosion index %d is out of range [0..36]\n", index);
         return false;
      }
      if (t != typeSequence[index]) {
         System.out.printf("Explosion type %d does not match typeSequence[%d] (%d)\n", t, index, typeSequence[index]);
         return false;
      }
      if (s != scaleSequence[index]) {
         System.out.printf("Explosion scale %d does not match scaleSequence[%d] (%d)\n", s, index, scaleSequence[index]);
         return false;
      }
      return true;
   }

   public int getIndex() {
      return index;
   }

   public int getFramesRemaining(int frameNo) {
      return 37 - (frameNo - baseFrame);
   }

   /**
    * Returns the index of the explosion sequence for a given type-size pair. 
    * Caution: For indices greater than 11 this pair is ambiguous!
    * 
    * @param t the explosion animation type
    * @param s the size
    * @return the index, if appropriate, otherwise -1
    */
   private static int getAnimationIndex(int t, int s) {
      if (s >= 0 && s < 16) {
         for (int i = scaleIndex[s]; i < 37 && scaleSequence[i] == s; ++i) {
            if (t == typeSequence[i]) {
               return i;
            }
         }
      }
      return -1;
   }
}
