/**
 * File:    IdleProcessor.java
 * Package: de.heise.asteroid
 * Created: 04.06.2008 00:43:59
 * Author:  Chr. Moellenberg
 *
 * Copyright (c) 2008 by Chr. Moellenberg
 */

package de.heise.asteroid.engine;


/**
 * @author Chr. Moellenberg
 *
 */
public class IdleProcessor implements FrameProcessor {
   private Engine engine;

   /**
    * Associates this processor with the given <code>Engine</code>.
    *  
    * @param e the <code>Engine</code>
    */
   public IdleProcessor(Engine e) {
      engine = e;
   }

   /* (non-Javadoc)
    * @see de.heise.asteroid.FrameProcessor#initialize()
    */
   public void initialize() {
      System.gc();
   }

   /* (non-Javadoc)
    * @see de.heise.asteroid.FrameProcessor#process(de.heise.asteroid.GameStatus, int)
    */
   public void process(GameStatus status, int frameNo) {
      engine.sendKeys(KEY_NONE, frameNo);
   }
}
