package de.heise.asteroid.model;

import de.heise.asteroid.Position;
import de.heise.asteroid.ScreenVector;
import de.heise.asteroid.engine.GameStatus;

/**
 * The <code>Asteroid</code> class represents an asteroid. It is a 
 * <code>Target</code> that also has a type.
 *
 * @author Chr. Moellenberg
 * @see GameStatus
 */
public class Asteroid extends Target {
	private int type;
	private int size;
   private int radius;

	/**
	 * Initializes a new asteroid.
	 * 
	 * @param frameNo the frame number when this <code>Asteroid</code> was detected
	 * @param p the position of this <code>Asteroid</code>
	 * @param t the type of <code>Asteroid</code> (may be an explosion)
	 * @param s the size of the <code>Asteroid</code>
    * @param sp the initial speed of the <code>Asteroid</code>
	 */
	public Asteroid(Position p, ScreenVector sp, int t, int s) {
		super(p, sp);
		type = t;
      size = s;
      exploding = GameStatus.isExplosionType(t);
      switch (size) {
         case 14: // small
            radius =  8 << 3;
            break;
         case 15: // medium
            radius = 16 << 3;
            break;
         default: // big
            radius =  32 << 3;
         break;
      }
	}

	/**
	 * Returns the asteroids type.
	 * @return the type
	 */
	public int getType() {
		return type;
	}

   /**
	 * Returns the size of this <code>Asteroid</code>.
	 * 
	 * @return the size
	 */
	public int getSize() {
		return size;
	}

	/* (non-Javadoc)
	 * @see de.heise.asteroid.model.Target#getRadius()
	 */
	public int getRadius() {
	   return radius;
	}

	/* (non-Javadoc)
	 * @see de.heise.asteroid.model.MovingObject#toString()
	 */
	@Override
   public String toString() {
      StringBuilder str = new StringBuilder();
      str.append("asteroid:").append(type).append(';').append(super.toString()).append(';').append(size);
      return str.toString();
   }
}
