package de.heise.asteroid.model;

import de.heise.asteroid.Position;
import de.heise.asteroid.ScreenVector;
import de.heise.asteroid.engine.GameStatus;

/**
 * The <code>Saucer</code> class represents a flying saucer. It is a <code>Target</code> 
 * that also has a size.
 * 
 * @author Chr. Moellenberg
 * @see GameStatus
 */
public class Saucer extends Target {
	/**
	 * The <code>Size</code> enumeration represents the size of a flying saucer.
	 * <p>
	 * There are two different sizes.
	 */
	public enum Size {
		BIG() {
			public int getDistanceCorrection() { return 20 * 12;}
		},
		SMALL() {
			public int getDistanceCorrection() { return 10 * 6;}
		};
		/**
		 * Returns a correction value for the squared distance.
		 * The calculation <code>width / 2</code> * <code>height / 2</code> is just an approximation.
		 * @return the correction value for the squared distance
		 */
		abstract public int getDistanceCorrection();
	}

	protected Size size;

	/**
	 * Initializes a new flying saucer with given position and size.
	 * 
	 * @param p the initial position of this <code>Saucer</code>
	 * @param s the size of this <code>Saucer</code>
    * @param sp the initial speed of this <code>Saucer</code>
	 */
	public Saucer(Position p, Size s, ScreenVector sp) {
		super(p, sp);
		size = s;
	}

	/**
	 * Returns the flying saucers size.
	 * @return the size
	 */
	public Size getSize() {
		return size;
	}

	/* (non-Javadoc)
	 * @see de.heise.asteroid.model.Target#getRadius()
	 */
	public int getRadius() {
	   return (size.equals(Size.BIG)) ? 20 * 12 : 10 * 6;
	}

	/* (non-Javadoc)
	 * @see de.heise.asteroid.model.MovingObject#toString()
	 */
	@Override
   public String toString() {
      StringBuilder str = new StringBuilder();
      str.append("saucer:").append(super.toString()).append(";").append(size);
      return str.toString();
   }
}
