/**
 * File:    AbstractPlayer.java
 * Package: de.heise.asteroid
 * Created: 21.05.2008 19:15:41
 * Author:  Chr. Moellenberg
 *
 * Copyright (c) 2008 by Chr. Moellenberg
 */

package de.heise.asteroid.player;

import de.heise.asteroid.engine.AbstractProcessor;
import de.heise.asteroid.engine.Engine;
import de.heise.asteroid.engine.GameStatus;

/**
 * A base class for all player strategies.
 *
 * @author Chr. Moellenberg
 */
public abstract class AbstractPlayer extends AbstractProcessor implements Player {
   protected int waitFrame;
   protected int curFrame;
   protected GameStatus status;

   /**
    * Associates this player with the given <code>Engine</code>.
    *  
    * @param e the <code>Engine</code>
    */
   public AbstractPlayer(Engine e) {
      super (e);
      waitFrame = -1;
   }

   /* (non-Javadoc)
    * @see de.heise.asteroid.FrameProcessor#initialize()
    */
   public void initialize() {
      releaseKeys();
   }
   
   /* (non-Javadoc)
    * @see de.heise.asteroid.engine.FrameProcessor#process(de.heise.asteroid.engine.GameStatus, int)
    */
   public void process(GameStatus s, int frameNo) {
      status = s;
      curFrame = frameNo;
      if (status != null && curFrame >= waitFrame) {
         play();
      }
   }
   
   protected void waitForFrame(int frameNo) {
      waitFrame = frameNo;
   }

   /**
    * Performs the actual player strategy.
    */
   protected abstract void play();
}
