/**
 * File:    Player.java
 * Package: de.heise.asteroid
 * Created: 21.05.2008 19:47:16
 * Author:  Chr. Moellenberg
 *
 * Copyright (c) 2008 by Chr. Moellenberg
 */

package de.heise.asteroid.player;

import de.heise.asteroid.engine.FrameProcessor;

/**
 * A <code>Player</code> is a <code>FrameProcessor</code> that offers 
 * a three-letter character sequence as initials to be entered in the 
 * Hall Of Fame - in case the player's strategy turns out to be good 
 * enough. ;-)
 * 
 * @author Chr. Moellenberg
 */
public interface Player extends FrameProcessor {
   /**
    * Returns the initials to be entered in the highscore list. Only the first 
    * three letters are used. Only letters and blanks are valid. Shorter initials 
    * are padded with blanks, invalid characters are replaced with blanks.
    * 
    * @return the initials
    */
   public String getInitials();
}
