/**
 * File:    StopWatch.java
 * Package: de.heise.asteroid.util
 * Created: 27.04.2008 20:35:58
 * Author:  Chr. Moellenberg
 *
 * Copyright (c) 2008 by Chr. Moellenberg
 */

package de.heise.asteroid.util;

/**
 * @author Chr. Moellenberg
 *
 */
public class StopWatch {
   private long startTime;
   private long stopTime;
   private boolean running = false;
   
   /**
    * Starts the watch.
    */
   public void start() {
      startTime = System.nanoTime();
      running = true;
   }
   
   /**
    * Stops the watch.
    */
   public void stop() {
      stopTime = System.nanoTime();
      running = false;
   }
   
   /**
    * Returns the time elapsed in microseconds since <code>start()</code>.
    * If <code>stop()</code> has been called in the meantime, the distance
    * between <code>start()</code> and <code>stop()</code> is returned 
    * instead.
    * @return the elapsed time in microseconds
    */
   public long elapsedMicrons() {
      return (running ? System.nanoTime() - startTime : stopTime - startTime) / 1000;
   }
}
