/**
 * File:    WorkerRunnable.java
 * Package: de.heise.asteroid.util
 * Created: 21.06.2008 17:02:38
 * Author:  Chr. Moellenberg
 *
 * Copyright (c) 2008 by Chr. Moellenberg
 */

package de.heise.asteroid.util;

/**
 * @author Chr. Moellenberg
 *
 */
public interface WorkerRunnable {
   /**
    * The initialization method of the worker, called once before the main loop is entered.
    */
   public void workerInitialize();

   /**
    * The main function of the worker. Must be implemented in a derived class.
    * 
    * @returns <code>false</code> if the worker should terminate, otherwise <code>true</code> 
    */
   public boolean workerMainLoop();

   /**
    * The finalization method of the worker, called once after the main loop has been left.
    */
   public void workerFinalize();
}
