/*
 * Decompiled with CFR 0.152.
 */
package se.jupp.asteroids;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.LinkedList;
import java.util.List;
import se.jupp.asteroids.Asteroid;
import se.jupp.asteroids.Game;
import se.jupp.asteroids.GameObject;
import se.jupp.asteroids.Position;
import se.jupp.asteroids.Ship;

public class Bullet
extends GameObject {
    private static final int BIG_MAX_SQUARED_DIST = 350;
    private static final int SMALL_MAX_SQUARED_DIST = 10;
    Ship ship;
    Game.Hit hit;
    boolean willHit = false;
    boolean future = false;
    List<Asteroid> virtual = new LinkedList<Asteroid>();
    Position origVelocity = null;

    public Bullet(Position pos, Ship ship, int timeBorn) {
        super(pos, 0, timeBorn);
        if (ship != null && this.pos.distanceSquared(ship.pos) < 450) {
            this.ship = ship;
            this.origVelocity = this.velocity = ship.bulletSpeed();
            this.hit = ship.hits.poll();
            if (this.hit != null) {
                this.willHit = true;
            }
            ship.registerBullet(this);
        }
    }

    public Bullet(Position pos, Position velocity, int timeBorn) {
        super(pos, 0, timeBorn);
        this.velocity = velocity;
        this.future = true;
    }

    public int timeToCollision(GameObject b, int future) {
        if (this.future) {
            int t = super.timeToCollision(b, future + 2);
            if (t >= 0 && t < 70) {
                return t + 2;
            }
            return -1;
        }
        return super.timeToCollision(b, future);
    }

    boolean target(GameObject t) {
        return this.hit != null && this.hit.enemy == t;
    }

    boolean match(Position pos) {
        if (pos == null) {
            return false;
        }
        int max = this.age == 0 ? 350 : 10;
        Position np = this.pos.add(this.velocity);
        int dist2 = np.distanceSquared(pos);
        return dist2 <= max;
    }

    void update(Position pos) {
        super.update(pos);
        if (pos != null) {
            Position v;
            if (this.age == 8) {
                v = pos.subtract(this.bornAt).divide(this.age).normalize();
                if (!v.equals(this.velocity)) {
                    this.velocity = v;
                }
                this.pos = this.pos.add(this.velocity).unnormalize();
            } else if (this.age < 8) {
                this.pos = pos;
                v = pos.subtract(this.bornAt).divide(this.age).normalize();
                if (!this.velocity.equals(this.origVelocity) || v.distanceSquared(this.velocity) > 10) {
                    this.velocity = v;
                }
            } else {
                this.pos = this.pos.add(this.velocity).unnormalize();
            }
        }
        if (this.age == 8 && this.ship != null) {
            this.ship.calibrate(this);
        }
        if (this.hit != null && this.age > 8) {
            int t = this.timeToCollision(this.hit.enemy, 0);
            this.willHit = t >= 0 && t < 70;
        }
        if (pos == null && this.ship != null) {
            this.ship.deregisterBullet(this);
        }
    }

    public int getSize() {
        return 0;
    }

    public void draw(Graphics2D g) {
        g.setColor(Color.white);
        g.fillOval(this.pos.x() - 1, this.pos.y() - 1, 3, 3);
        this.drawVelocityVector(g);
    }

    public String toString() {
        return "Bullet@" + this.id + this.pos + " velocity " + this.velocity + " age " + this.age;
    }
}

