/*
 * Decompiled with CFR 0.152.
 */
package se.jupp.asteroids;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import javax.swing.JComponent;
import se.jupp.asteroids.Frame;
import se.jupp.asteroids.FrameListener;
import se.jupp.asteroids.Game;
import se.jupp.asteroids.GameData;

public class FrameDisplay
extends JComponent
implements FrameListener,
GameData {
    private static final long serialVersionUID = 1L;
    private Game game;
    private AffineTransform trafo;

    public FrameDisplay(int width, Game game) {
        Dimension size = new Dimension(width, 3 * width / 4);
        this.game = game;
        this.setMaximumSize(size);
        this.setMinimumSize(size);
        this.setPreferredSize(size);
        this.setOpaque(true);
        this.setDoubleBuffered(true);
        double scaling = (double)width / 1024.0;
        this.trafo = AffineTransform.getTranslateInstance(0.0, -896.0);
        this.trafo.preConcatenate(AffineTransform.getScaleInstance(scaling, -scaling));
    }

    public void paint(Graphics g) {
        g.setColor(Color.black);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.game != null) {
            Graphics2D g2 = (Graphics2D)g;
            g2.transform(this.trafo);
            this.game.draw(g2);
        }
    }

    public void frameReceived(Frame frame) {
        this.repaint();
    }
}

