/*
 * Decompiled with CFR 0.152.
 */
package se.jupp.asteroids;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import se.jupp.asteroids.GameData;
import se.jupp.asteroids.Position;

public abstract class GameObject
implements GameData,
Cloneable {
    private static final int ARROW_HEAD_SIZE = 8;
    private static final GeneralPath ARROW_HEAD = new GeneralPath();
    int id;
    private static int counter;
    Position pos;
    Position velocity;
    Position bornAt;
    int age;
    int timeBorn;
    boolean dangerous;
    int r;

    static {
        ARROW_HEAD.moveTo(0.0f, 0.0f);
        ARROW_HEAD.lineTo(-8.0f, 8.0f);
        ARROW_HEAD.lineTo(-8.0f, -8.0f);
        ARROW_HEAD.closePath();
        counter = 0;
    }

    protected GameObject(Position pos, int r, int timeBorn) {
        this.pos = pos;
        this.bornAt = pos;
        this.velocity = new Position();
        this.age = 0;
        this.timeBorn = timeBorn;
        this.r = r;
        this.id = counter++;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    void update(Position pos) {
        ++this.age;
    }

    public abstract int getSize();

    public void draw(Graphics2D g) {
        g.setColor(Color.GREEN);
        g.drawOval(this.pos.x() - this.r, this.pos.y() - this.r, 2 * this.r, 2 * this.r);
        this.drawVelocityVector(g);
    }

    public int getSquaredSize() {
        int size = this.getSize();
        return size * size;
    }

    public int timeToCollision(GameObject b, int future) {
        Position bpos = future > 0 ? b.pos.add(b.velocity.multiply(future)).normalize() : b.pos;
        return Position.timeToCollision2(bpos.subtract(this.pos).normalize(), b.velocity.subtract(this.velocity).normalize(), this.r + b.r);
    }

    protected void drawVelocityVector(Graphics2D g) {
        if (this.velocity.square() != 0) {
            int scale = 16;
            g.setColor(Color.red);
            Position f = this.pos.add(this.velocity.multiply(scale));
            this.pos.unnormalize().drawLine(f, g);
            f = f.unnormalize();
            AffineTransform at = AffineTransform.getTranslateInstance(f.x(), f.y());
            at.concatenate(AffineTransform.getRotateInstance(this.velocity.getAngle()));
            g.fill(at.createTransformedShape(ARROW_HEAD));
        }
    }
}

