/*
 * Decompiled with CFR 0.152.
 */
package se.jupp.asteroids;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import se.jupp.asteroids.Frame;
import se.jupp.asteroids.GameObject;
import se.jupp.asteroids.Position;

public class Ufo
extends GameObject {
    private static final GeneralPath BIG = new GeneralPath();
    private static final GeneralPath SMALL;
    private final boolean big;
    int lastTurn;
    Position turnPos;

    static {
        int w = 24;
        int h = 8;
        BIG.moveTo(-w, 0.0f);
        BIG.lineTo(w, 0.0f);
        BIG.lineTo(w / 2, -h);
        BIG.lineTo(-w / 2, -h);
        BIG.lineTo(-w, 0.0f);
        BIG.lineTo(-w / 2, h);
        BIG.lineTo(w / 2, h);
        BIG.lineTo(w, 0.0f);
        BIG.moveTo(-h, h);
        BIG.lineTo(-2 * h / 3, 2 * h);
        BIG.lineTo(2 * h / 3, 2 * h);
        BIG.lineTo(h, h);
        SMALL = new GeneralPath(BIG);
        SMALL.transform(AffineTransform.getScaleInstance(0.5, 0.5));
    }

    public Ufo(Frame.UfoPos pos, int timeBorn) {
        super(pos, pos.size == 15 ? 16 : 8, timeBorn);
        this.big = pos.size == 15;
        this.lastTurn = this.age;
        this.turnPos = pos;
    }

    void update(Frame.UfoPos pos) {
        super.update(pos);
        if (pos != null) {
            if (this.age - this.lastTurn <= 8) {
                this.pos = pos;
                this.velocity = pos.subtract(this.turnPos).divide(this.age - this.lastTurn).normalize();
            } else {
                int deviation = pos.distanceSquared(this.pos.add(this.velocity));
                if (deviation > 20) {
                    this.lastTurn = this.age;
                    this.turnPos = this.pos = pos;
                } else {
                    this.pos = this.pos.add(this.velocity);
                }
            }
        }
    }

    public int getSize() {
        return this.big ? 16 : 8;
    }

    public void draw(Graphics2D g) {
        if (this.dangerous) {
            g.setColor(Color.RED);
        } else {
            g.setColor(Color.white);
        }
        g.draw(AffineTransform.getTranslateInstance(this.pos.x(), this.pos.y()).createTransformedShape(this.big ? BIG : SMALL));
        this.drawVelocityVector(g);
        super.draw(g);
    }

    public String toString() {
        return "Ufo@" + this.pos;
    }
}

