package se.jupp.asteroids;

import java.io.IOException;

import javax.swing.JFrame;

public class AsteroidsPlayer {
    public static final String DEFAULT_HOSTNAME = "127.0.0.1";

    public static void main(String[] args) {
        String hostname = DEFAULT_HOSTNAME;
        boolean withDisplay = false;
        for (String arg : args)
            if ("-d".equals(arg))
                withDisplay = true;
            else
                hostname = arg;
        try {
            Communication com = new Communication(hostname);
            Game g = new Game(com);
            com.addFrameListener(g);

            if (withDisplay) {
                JFrame frame = new JFrame("Frame Display");
                FrameDisplay display = new FrameDisplay(640, g);
                frame.getContentPane().add(display);
                frame.pack();
                frame.setVisible(true);
                frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
                com.addFrameListener(display);
            }
        } catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}
