/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid;

import de.caff.asteroid.Asteroid;
import de.caff.asteroid.Bullet;
import de.caff.asteroid.Communication;
import de.caff.asteroid.FrameInfo;
import de.caff.asteroid.FrameListener;
import de.caff.asteroid.FramePreparer;
import de.caff.asteroid.FramePreparerSequence;
import de.caff.asteroid.GameData;
import de.caff.asteroid.HallOfFameFiller;
import de.caff.asteroid.ScoreFixer;
import de.caff.asteroid.SimpleVelocityPreparer;
import de.caff.asteroid.SizedGameObject;
import de.caff.asteroid.SpaceShip;
import de.caff.asteroid.Ufo;
import java.awt.Point;
import java.util.Collection;

public class GeorgsFirstAsteroidPlayer
implements FrameListener,
GameData {
    private static final String Bullet = null;
    private boolean shot;
    private Communication com;

    public GeorgsFirstAsteroidPlayer(Communication com) {
        this.com = com;
        com.setFramePreparer(new FramePreparerSequence(new FramePreparer[]{new SimpleVelocityPreparer(), new ScoreFixer()}));
        com.addFrameListener(new HallOfFameFiller(com, "bo"));
    }

    void start(SpaceShip ship, Communication com) {
        com.pushButton(32);
    }

    @Override
    public void frameReceived(FrameInfo frame) {
        if (frame == null) {
            return;
        }
        SpaceShip ship = frame.getSpaceShip();
        if (ship == null) {
            return;
        }
        if (this.avoidCollision(ship, frame)) {
            return;
        }
        SizedGameObject target = GeorgsFirstAsteroidPlayer.findNearestTarget(ship, frame);
        if (target == null) {
            if (frame.getTargetCount() > 0) {
                this.com.pushButton(4);
            }
        } else {
            Point delta = ship.getDelta(target);
            int dist2 = delta.x * delta.x + delta.y * delta.y;
            if (dist2 < 961) {
                this.com.pushButton(1);
            } else if (ship.getDirX() * delta.y - ship.getDirY() * delta.x > 0) {
                this.com.pushButton(16);
            } else {
                this.com.pushButton(8);
            }
        }
        this.com.setButton(2, this.shot);
        this.shot = !this.shot;
    }

    private boolean avoidCollision(SpaceShip ship, FrameInfo frame) {
        int escapeFrames = 50;
        int timeToCollision = 0;
        for (Bullet bullet : frame.getBullets()) {
            timeToCollision = this.objectsCollidingInFrames(ship, bullet);
            if (timeToCollision <= 0 || timeToCollision > 50 || bullet.getLifetime() < timeToCollision) continue;
            System.out.println("bullet");
            this.com.pushButton(16);
            this.com.pushButton(4);
            return true;
        }
        SizedGameObject target = this.findNearestCollidingTarget(ship, frame.getAsteroids(), 50);
        if (target != null) {
            Point delta = ship.getDelta(target);
            if (ship.getDirX() * delta.y - ship.getDirY() * delta.x > 0) {
                this.com.pushButton(16);
            } else {
                this.com.pushButton(8);
            }
            this.com.setButton(2, this.shot);
            this.shot = !this.shot;
            return true;
        }
        if (frame.getUfo() != null && (timeToCollision = this.objectsCollidingInFrames(ship, frame.getUfo())) > 0 && timeToCollision <= 50) {
            System.out.println("ufo " + timeToCollision);
            this.com.pushButton(16);
            this.com.pushButton(4);
            return true;
        }
        return false;
    }

    private SizedGameObject findNearestCollidingTarget(SpaceShip ship, Collection<Asteroid> asteroids, int escapeFrames) {
        Asteroid nearest = null;
        int minDist2 = 160000;
        for (Asteroid ast : asteroids) {
            int dist2;
            int collidingInFrames = this.objectsCollidingInFrames(ship, ast);
            if (collidingInFrames <= 0 || collidingInFrames >= escapeFrames || (dist2 = ship.getSquaredDistance(ast) - ast.getSquaredSize()) >= minDist2) continue;
            minDist2 = dist2;
            nearest = ast;
        }
        return nearest;
    }

    protected int objectsCollidingInFrames(SpaceShip ship, SizedGameObject object) {
        if (object.getVelocityX() == ship.getVelocityX() && object.getVelocityY() == ship.getVelocityY()) {
            return -1;
        }
        boolean velocityYsame = object.getVelocityY() == ship.getVelocityY();
        boolean velocityXsame = object.getVelocityX() == ship.getVelocityX();
        int timeX = 0;
        if (!velocityXsame) {
            timeX = (ship.x - object.x) / (object.getVelocityX() - ship.getVelocityX());
        }
        int timeY = 0;
        if (!velocityYsame) {
            timeY = (ship.y - object.y) / (object.getVelocityY() - ship.getVelocityY());
        }
        if (timeX < 0 || timeY < 0) {
            return -1;
        }
        int deltaXShip = 0;
        int deltaXObject = 0;
        int deltaYShip = 0;
        int deltaYObject = 0;
        if (ship.getVelocityX() != 0) {
            deltaXShip = ship.getSize() / ship.getVelocityX();
            deltaXShip = Math.abs(deltaXShip);
        }
        if (object.getVelocityX() != 0) {
            deltaXObject = object.getSize() / object.getVelocityX();
            deltaXObject = Math.abs(deltaXObject);
        }
        if (ship.getVelocityY() != 0) {
            deltaYShip = ship.getSize() / ship.getVelocityY();
            deltaYShip = Math.abs(deltaYShip);
        }
        if (object.getVelocityY() != 0) {
            deltaYObject = object.getSize() / object.getVelocityY();
            deltaYObject = Math.abs(deltaYObject);
        }
        int faktor = 1;
        if (!(ship.getVelocityX() > 0 && object.getVelocityX() > 0 || ship.getVelocityX() < 0 && object.getVelocityX() < 0)) {
            faktor = -1;
        }
        int timeX2 = timeX + faktor * Math.min(deltaXShip, deltaXObject);
        faktor = ship.getVelocityY() > 0 && object.getVelocityY() > 0 || ship.getVelocityY() < 0 && object.getVelocityY() < 0 ? 1 : -1;
        int timeY2 = timeY + faktor * Math.min(deltaYShip, deltaYObject);
        if (velocityXsame) {
            return timeY2;
        }
        if (velocityYsame) {
            return timeX2;
        }
        if (timeX2 >= timeY2 && timeX2 <= timeY2 && timeX >= timeY || timeX2 <= timeY2 && timeX >= timeY2 && timeX <= timeY) {
            return Math.min(timeX2, timeY2);
        }
        return -1;
    }

    private static SizedGameObject findNearestTarget(SpaceShip ship, FrameInfo info) {
        int dist2;
        SizedGameObject nearest = null;
        int minDist2 = 160000;
        for (Asteroid ast : info.getAsteroids()) {
            int dist22 = ship.getSquaredDistance(ast) - ast.getSquaredSize();
            if (dist22 >= minDist2) continue;
            minDist2 = dist22;
            nearest = ast;
        }
        Ufo ufo = info.getUfo();
        if (ufo != null && (dist2 = ship.getSquaredDistance(ufo) - ufo.getSquaredSize()) < minDist2) {
            nearest = ufo;
        }
        return nearest;
    }
}

